//
//  TransferBoltView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/28.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransferBoltView.h"
#import "MaskCell.h"

#define TableHeight 45
#define LeftMargin 80
#define TotalHeight 224
#define LeftHeight 44
#define BottomHeight 50

@interface TransferBoltView ()<UITextFieldDelegate>
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
    NSString *_state;
    NSString *_billNumber;
    NSString *_title;
    UIButton *_clearBtn;
}
@property (nonatomic,strong)NSString *state;
@property (nonatomic,strong)NSString *billNumber;
@property (nonatomic,strong)NSString *userNumber;
@property (nonatomic,strong)NSString *productNumber;

@end

@implementation TransferBoltView

- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state userNumber:(NSString *)userNumber billNumber:(NSString *)billNumber productNumber:(NSString *)productNumber{
    self = [super initWithFrame:frame];
    if (self) {
        self.userNumber = userNumber;
        self.billNumber = billNumber;
        self.state = state;
        self.productNumber = productNumber;
        [self createView];
        [self createRightView];
        [self preferData];
    }
    return self;
}
- (void)preferData{
    if ([self.state isEqualToString:TRANSPORT_STATE_INITIAL]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.state isEqualToString:TRANSPORT_STATE_UNRECEIVED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }else if ([self.state isEqualToString:TRANSPORT_STATE_RECEIVED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
    }else if ([self.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:3 inSection:0];
    }else if ([self.state isEqualToString:TRANSPORT_STATE_PROCESS]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:4 inSection:0];
    }else if ([self.state isEqualToString:TRANSPORT_STATE_PROCESSFAIL]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:5 inSection:0];
    }
    self.userFiled.hidden = YES;
    if(self.userNumber.length > 0){
        self.userFiled.text = self.userNumber;
    }
    self.billFiled.hidden = YES;
    if (self.billNumber.length > 0) {
        self.billFiled.text = self.billNumber;
    }
    self.productField.hidden = YES;
    if (self.productNumber.length > 0) {
        self.productField.text = self.productNumber;
    }
}

#pragma mark - 创建视图
- (void)createView
{
    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height- BottomHeight)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态",@"创建人代码",@"调研单号",@"商品"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:GXF_DETAIL_COLOR forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    _clearBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _clearBtn.frame = CGRectMake(0, CGRectGetMaxY(_leftView.frame), self.frame.size.width, BottomHeight);
    [_clearBtn setTitle:@"清空选项" forState:UIControlStateNormal];
    [_clearBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    _clearBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_clearBtn addTarget:self action:@selector(clearBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_clearBtn];
}
- (void)createRightView{
    
    
    NSArray *arr = @[@"输入类似创建人代码",@"输入类似调研单号",@"输入类似商品"];
    UIView *contentView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight)];
    contentView.backgroundColor = [UIColor whiteColor];
    [self addSubview:contentView];
    UILabel *contentLabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20)];
    contentLabel.font = GXF_FIFTEENTEN_SIZE;
    contentLabel.text = @"类似于：";
    [contentView addSubview:contentLabel];
    
    for (NSInteger i = 0; i < arr.count; i ++) {
        UITextField *contentField = [[UITextField alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(contentLabel.frame) + 10, (ScreenSize.width - LeftMargin - 10*2), 30)];
        contentField.textAlignment = NSTextAlignmentLeft;
        contentField.textColor = GXF_CONTENT_COLOR;
        contentField.borderStyle = UITextBorderStyleRoundedRect;
        contentField.font = GXF_FIFTEENTEN_SIZE;
        contentField.placeholder = arr[i];
        
        contentField.returnKeyType = UIReturnKeyDone;
        contentField.delegate = self;
        [contentView addSubview:contentField];
        if (i == 0) {
            self.userFiled = contentField;
        }else if(i == 1){
            self.billFiled = contentField;
        }else if(i == 2){
            self.productField = contentField;
        }
    }
    
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
    
}


- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [self keyBoardHidden];
    switch (btn.tag) {
        case 1001://状态
        {
            self.tableView.hidden = NO;
            self.userFiled.hidden = YES;
            self.billFiled.hidden = YES;
            self.productField.hidden = YES;
        }
            break;
        case 1002://条件二
        {
            self.tableView.hidden = YES;
            self.userFiled.hidden = NO;
            self.billFiled.hidden = YES;
            self.productField.hidden = YES;

        }
            break;
        case 1003://条件三
        {
            self.tableView.hidden = YES;
            self.userFiled.hidden = YES;
            self.billFiled.hidden = NO;
            self.productField.hidden = YES;

        }
            break;
        case 1004://条件三
        {
            self.tableView.hidden = YES;
            self.userFiled.hidden = YES;
            self.billFiled.hidden = YES;
            self.productField.hidden = NO;
            
        }
            break;
        default:
            break;
    }
}

- (void)clearBolt{
    if (_billFiled.text.length > 0) {
        _billFiled.text = @"";
    }
    if (_userFiled.text.length > 0) {
        _userFiled.text = @"";
    }
    if (_productField.text.length > 0) {
        _productField.text = @"";
    }
    if (_currentIndexPath) {
        _currentIndexPath = nil;
        [self.tableView reloadData];
    }
    if ([self.delegate respondsToSelector:@selector(clearBoltInformation)]) {
        [self.delegate clearBoltInformation];
    }
}

#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        cell.Commitbtn.hidden = YES;
        [cell setTitleStr:self.dataArr[indexPath.row]];
        
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    
    //initial(未提交)submitted(已提交)rejected(已拒绝)approved(已审批)shipping(发运中)finished(已完成)
    
    NSString *stateStr = @"";
    if (indexPath.row == 0) {
        stateStr = TRANSFER_STATE_INITIAL;
    }else if(indexPath.row == 1){
        stateStr = TRANSFER_STATE_UNRECEIVED;
    }else if(indexPath.row == 2){
        stateStr = TRANSFER_STATE_RECEIVED;
    }else if(indexPath.row == 3){
        stateStr = TRANSFER_STATE_ABORTED;
    }else if(indexPath.row == 4){
        stateStr = TRANSFER_STATE_PROCESS;
    }else if(indexPath.row == 5){
        stateStr = TRANSFER_STATE_PROCESSFAIL;
    }
    [self.delegate getBoltValueSelectRow:stateStr];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self keyBoardHidden];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self keyBoardHidden];
}
- (void)keyBoardHidden{
    [self.userFiled resignFirstResponder];
    [self.billFiled resignFirstResponder];
    [self.productField resignFirstResponder];
}

- (void)textFieldDidEndEditing:(UITextField *)textField{
    if (textField == self.userFiled) {
        //        if (self.userFiled.text.length > 0) {
        [self.delegate getuserLike:self.userFiled.text];
        //        }
    }else if(textField == self.billFiled){
        //        if (self.billFiled.text.length > 0) {
        [self.delegate getbillLike:self.billFiled.text];
        //        }
    }else if(textField == self.productField){
        //        if (self.billFiled.text.length > 0) {
        [self.delegate getproductLike:self.productField.text];
        //        }
    }
}

@end
