//
//  TransferPdtDetail.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/28.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransferPdtDetail.h"

@implementation TransferPdtDetail

- (void)setPurchasePdt:(PurchaseBillProduct *)purchasePdt {
    _purchasePdt = purchasePdt;
    self.productUuid = purchasePdt.product_uuid;
    self.productCode = purchasePdt.product_code;
    self.productName = purchasePdt.product_name;
    self.price = purchasePdt.basePrice;
    self.packprice = purchasePdt.price;
    self.rctQty = purchasePdt.receivedQty;
    self.rctBaseQty = purchasePdt.receivedBaseQty;
    
}

- (void)setTransportPdt:(TransportPdtDetail *)transportPdt {
    _transportPdt = transportPdt;
    self.rctQty = transportPdt.receivedQty;
    self.rctBaseQty = transportPdt.receivedBaseQty;
}

/**
 *  转化为采购单对象
 *
 *  @return return value description
 */
- (PurchaseBillProduct *)changeToPurchasePdt {
    if (!self.purchasePdt) {
        self.purchasePdt = [PurchaseBillProduct new];
        NSDictionary *dict = [self dictForCommit];
        [self.purchasePdt setValuesForKeysWithDictionary:dict];
    }
    self.purchasePdt.receivedQty = self.rctQty;
    self.purchasePdt.receivedBaseQty = self.rctBaseQty;
    return self.purchasePdt;
}

- (TransportPdtDetail *)changeToTransportPdt {
    if (!self.transportPdt) {
        self.transportPdt = [TransportPdtDetail new];
        NSDictionary *dict = [self dictForCommit];
        [self.transportPdt setValuesForKeysWithDictionary:dict];
    }
    self.transportPdt.receivedQty = self.rctQty;
    self.transportPdt.receivedBaseQty = self.rctBaseQty;
    return self.transportPdt;
}

- (void)z_setRctQty:(CGFloat)qty {
    //基础数量【实收】= 包装数量【实收】* 规格
    float baseCount = qty * [self.qpc floatValue];
    
    //总金额【实收】= 基础数量【实收】* 基础单价
    float total = 0;
    if (qty == [self.qty floatValue]) {
        total = [self.total floatValue];
    }else{
        total = baseCount * [self.price floatValue];
    }
    self.rctQty = [NSNumber numberWithFloat:qty];
    self.rctBaseQty = [NSNumber numberWithFloat:baseCount];
    self.rctTotal = [NSNumber numberWithFloat:total];
}
@end
