//
//  ReceiveProductCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ReceiveProductCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowWidth (ScreenSize.width  - LeftMargin*2 - SmallSize)/2
#define ShowHeight 20


@implementation ReceiveProductCell
- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (3 -1))/3;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    self.smallImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.textColor = GXF_CONTENT_COLOR;
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.dscountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.dscountLabel.textAlignment = NSTextAlignmentCenter;
    self.dscountLabel.textColor = GXF_CONTENT_COLOR;
    self.dscountLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.yscountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.dscountLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.yscountLabel.textAlignment = NSTextAlignmentCenter;
    self.yscountLabel.textColor = GXF_CONTENT_COLOR;
    self.yscountLabel.font = GXF_SIXTEENTEH_SIZE;
    
    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
    self.showView.clipsToBounds = YES;
    
    self.showStandLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.seqLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showStandLabel.textAlignment = NSTextAlignmentLeft;
    self.showStandLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showStandLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showbzdwLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showStandLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showbzdwLabel.textAlignment = NSTextAlignmentLeft;
    self.showbzdwLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showbzdwLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showjcPriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showjcPriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showjcPriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showjcPriceLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showbzPriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showbzdwLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showbzPriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showbzPriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showbzPriceLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showbzCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showjcPriceLabel.frame), ShowWidth, ShowHeight))];
    self.showbzCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showbzCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showbzCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showshCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showbzdwLabel.frame), CGRectGetMaxY(self.showjcPriceLabel.frame), ShowWidth, ShowHeight))];
    self.showshCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showshCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showshCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showjcCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showbzCountLabel.frame), ShowWidth, ShowHeight))];
    self.showjcCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showjcCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showjcCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showshjcCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showbzdwLabel.frame), CGRectGetMaxY(self.showbzCountLabel.frame), ShowWidth, ShowHeight))];
    self.showshjcCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showshjcCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showshjcCountLabel.font = GXF_THREETEENTH_SIZE;
    
    
    
    self.showTotalLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showjcCountLabel.frame), ShowWidth, ShowHeight))];
    self.showTotalLabel.textAlignment = NSTextAlignmentLeft;
    self.showTotalLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showTotalLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showshTotalLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showbzdwLabel.frame), CGRectGetMaxY(self.showjcCountLabel.frame), ShowWidth, ShowHeight))];
    self.showshTotalLabel.textAlignment = NSTextAlignmentLeft;
    self.showshTotalLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showshTotalLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showCounterNum = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showTotalLabel.frame), ShowWidth*2, ShowHeight))];
    self.showCounterNum.textAlignment = NSTextAlignmentLeft;
    self.showCounterNum.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCounterNum.font = GXF_THREETEENTH_SIZE;
    
    self.showNoteLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showbzdwLabel.frame), CGRectGetMaxY(self.showTotalLabel.frame), ShowWidth*2, ShowHeight))];
    self.showNoteLabel.textAlignment = NSTextAlignmentLeft;
    self.showNoteLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNoteLabel.font = GXF_THREETEENTH_SIZE;
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.dscountLabel];
    [self.contentView addSubview:self.yscountLabel];
    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.showView];
    
    [self.showView addSubview:self.showStandLabel];
    [self.showView addSubview:self.showbzdwLabel];
    [self.showView addSubview:self.showbzCountLabel];
    [self.showView addSubview:self.showshCountLabel];
    [self.showView addSubview:self.showjcCountLabel];
    [self.showView addSubview:self.showshjcCountLabel];
    [self.showView addSubview:self.showCounterNum];
    [self.showView addSubview:self.showjcPriceLabel];
    
    [self.showView addSubview:self.showbzPriceLabel];
    [self.showView addSubview:self.showTotalLabel];
    [self.showView addSubview:self.showshTotalLabel];

    [self.showView addSubview:self.showNoteLabel];
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setBillProduct:(TransferPdtDetail *)transferProduct row:(NSInteger)row defaultState:(NSString *)state
{
    self.seqLabel.text = [NSString stringWithFormat:@"%@",@(row+1)];
    self.titleLabel.text = transferProduct.productName;
    self.dscountLabel.text = [NSString stringWithFormat:@"%@%@",[transferProduct.qty stringValue],transferProduct.unit];
    self.yscountLabel.text = [NSString stringWithFormat:@"%@%@",transferProduct.rctQty?[transferProduct.rctQty stringValue]:@"0",transferProduct.unit];
    self.showStandLabel.text = [NSString stringWithFormat:@"包装规格：1*%@%@",[transferProduct.qpc stringValue],transferProduct.baseUnit];
    self.showbzdwLabel.text = [NSString stringWithFormat:@"包装单位：%@",transferProduct.unit];
    
    self.showbzCountLabel.text =[NSString stringWithFormat:@"包装数量：%@%@",[transferProduct.qty stringValue],transferProduct.unit];
    self.showshCountLabel.text =[NSString stringWithFormat:@"包装数量[实收]：%@%@",transferProduct.rctQty?([transferProduct.rctQty stringValue]):@"0",transferProduct.unit];
    if (transferProduct.rctQty == nil) {
        self.showshCountLabel.text = @"包装数量[实收]：空";
    }
    
    self.showjcCountLabel.text = [NSString stringWithFormat:@"基础数量：%@%@",[transferProduct.baseQty stringValue],transferProduct.baseUnit];
    
    self.showshjcCountLabel.text = [NSString stringWithFormat:@"基础数量[实收]：%@%@",transferProduct.rctBaseQty?[transferProduct.rctBaseQty stringValue]:@"0",transferProduct.baseUnit];
    if (transferProduct.rctBaseQty == nil) {
        self.showshjcCountLabel.text = @"基础数量[实收]：空";
    }
    self.showbzPriceLabel.text = [NSString stringWithFormat:@"包装单价：%.2f元",[transferProduct.packprice floatValue]];
    self.showjcPriceLabel.text = [NSString stringWithFormat:@"基础单价：%.2f元",[transferProduct.price floatValue]];
    
    self.showshTotalLabel.text = [NSString stringWithFormat:@"总金额[实收]：%.2f元",transferProduct.rctTotal?[transferProduct.rctTotal floatValue]:0.00f];
    if (transferProduct.rctTotal == nil) {
        self.showshTotalLabel.text = @"总金额[实收]：空";
    }
    
    self.showCounterNum.text = [NSString stringWithFormat:@"柜号：%@", transferProduct.vnum ? transferProduct.vnum : @""];
    
    self.showTotalLabel.text = [NSString stringWithFormat:@"总金额：%.2f元",transferProduct.total?[transferProduct.total floatValue]:0.00f];
    self.showNoteLabel.text =[NSString stringWithFormat:@"备注：%@",transferProduct.note ? transferProduct.note :@"无" ];
    if ([state isEqualToString:@"YES"]) {
        if ([transferProduct.qty floatValue] > [transferProduct.rctQty floatValue]) {
            self.yscountLabel.textColor = [UIColor redColor];
            self.showshCountLabel.textColor = [UIColor redColor];
        }else{
            self.yscountLabel.textColor = GXF_NAVIGAYION_COLOR;
            self.showshCountLabel.textColor = GXF_NAVIGAYION_COLOR;
        }
        if ([transferProduct.baseQty floatValue] > [transferProduct.rctBaseQty floatValue]) {
            self.showshjcCountLabel.textColor = [UIColor redColor];
        }else{
            self.showshjcCountLabel.textColor = GXF_NAVIGAYION_COLOR;
        }
        if ([transferProduct.total floatValue] > [transferProduct.rctTotal floatValue]) {
            self.showshTotalLabel.textColor = [UIColor redColor];
        }else{
            self.showshTotalLabel.textColor = GXF_NAVIGAYION_COLOR;
        }
    }
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
