//
//  TopPurchaseView.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TopPurchaseView.h"

#import "SurveyCell.h"
#import "ChooseVendorViewController.h"
#import "ChooseTypeViewController.h"
#import "ChooseWarehouseViewController.h"
#import "ChosePersonViewController.h"
#import "Vendor.h"
#import "SurveyUser.h"
#define LeftMargin 15
#define LeftWidth 80
#define SpaceHeight 10
#define TopMargin 10
#define TableHeight 44
@interface TopPurchaseView ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
}
//选择的项目
@property (nonatomic,strong)NSString *selectType;
@property (nonatomic,strong)NSString *selectVendor;
@property (nonatomic,strong)NSString *selectWarehouse;
@end


@implementation TopPurchaseView
- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.backgroundColor  = XXFBgColor;
    _dataArr = [NSMutableArray array];
    NSArray *arr = @[@"采购员:",@"类型:",@"供应商:",@"收货仓库:",@"其他费用:",@"总金额:",@"外部单据号:",@"备注:"];
    [_dataArr addObjectsFromArray:arr];
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,self.frame.size.width, self.frame.size.height - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    [self addSubview:_tableView];
}
#pragma mark - 协议方法
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if (indexPath.row == 4) {
        return 0.01;
    }
    return 44;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row >= 0 && indexPath.row < 4) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}
-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 4 ) {
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.keyboardType = UIKeyboardTypeDecimalPad;
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        self.otherPriceFiled = textField;
        self.otherPriceFiled.placeholder = @"其他费用";
        self.otherPriceFiled.enabled = NO;
        [self.otherPriceFiled addTarget:self action:@selector(boxValueChanged:) forControlEvents:UIControlEventEditingChanged];
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame) + 5, 0, 20, TableHeight)];
        label.text = @"元";
        label.textColor = GXF_CONTENT_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView removeAllSubViews];
        [cell.contentView addSubview:label];
        cell.alpha = 0;
        
    }else if ([_dataArr[indexPath.row] isEqualToString:@"备注:"]){
        self.remarkTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight)];
        self.remarkTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        self.remarkTextView.minNumberOfLines = 1;
        self.remarkTextView.maxNumberOfLines = 1;
        self.remarkTextView.isScrollable = YES;
        self.remarkTextView.font = GXF_FIFTEENTEN_SIZE;
        self.remarkTextView.textAlignment = NSTextAlignmentRight;
        self.remarkTextView.delegate = self;
        self.remarkTextView.returnKeyType = UIReturnKeyDone;
        self.remarkTextView.placeholder = @"输入备注内容";
        
        [cell.contentView addSubview:self.remarkTextView];
    }else if ([_dataArr[indexPath.row] isEqualToString:@"外部单据号:"]){
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        self.purchaseExternal = textField;
        self.purchaseExternal.placeholder = @"输入外部单据号";
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 0) {
            contentLabel.text = @"选择采购员";
            self.purchaserLabel = contentLabel;
            
        }else if(indexPath.row == 1){
            contentLabel.text = @"选择类型";
            self.purchaseTypeLabel = contentLabel;
            
        }else if(indexPath.row == 2){
            contentLabel.text = @"选择供应商";
            self.purchaseSupplierLabel = contentLabel;
            self.purchaseTypeLabel.textColor = GXF_CONTENT_COLOR;
            self.purchaseTypeLabel.text = @"普通";
            
        }else if(indexPath.row == 3){
            contentLabel.text = @"选择收货仓库";
            self.purchaseStoreLabel = contentLabel;
        }else if(indexPath.row == 5){
            contentLabel.text = @"0";
            contentLabel.frame = CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight);
            contentLabel.textColor = GXF_NAVIGAYION_COLOR;
            self.purchasePriceLabel = contentLabel;
            UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(contentLabel.frame)+ 5, 0, 20, TableHeight)];
            label.text = @"元";
            label.textColor = GXF_CONTENT_COLOR;
            label.font = GXF_FIFTEENTEN_SIZE;
            [cell.contentView addSubview:label];
        }
    }
    [self prepareDataInCell];
}
//赋值
- (void)setBill:(PurchaseBill *)bill{
    if (bill) {
        
        if (bill.purchaserName.length > 0) {
            self.selectPerson = [SurveyUser new];
            self.selectPerson.userCode = bill.purchaserCode;
            self.selectPerson.userName = bill.purchaserName;
            self.selectPerson.userUuid = bill.purchaserUuid;
            self.purchaserLabel.text = bill.purchaserName;
            self.purchaserLabel.textColor = GXF_CONTENT_COLOR;
        }
        if (bill.type.length > 0) {
            NSString *type = [bill.type isEqualToString:GXF_Critical] ? @"紧急" : @"普通";
            self.purchaseTypeLabel.text = type;
            self.purchaseTypeLabel.textColor = GXF_CONTENT_COLOR;
            self.type = bill.type;
            self.selectType = type;
            
        }
        if (bill.vendor_name.length > 0) {
            self.purchaseSupplierLabel.text = [NSString stringWithFormat:@"%@[%@]",bill.vendor_name,bill.vendor_code];
            self.purchaseSupplierLabel.textColor = GXF_CONTENT_COLOR;
            self.vendor_uuid = bill.uuid;
            self.vendor_code = bill.vendor_code;
            self.vendor_name = bill.vendor_name;
            self.selectVendor = bill.vendor_uuid;
        }
        if (bill.receiveWrh_name.length > 0) {
            self.purchaseStoreLabel.text = [NSString stringWithFormat:@"%@[%@]",bill.receiveWrh_name,bill.receiveWrh_code];
            self.purchaseStoreLabel.textColor = GXF_CONTENT_COLOR;

            self.receiveWrh_uuid = bill.receiveWrh_uuid;
            self.receiveWrh_code = bill.receiveWrh_code;
            self.receiveWrh_name = bill.receiveWrh_name;
            self.selectWarehouse = bill.receiveWrh_uuid;

        }
        if (bill.charge) {
            self.otherPriceFiled.text = [bill.charge stringValue];
            self.chargePurchase = bill.charge;
        }
        if (bill.total) {
            self.purchasePriceLabel.text = [bill.total stringValue];
            self.total = bill.total;
        }
        
        self.purchaseExternal.text = bill.outSideBillNumber;
        if (bill.remark.length > 0) {
            self.remarkTextView.text = bill.remark;
            self.remark = bill.remark;
        }
    }
}
- (void)prepareDataInCell{
    if (self.total) {
        self.purchasePriceLabel.text = [self.total stringValue];
    }
    if (self.noticeNumber.length > 0) {
        self.purchaserLabel.text = self.noticeNumber;
        self.purchaserLabel.textColor = GXF_CONTENT_COLOR;
    }
}
-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if(indexPath.row == 2){
        ChooseVendorViewController *cvc = [ChooseVendorViewController new];
        if (self.selectVendor.length > 0) {
            cvc.selectStr = self.selectVendor;
        }
        cvc.choseBaseInfo = ^(NSArray *vendors){
            if (vendors.count > 0) {
                Vendor *vendor = vendors[0];
                self.purchaseSupplierLabel.text = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
                self.purchaseSupplierLabel.textColor = GXF_CONTENT_COLOR;
                self.vendor_uuid = vendor.uuid;
                self.vendor_code = vendor.code;
                self.vendor_name = vendor.name;
                self.selectVendor = vendor.uuid;
            }
            
        };
        cvc.isMoreChose = NO;
        [self.delegate pushNextViewController:cvc];
    }else if(indexPath.row == 1){
        ChooseTypeViewController *tvc = [[ChooseTypeViewController alloc]init];
        if (self.selectType.length > 0) {
            tvc.selectStr = self.selectType;
        }
        tvc.choseBaseInfo = ^(NSArray *types){
            NSString *type = types[0];
            self.purchaseTypeLabel.text = type;
            self.selectType = type;
            self.purchaseTypeLabel.textColor = GXF_CONTENT_COLOR;
            if ([type isEqualToString:@"紧急"]) {
                self.type = GXF_Critical;
            }else{
                self.type = GXF_Normal;
            }
        };
        [self.delegate pushNextViewController:tvc];
    }else if(indexPath.row == 3){
        ChooseWarehouseViewController *wvc = [[ChooseWarehouseViewController alloc]init];
        if (self.selectWarehouse.length > 0) {
            wvc.selectStr = self.selectWarehouse;
        }
        wvc.choseBaseInfo = ^(NSArray *warehouses){
            Warehouse *warehouse = warehouses[0];
            self.purchaseStoreLabel.text = [NSString stringWithFormat:@"%@[%@]",warehouse.name,warehouse.code];
            self.purchaseStoreLabel.textColor = GXF_CONTENT_COLOR;
            self.receiveWrh_uuid = warehouse.uuid;
            self.receiveWrh_code = warehouse.code;
            self.receiveWrh_name = warehouse.name;
            self.selectWarehouse = self.receiveWrh_uuid;
        };
        [self.delegate pushNextViewController:wvc];
    }else if (indexPath.row == 0){
        
        ChosePersonViewController *cvc = [ChosePersonViewController new];
        cvc.choseBaseInfo = ^(NSArray *users){
            if(users.count == 1){
                self.selectPerson = users[0];
                self.purchaserLabel.text = _selectPerson.userName;
                self.purchaserLabel.textColor = GXF_CONTENT_COLOR;
            }
        };
        cvc.isMoreChose = NO;
        [self.delegate pushNextViewController:cvc];

    }
}

- (NSString *)type {
    if ([self.purchaseTypeLabel.text isEqualToString:@"紧急"]) {
        _type = GXF_Critical;
    }else{
        _type = GXF_Normal;
    }
    return _type;
}
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [self.remarkTextView resignFirstResponder];
    return YES;
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self.delegate hiddenKeyBoard];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self.delegate hiddenKeyBoard];
}

- (void)boxValueChanged:(UITextField *)textFiled{
        [[NSNotificationCenter defaultCenter] postNotificationName:SetProductTotalPrice object:nil];
}


@end
