//
//  ProductCell.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ProductBillCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowWidth (ScreenSize.width  - LeftMargin*2 - SmallSize)/2
#define ShowHeight 20

@implementation ProductBillCell



- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (4 -1))/4;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    self.smallImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.textColor = GXF_CONTENT_COLOR;
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.priceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.priceLabel.textAlignment = NSTextAlignmentCenter;
    self.priceLabel.textColor = GXF_CONTENT_COLOR;
    self.priceLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.countLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.priceLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.countLabel.textAlignment = NSTextAlignmentCenter;
    self.countLabel.textColor = GXF_CONTENT_COLOR;
    self.countLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.shippedQtyLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.countLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.shippedQtyLabel.textAlignment = NSTextAlignmentCenter;
    self.shippedQtyLabel.textColor = GXF_CONTENT_COLOR;
    self.shippedQtyLabel.font = GXF_SIXTEENTEH_SIZE;

    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
    self.showView.clipsToBounds = YES;
    
    self.showNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.seqLabel.frame), 0, ShowWidth*2, ShowHeight))];
    self.showNameLabel.textAlignment = NSTextAlignmentLeft;
    self.showNameLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNameLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showStandLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.seqLabel.frame), CGRectGetMaxY(self.showNameLabel.frame), ShowWidth, ShowHeight))];
    self.showStandLabel.textAlignment = NSTextAlignmentLeft;
    self.showStandLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showStandLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showStandLabel.frame), CGRectGetMaxY(self.showNameLabel.frame), ShowWidth, ShowHeight))];
    self.showCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showBaseCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showBaseCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showBaseCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showBaseCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showPriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showPriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showPriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showPriceLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showBasePriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showBaseCountLabel.frame), ShowWidth, ShowHeight))];
    self.showBasePriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showBasePriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showBasePriceLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showTotalLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showBaseCountLabel.frame), ShowWidth, ShowHeight))];
    self.showTotalLabel.textAlignment = NSTextAlignmentLeft;
    self.showTotalLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showTotalLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showCounterNum = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showBasePriceLabel.frame), ShowWidth, ShowHeight))];
    self.showCounterNum.textAlignment = NSTextAlignmentLeft;
    self.showCounterNum.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCounterNum.font = GXF_THREETEENTH_SIZE;
    
    self.showNoteLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showCounterNum.frame), ShowWidth, ShowHeight))];
    self.showNoteLabel.textAlignment = NSTextAlignmentLeft;
    self.showNoteLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNoteLabel.font = GXF_THREETEENTH_SIZE;
    
   
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;

    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.priceLabel];
    [self.contentView addSubview:self.countLabel];
    [self.contentView addSubview:self.shippedQtyLabel];

    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.showView];
    
    [self.showView addSubview:self.showNameLabel];
    [self.showView addSubview:self.showStandLabel];
    [self.showView addSubview:self.showCountLabel];
    [self.showView addSubview:self.showBaseCountLabel];
    [self.showView addSubview:self.showPriceLabel];
    [self.showView addSubview:self.showBasePriceLabel];
    [self.showView addSubview:self.showTotalLabel];
    [self.showView addSubview:self.showCounterNum];
    [self.showView addSubview:self.showNoteLabel];
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setBillProduct:(PurchaseBillProduct *)billProduct row:(NSInteger)row
{
    //查看采购单cell上面顶上的商品、单价、包装数量等
    self.seqLabel.text = [NSString stringWithFormat:@"%@",@(row+1)];
    self.titleLabel.text = billProduct.product_name;
    self.priceLabel.text = [NSString stringWithFormat:@"%.2f元",[billProduct.basePrice floatValue]];
    self.countLabel.text = [NSString stringWithFormat:@"%@%@",[billProduct.qty stringValue],billProduct.unit];
    self.shippedQtyLabel.text = [NSString stringWithFormat:@"%@%@",billProduct.shippedQty ? [billProduct.shippedQty stringValue]:@"0",billProduct.unit];
    
    self.showNameLabel.text = [NSString stringWithFormat:@"商品：%@[%@]",billProduct.product_name,billProduct.product_code];
    self.showStandLabel.text = [NSString stringWithFormat:@"包装规格：1*%@%@",[billProduct.qpc stringValue],billProduct.baseUnit];
    self.showCountLabel.text = [NSString stringWithFormat:@"包装数量：%@%@",billProduct.qty,billProduct.unit];
    self.showBaseCountLabel.text =[NSString stringWithFormat:@"基础数量：%@%@",billProduct.baseQty ,billProduct.baseUnit];
    self.showPriceLabel.text = [NSString stringWithFormat:@"包装单价：%.2f元",[billProduct.price floatValue]];
    self.showBasePriceLabel.text = [NSString stringWithFormat:@"基础单价：%.2f元",[billProduct.basePrice floatValue]];
    self.showTotalLabel.text = [NSString stringWithFormat:@"总金额：%@元",[billProduct.total stringValue]];
    self.showNoteLabel.text =[NSString stringWithFormat:@"备注：%@",billProduct.remark ? billProduct.remark :@"无" ];
    self.showCounterNum.text = [NSString stringWithFormat:@"柜号：%@", billProduct.vnum];
    [self isShowShippingQty:billProduct];
}

- (void)isShowShippingQty:(PurchaseBillProduct *)billProduct{
    if(self.editBtn.hidden){
        self.showShippedFlag.frame = CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showTotalLabel.frame), ShowWidth, ShowHeight);
        self.showShippedFlag.textAlignment = NSTextAlignmentLeft;
        self.showShippedFlag.textColor = GXF_PLACEHOLDER_COLOR;
        self.showShippedFlag.text = @"是否发运：未";
        self.showShippedFlag.font = GXF_THREETEENTH_SIZE;
        //showStandLabel是包装规格，showCountLabel是包装数量
        self.showShippedBaseQty.frame = (CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showCounterNum.frame), ShowWidth, ShowHeight));
        self.showShippedBaseQty.textAlignment = NSTextAlignmentLeft;
        self.showShippedBaseQty.textColor = GXF_PLACEHOLDER_COLOR;
        self.showShippedBaseQty.text = @"发运基础数量：";
        self.showShippedBaseQty.font = GXF_THREETEENTH_SIZE;
        
        self.showShippedQty.frame = (CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showShippedFlag.frame), ShowWidth, ShowHeight));
        self.showShippedQty.textAlignment = NSTextAlignmentLeft;
        self.showShippedQty.textColor = GXF_PLACEHOLDER_COLOR;
        self.showShippedQty.text = @"发运包装数量：";
        self.showShippedQty.font = GXF_THREETEENTH_SIZE;
        
        
        self.showNoteLabel.frame = CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showShippedBaseQty.frame), ShowWidth, ShowHeight);
    }
    NSMutableAttributedString *attributeStr1 = [IBTCommon setTextViewFontOfString:@"发运状态：" paragraphStyle:0 fontSize:13 color:GXF_CELL_COLOR];
    NSString *str = [NSString stringWithFormat:@"%@",[billProduct.shippedFlag integerValue] == 0 ? @"未完成":@"已完成"];
    [attributeStr1 appendAttributedString:[IBTCommon setTextViewFontOfString:str paragraphStyle:0 fontSize:13 color:[UIColor redColor]]];
    self.showShippedFlag.attributedText = attributeStr1;

    self.showShippedBaseQty.text = [NSString stringWithFormat:@"发运包装数量：%@%@",billProduct.shippedQty ? [billProduct.shippedQty stringValue]:@"0",billProduct.unit];
    self.showShippedQty.text = [NSString stringWithFormat:@"发运基础数量：%@%@",billProduct.shippedBaseQty ? [billProduct.shippedBaseQty stringValue]:@"0",billProduct.baseUnit];
    [self.showView addSubview:self.showShippedFlag];
    [self.showView addSubview:self.showShippedQty];
    [self.showView addSubview:self.showShippedBaseQty];
}

- (UILabel *)showShippedFlag {
    if (!_showShippedFlag) {
        _showShippedFlag = [UILabel new];
        [_showView addSubview:_showShippedFlag];
    }
    return _showShippedFlag;
}

- (UILabel *)showShippedQty {
    if (!_showShippedQty) {
        _showShippedQty = [UILabel new];
        [_showView addSubview:_showShippedQty];
    }
    return _showShippedQty;
}

- (UILabel *)showShippedBaseQty {
    if (!_showShippedBaseQty) {
        _showShippedBaseQty = [UILabel new];
        [_showView addSubview:_showShippedBaseQty];
    }
    return _showShippedBaseQty;
}
- (void)awakeFromNib {
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
