//
//  HeaderCell.m
//  XFFruit
//
//  Created by n22 on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "HeaderCell.h"
#define LeftMargin 13
#define LeftWidth 45
#define RightWidth 30
#define SpaceMargin 1
#import "ICRCheckBox.h"
@interface HeaderCell ()
@property (nonatomic,strong)NSArray *arr;
@property (nonatomic,strong)UILabel *lineLabel;
@property (nonatomic,assign)BOOL isHiddenAdd;
@end

@implementation HeaderCell

- (instancetype)initWithFrame:(CGRect)frame withArr:(NSArray *)arr{
    self = [super initWithFrame:frame];
    if (self) {
        self.arr = arr;
        [self bulidLayout];
    }
    return self;
}
- (instancetype)initWithFrame:(CGRect)frame withArr:(NSArray *)arr withHiddenEdit:(BOOL)isHiddenEdit{
    self = [super initWithFrame:frame];
    if (self) {
        self.arr = arr;
        self.isHiddenAdd = isHiddenEdit;
        [self bulidLayout];
        
    }
    return self;
}

- (instancetype)initWithFrame:(CGRect)frame WithCheckBoxArr:(NSArray *)arr checkBox:(void (^)(BOOL isSelect))check {
    self = [super initWithFrame:frame];
    if (self) {
        self.arr = arr;
        self.isHiddenAdd = YES;
        self.blockCheckBox = check;
        [self bulidLayout];
        [self uiAddCheckBox];
    }
    return self;
}

- (void)bulidLayout{

    CGFloat headWidth = (ScreenSize.width - LeftWidth - LeftWidth - SpaceMargin* (self.arr.count -1))/self.arr.count;
    for (NSInteger i = 0; i < self.arr.count; i++) {
        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(LeftWidth + (SpaceMargin + headWidth)*i, 0, headWidth, self.frame.size.height)];
        label.font = GXF_FOURTEENTH_SIZE;
        label.textAlignment = NSTextAlignmentCenter;
        label.textColor = GXF_PLACEHOLDER_COLOR;
//        label.backgroundColor = [UIColor redColor];
        label.text = self.arr[i];
        [self addSubview:label];
    }
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, self.frame.size.height-1, ScreenSize.width - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    self.lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [self addSubview:self.lineLabel];
    
    if (!self.isHiddenAdd) {
        UIButton *addBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        addBtn.frame = CGRectMake(ScreenSize.width - LeftWidth - SpaceMargin, 0, LeftWidth, self.frame.size.height);
        [addBtn setImage:[UIImage imageNamed:@"add"] forState:UIControlStateNormal];
        [addBtn setTitleColor:GXF_PLACEHOLDER_COLOR forState:UIControlStateNormal];
        [addBtn addTarget:self action:@selector(addBtn) forControlEvents:UIControlEventTouchUpInside];
        addBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
        [self addSubview:addBtn];

    }
    
}

- (void)uiAddCheckBox {
    UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(ScreenSize.width - 30, 0, 30, self.frame.size.height)];
    label.text = @"全选";
    label.font = [UIFont systemFontOfSize:13];
    [self addSubview:label];
    
    
    ICRCheckBox *addBtn = [[ICRCheckBox alloc] initWithFrame:CGRectMake(ScreenSize.width - LeftWidth - SpaceMargin - 15, 0, LeftWidth, self.frame.size.height)];
    self.checkBox = addBtn;
    addBtn.m_eBGType = kCheckBoxBGGray;
    addBtn.blockCheckBox = self.blockCheckBox;
    
    
    [self addSubview:addBtn];
}

- (void)addBtn{
    if([self.delegate respondsToSelector:@selector(addClickList)]){
        [self.delegate addClickList];
    }
}


@end
