//
//  ICRTaskItemView.m
//  XFFruit
//
//  Created by Xummer on 4/11/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRTaskItemView.h"

#define TASK_LABEL_VERTICAL_MARGIN  (10.0f)
#define TASK_LABEL_HORIZON_MARGIN   (15.0f)
#define TASK_LABEL_INNER_GAP        (5.0f)

@interface ICRTaskItemView ()
@property (strong, nonatomic) IBTUILabel *m_storeLabel;
@property (strong, nonatomic) IBTUILabel *m_storeValueLabel;
@property (strong, nonatomic) IBTUILabel *m_codeLabel;
@property (strong, nonatomic) IBTUILabel *m_codeValueLabel;
@property (strong, nonatomic) IBTUILabel *m_typeLabel;
@property (strong, nonatomic) IBTUILabel *m_typeValueLabel;
@property (strong, nonatomic) IBTUILabel *m_taskLabel;
@property (strong, nonatomic) IBTUILabel *m_taskValueLabel;
@property (strong, nonatomic) IBTUILabel *m_deadLineLabel;
@property (strong, nonatomic) IBTUILabel *m_deadLineValueLabel;

@end

@implementation ICRTaskItemView

#pragma mark - Life Cycle
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubviews];
    
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat fMaxW = self.width - 2 * TASK_LABEL_HORIZON_MARGIN;
    
    [_m_storeLabel sizeToFit];
    _m_storeLabel.origin = (CGPoint){
        .x = TASK_LABEL_HORIZON_MARGIN,
        .y = TASK_LABEL_VERTICAL_MARGIN
    };
    
    _m_storeValueLabel.frame = (CGRect){
        .origin.x = _m_storeLabel.right,
        .origin.y = _m_storeLabel.y,
        .size.width = fMaxW - _m_storeLabel.width,
        .size.height = _m_storeLabel.height
    };
    
    [_m_codeLabel sizeToFit];
    _m_codeLabel.origin = (CGPoint){
        .x = _m_storeLabel.x,
        .y = _m_storeLabel.bottom + TASK_LABEL_INNER_GAP
    };
    
    _m_codeValueLabel.frame = (CGRect){
        .origin.x = _m_codeLabel.right,
        .origin.y = _m_codeLabel.y,
        .size.width = fMaxW - _m_codeLabel.width,
        .size.height = _m_codeLabel.height
    };
    
    [_m_typeLabel sizeToFit];
    _m_typeLabel.origin = (CGPoint){
        .x = _m_storeLabel.x,
        .y = _m_codeLabel.bottom + TASK_LABEL_INNER_GAP
    };
    
    _m_typeValueLabel.frame = (CGRect){
        .origin.x = _m_typeLabel.right,
        .origin.y = _m_typeLabel.y,
        .size.width = fMaxW - _m_typeLabel.width,
        .size.height = _m_typeLabel.height
    };
    
    
    [_m_taskLabel sizeToFit];
    _m_taskLabel.origin = (CGPoint){
        .x = _m_storeLabel.x,
        .y = _m_typeLabel.bottom + TASK_LABEL_INNER_GAP
    };
    
    _m_taskValueLabel.frame = (CGRect){
        .origin.x = _m_taskLabel.right,
        .origin.y = _m_taskLabel.y,
        .size.width = fMaxW - _m_taskLabel.width,
        .size.height = _m_taskLabel.height
    };

    [_m_deadLineLabel sizeToFit];
    _m_deadLineLabel.origin = (CGPoint){
        .x = _m_storeLabel.x,
        .y = _m_taskLabel.bottom + TASK_LABEL_INNER_GAP
    };
    
    _m_deadLineValueLabel.frame = (CGRect){
        .origin.x = _m_deadLineLabel.right,
        .origin.y = _m_deadLineLabel.y,
        .size.width = fMaxW - _m_deadLineLabel.width,
        .size.height = _m_deadLineLabel.height
    };
}

#pragma mark - Private Method
- (void)initSubviews {
    
    self.m_storeLabel =
    [[self class] titleLabelWithText:[IBTCommon localizableString:@"Store"]];
    
    self.m_codeLabel =
    [[self class] titleLabelWithText:[IBTCommon localizableString:@"Task Code"]];
    
    self.m_typeLabel =
    [[self class] titleLabelWithText:[IBTCommon localizableString:@"Task Type"]];
    
    self.m_taskLabel =
    [[self class] titleLabelWithText:[IBTCommon localizableString:@"Task Title"]];
    
    self.m_deadLineLabel =
    [[self class] titleLabelWithText:[IBTCommon localizableString:@"Task Deadline"]];
    
    self.m_storeValueLabel = [[self class] valueLabel];
    self.m_codeValueLabel = [[self class] valueLabel];
    self.m_typeValueLabel = [[self class] valueLabel];
    self.m_taskValueLabel = [[self class] valueLabel];
    self.m_deadLineValueLabel = [[self class] valueLabel];
    
    [self addSubview:_m_storeLabel];
    [self addSubview:_m_codeLabel];
    [self addSubview:_m_typeLabel];
    [self addSubview:_m_taskLabel];
    [self addSubview:_m_deadLineLabel];
    [self addSubview:_m_storeValueLabel];
    [self addSubview:_m_codeValueLabel];
    [self addSubview:_m_typeValueLabel];
    [self addSubview:_m_taskValueLabel];
    [self addSubview:_m_deadLineValueLabel];
}

+ (IBTUILabel *)titleLabelWithText:(NSString *)nsTitle {
    IBTUILabel *label = [[IBTUILabel alloc] init];
    label.textAlignment = NSTextAlignmentLeft;
    label.textColor = [UIColor blackColor];
    label.font = [UIFont systemFontOfSize:15.0f];
    label.text = [nsTitle stringByAppendingString:@":"];
    return label;
}

+ (IBTUILabel *)valueLabel {
    IBTUILabel *label = [[IBTUILabel alloc] init];
    label.textAlignment = NSTextAlignmentLeft;
    label.textColor = [UIColor blackColor];
    label.font = [UIFont systemFontOfSize:15.0f];
    return label;
}

@end

#import "ICRTask.h"
@implementation ICRTaskItemView (Configure)

- (void)updateWithTask:(ICRTask *)task {
    self.m_storeValueLabel.text = task.storeCode;
    self.m_codeValueLabel.text = task.billNumber;
    self.m_typeValueLabel.text = task.billNumber;
    self.m_taskValueLabel.text = task.title;
    self.m_deadLineValueLabel.text = task.requireDate;
    
    [self setNeedsLayout];
}

@end
