 //
//  ChooseParentViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/2.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseParentViewController.h"
#define TopMargin 50
#define TableHeight 50

@interface ChooseParentViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>
@end

@implementation ChooseParentViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
    [self createRefresh];
}

- (void)initData{
    self.dataArr = [NSMutableArray array];
    
    if (!self.indexArr) {
        self.indexArr = [NSMutableArray array];
    }
    self.isFirst = YES;
}

#pragma mark - 布局
- (void)bulidLayout
{
    self.selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    self.selectTextFiled.textAlignment = NSTextAlignmentLeft;
    self.selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    self.selectTextFiled.delegate = self;
    [self.selectTextFiled addTarget:self action:@selector(boxValueChanged:) forControlEvents:UIControlEventEditingChanged];
    self.selectTextFiled.font = GXF_FIFTEENTEN_SIZE;
    [self.view addSubview:self.selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    self.selectTextFiled.leftView = leftView;
    self.selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deleteTextFieldStr) forControlEvents:UIControlEventTouchUpInside];
    self.selectTextFiled.rightView = rightView;
    self.selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (self.isRefresh) {
            return ;
        }
        self.isRefresh = YES;
        self.currentPage = 0;
        [self getLastModifiedTime];
    }];
}

- (void)getLastModifiedTime{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = [NSString stringWithFormat:@"select * from %@ order by lastModify_time desc limit 1",self.tableStr];
        return [db executeQuery:sql];
    };
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (fetchedObjects.count > 0) {
            NSString *startDate = @"";
            if ([self.tableStr isEqualToString:GXF_BASECLASS_PRODUCT]) {
                Product *product = fetchedObjects[0];
                startDate = product.lastModify_time;
            }else if ([self.tableStr isEqualToString:GXF_BASECLASS_USER]) {
                User *user = fetchedObjects[0];
                startDate = user.lastModify_time;
            }else if ([self.tableStr isEqualToString:GXF_BASECLASS_PRODUCTUNIT]) {
                GXFProductUnit *productUnit = fetchedObjects[0];
                startDate = productUnit.lastModify_time;
            }else if ([self.tableStr isEqualToString:GXF_BASECLASS_VENDOR]) {
                Vendor *vendor= fetchedObjects[0];
                startDate = vendor.lastModify_time;
            }else if ([self.tableStr isEqualToString:GXF_BASECLASS_WAREHOUSE]) {
                Warehouse *warehouse= fetchedObjects[0];
                startDate = warehouse.lastModify_time;
            }else if ([self.tableStr isEqualToString:GXF_BASECLASS_ACCOUNTTITLE]) {
                Accounttitle *accounttitle= fetchedObjects[0];
                startDate = accounttitle.lastModify_time;
            }
            [strongSelf getBaseDataFromServerWithStartDate:startDate];
        }
    };
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:NSClassFromString(self.tableStr)
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];

}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        return;
    }
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        if (![self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
            cell.titleLabel.textColor = BASESELECT_COLOR;
            [self.indexArr addObject:indexPath];
        }else{
            cell.Commitbtn.hidden = YES;
            cell.titleLabel.textColor = [UIColor blackColor];
            [self.indexArr removeObject:indexPath];
        }
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:self.currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        currentCell.titleLabel.textColor = [UIColor blackColor];

        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.titleLabel.textColor = BASESELECT_COLOR;
        cell.Commitbtn.hidden = NO;
        self.currentIndexPath = indexPath;
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}
- (void)keyboardHidden{
    [self.selectTextFiled resignFirstResponder];
}

#pragma mark - 结束刷新
- (void)endRefreshing{
    self.isRefresh = NO;
    [self.tableView.header endRefreshing];
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)deleteTextFieldStr{
    self.selectTextFiled.text = @"";
    [self boxValueChanged:nil];
}
#pragma mark - 按钮事件
- (void)boxValueChanged:(NSNotification *)fication{

}
- (void)tableViewRefresh:(NSString *)titltstr{
    self.currentIndexPath = nil;
    if (self.indexArr.count > 0) {
        [self.indexArr removeAllObjects];
    }
    [self.tableView reloadData];
}
- (void)fetchDataList:(NSString *)titleStr tableStr:(NSString *)tableStr{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = @"";
        
        if ([tableStr isEqualToString:GXF_BASECLASS_USER]) {
            if (titleStr.length > 0) {
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE (NAME LIKE '%%%@%%' or LOGIN LIKE  '%%%@%%') AND ENABLED = 1 AND POSITION = 'purchaser'  ORDER BY %@", tableStr,titleStr,titleStr, @"LOGIN"];
            }else{
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE ENABLED = 1 AND POSITION = 'purchaser' ORDER BY %@", tableStr, @"LOGIN"];
            }
        }else if([tableStr isEqualToString:GXF_BASECLASS_PRODUCTUNIT]){
            if (titleStr.length > 0) {
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE NAME LIKE '%%%@%%' AND ENABLED = 1 ORDER BY %@", tableStr,titleStr, @"priority"];
            }else{
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE ENABLED = 1 ORDER BY %@", tableStr, @"priority"];
            }
        }else if([tableStr isEqualToString:GXF_BASECLASS_ACCOUNTTITLE]){
            if (titleStr.length > 0) {
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE NAME LIKE '%%%@%%' AND ENABLED = 1 ORDER BY %@", tableStr,titleStr, @"uuid"];
            }else{
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE ENABLED = 1 ORDER BY %@", tableStr, @"uuid"];
            }
        }else if([tableStr isEqualToString:GXF_BASECLASS_PRODUCT]){
            if (titleStr.length > 0) {
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE (NAME LIKE '%%%@%%' or CODE LIKE '%%%@%%') AND ENABLED = 1 ORDER BY %@", tableStr,titleStr,titleStr, @"code"];
            }else{
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE ENABLED = 1 ORDER BY %@", tableStr, @"code"];
            }
        }else if([tableStr isEqualToString:GXF_BASECLASS_UserWAREHOUSE]){
            //进仓库选择仓库页面第一次进入时查询的语句
                sql = [NSString stringWithFormat:@"select *  from %@ a where enabled = '1' and exists (select 1 from UserWarehouse b where b.warehouseUuid = a.uuid and b.userUuid = '%@' and b.enabled='1')", tableStr,[ICRUserUtil sharedInstance].userId];//@"4028b88150a987080150a987dce5007a"
        }else if([tableStr isEqualToString:GXF_BASECLASS_VENDOR]){
            if (titleStr.length > 0) {
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE (NAME LIKE '%%%@%%' or CODE LIKE '%%%@%%') AND ENABLED = 1 ORDER BY %@", tableStr,titleStr,titleStr, @"code"];
            }else{
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE ENABLED = 1 ORDER BY %@", tableStr, @"code"];
            }
        }else {
            if (titleStr.length > 0) {
//             NSString *aaa =  [NSString stringWithFormat:@"select *  from %@ a where enabled = '1' and exists (select 1 from UserWarehouse b where b.warehouseUuid = a.uuid and b.userUuid = '%@' and b.enabled='1')", titleStr,[ICRUserUtil sharedInstance].userId];
                if (self.warehouseType == WareHouseTypeCenter) {
                    
                    sql = [NSString stringWithFormat:@"SELECT * from %@ a WHERE (NAME LIKE '%%%@%%' or CODE LIKE '%%%@%%') AND enabled = '1' AND isProductCenter = '1'AND EXISTS (SELECT 1 FROM UserWarehouse b WHERE b.warehouseUuid = a.uuid AND b.userUuid = '%@' AND b.enabled='1')", tableStr, titleStr, titleStr,[ICRUserUtil sharedInstance].userId];
                }else if(self.warehouseType == WareHouseTypeNotCenter){

                    sql = [NSString stringWithFormat:@"SELECT * from %@ a WHERE (NAME LIKE '%%%@%%' or CODE LIKE '%%%@%%') AND enabled = '1' AND isProductCenter != '1'AND EXISTS (SELECT 1 FROM UserWarehouse b WHERE b.warehouseUuid = a.uuid AND b.userUuid = '%@' AND b.enabled='1')", tableStr, titleStr, titleStr,[ICRUserUtil sharedInstance].userId];
                }else{
                    sql = [NSString stringWithFormat:@"SELECT * from %@ a WHERE (NAME LIKE '%%%@%%' or CODE LIKE '%%%@%%') AND enabled = '1' AND EXISTS (SELECT 1 FROM UserWarehouse b WHERE b.warehouseUuid = a.uuid AND b.userUuid = '%@' AND b.enabled='1')", tableStr, titleStr, titleStr,[ICRUserUtil sharedInstance].userId];
                }
                
                
            }else{
                if (self.warehouseType == WareHouseTypeCenter) {
                    
                    sql = [NSString stringWithFormat:@"select * from %@ a where enabled = '1' AND isProductCenter = '1' and exists (select 1 from UserWarehouse b where b.warehouseUuid = a.uuid and b.userUuid = '%@' and b.enabled='1')", tableStr,[ICRUserUtil sharedInstance].userId];
                }else if(self.warehouseType == WareHouseTypeNotCenter){
                    
                    sql = [NSString stringWithFormat:@"select * from %@ a where enabled = '1' AND isProductCenter != '1' and exists (select 1 from UserWarehouse b where b.warehouseUuid = a.uuid and b.userUuid = '%@' and b.enabled='1')", tableStr,[ICRUserUtil sharedInstance].userId];
                }else{
                    sql = [NSString stringWithFormat:@"select *  from %@ a where enabled = '1' and exists (select 1 from UserWarehouse b where b.warehouseUuid = a.uuid and b.userUuid = '%@' and b.enabled='1')", tableStr,[ICRUserUtil sharedInstance].userId];
                }
            }
        }
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (fetchedObjects.count == 0 && titleStr.length == 0 && self.isFirst) {
            self.isFirst = NO;
            [GXF_NSUSERFEFTAULTS setObject:[NSDate date] forKey:self.tableView.header.lastUpdatedTimeKey];
            [GXF_NSUSERFEFTAULTS synchronize];
            NSString *befortDate = @"2014-01-01";
            [self getBaseDataFromServerWithStartDate:befortDate];
        }else{
            if ([tableStr isEqualToString:GXF_BASECLASS_UserWAREHOUSE]) {
                [self getWareHoseData:fetchedObjects titleStr:titleStr];
            }else{
                [strongSelf.dataArr removeAllObjects];
                if (!self.tableView.header.lastUpdatedTime) {
                    [strongSelf.dataArr addObject:[NSDate date]];
                }else{
                    [strongSelf.dataArr addObject:self.tableView.header.lastUpdatedTime];
                }
                
                [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
                
                [self tableViewRefresh:titleStr];

            }
        }
        
    };
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:NSClassFromString(tableStr)
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}

- (void)getWareHoseData:(NSArray *)arr titleStr:(NSString *)titleStr{
    if (arr.count > 0) {
        
        NSMutableString *parms = [NSMutableString string];
        for (int i = 0; i < arr.count; i++) {
            UserWarehouse *userW = arr[i];
            if (i == arr.count - 1) {
                [parms appendFormat:@"'%@'",userW.warehouseUuid];
            }else{
                [parms appendFormat:@"'%@',",userW.warehouseUuid];
            }
        }
        ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
            NSString * sql = @"";
            if (titleStr.length > 0) {
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE  (NAME LIKE '%%%@%%' or CODE LIKE '%%%@%%') AND ENABLED = 1 AND uuid in (%@) ORDER BY %@", GXF_BASECLASS_WAREHOUSE,titleStr,titleStr, parms,@"code"];
            }else{
                sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE ENABLED = 1 AND uuid in (%@) ORDER BY %@", GXF_BASECLASS_WAREHOUSE,parms, @"code"];
            }
            CLog(@"=========%@",sql);
            return [db executeQuery:sql];
        };
        __weak typeof(self)weakSelf = self;
        ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [strongSelf.dataArr removeAllObjects];
            if (!self.tableView.header.lastUpdatedTime) {
                [strongSelf.dataArr addObject:[NSDate date]];
            }else{
                [strongSelf.dataArr addObject:self.tableView.header.lastUpdatedTime];
            }
            [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
            [self tableViewRefresh:titleStr];
        };
        ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
        [dbCtrl runFetchForClass:NSClassFromString(GXF_BASECLASS_WAREHOUSE)
                      fetchBlock:fetchBlk
               fetchResultsBlock:fetchResultsBlk];

    }
}

#pragma mark -成功
- (void)sureClick{
    if (self.isMoreChose) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            [arr addObject:self.dataArr[index.row]];
        }
        self.choseBaseInfo(arr);
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
            if (self.currentIndexPath) {
                [arr addObject:self.dataArr[self.currentIndexPath.row]];
                self.choseBaseInfo(arr);
            }
        }
    }
    [self PopViewControllerAnimated:YES];
}

#pragma mark -childFunction
-(void)getBaseDataFromServer
{
}
-(void)getBaseDataFromServerWithStartDate:(NSString *)startDate
{
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
