//
//  ICRHTTPController.h
//  XFFruit
//
//  Created by Xummer on 3/26/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "ICRAnnouncement.h"
#define HTTP [ICRHTTPController sharedController]
typedef NS_ENUM(NSUInteger, ICRAttachmentType) {
    kAttachmentBoard = 0,
    kAttachmentAnswer,
    kAttachmentTask,
    
    // Insert enum here
    kAttachmentTypeCount,
};


@interface ICRHTTPController : IBTObject

+ (instancetype)sharedController;

// Restful API

// User
/* 用户登录验证（读）*/
- (void)doLoginWithUserName:(NSString *)userName
                   password:(NSString *)password
               registerCode:(NSString *)registerCode
                    success:(void (^)(id data))succ
                    failure:(void (^)(id data))fail;

/* 密码修改（写）*/
- (void)doChangePassword:(NSString *)nsPassword
             newPassword:(NSString *)nsNewPassword
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

// Data
/* 门店基本资料（读）
    返回最后修改日期从某时刻开始的该用户可见的门店 
 */
- (void)doGetStoreListFromUpdateTime:(NSTimeInterval)updateTime
                            position:(NSUInteger)uiPosition
                                size:(NSUInteger)uiSize
                             success:(void (^)(id data))succ
                             failure:(void (^)(id data))fail;

/* 组织架构基本资料（读）
    获得本人所属组织
 */
- (void)doGetCurrentOrgWithSuccess:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 任务类别基本资料
 获得本人所属组织的工单类别信息，提任务单时需要用
 */
- (void)doGetPersonListFromUpdateTime:(NSString *)updateTime
                           position:(NSUInteger)uiPosition
                               size:(NSUInteger)uiSize
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

// Board
/* 公告列表（读）
    获得公告列表
 */
- (void)doGetBoardListFromUpdateTime:(NSString *)updateTime
                            position:(NSUInteger)uiPosition
                                size:(NSUInteger)uiSize
                                type:(ICRAnnouncementType)eType
                         deleteLocal:(BOOL)bDeleteLocal
                             success:(void (^)(id data))succ
                             failure:(void (^)(id data))fail;

/* 读取公告（读）
    读取单个公告
 */
- (void)doGetBoardWithID:(NSNumber *)boardID
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

/* 提交公告已读状态（写）*/
- (void)doReadBoardWithID:(NSNumber *)boardID
                  success:(void (^)(id data))succ
                  failure:(void (^)(id data))fail;

// Patrol
/* 巡店计划列表（读）
    获得发布给自己的巡店计划
 */
- (void)doGetMyPatrolFromUpdateTime:(NSString *)updateTime
                           position:(NSUInteger)uiPosition
                               size:(NSUInteger)uiSize
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 下载某个门店结果（读）*/
- (void)doGetStoreResultWithPlanID:(NSString *)planID
                           storeID:(NSString *)storeID
                           success:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 巡店计划处理结果（写）*/
- (void)doAnswerPatrolPlanWithID:(NSNumber *)planID
                        infoData:(id)data
                         success:(void (^)(id data))succ
                         failure:(void (^)(id data))fail;

/* 巡店计划某个问题处理结果
    需要先调用接口|doAnswerPlanWithID:postData:success:failure:|，得到门店报告id
 */
- (void)doAnswerOnePatrolResultWithID:(NSNumber *)resultID
                             infoData:(id)data
                              success:(void (^)(id data))succ
                              failure:(void (^)(id data))fail;

/* 任务列表（读）*/
- (void)doGetTaskListFromUpdateTime:(NSString *)updateTime
                           position:(NSUInteger)uiPosition
                               size:(NSUInteger)uiSize
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 新增任务（写）*/
- (void)doCreateNewTaskWithInfo:(id)data
                        success:(void (^)(id data))succ
                        failure:(void (^)(id data))fail;

/* 任务处理结果（写）*/
- (void)doUpdateTaskResultID:(NSString *)resultID
                  resultText:(NSString *)resultStr
               processDate:(NSTimeInterval)processDate
                   success:(void (^)(id data))succ
                   failure:(void (^)(id data))fail;

// Signup
/* 签到信息提交（写）*/
- (void)doSignupWithInfo:(id)data
                 success:(void (^)(id data))succ
                 failure:(void (^)(id data))fail;

// Attachment
/* 添加附件（读）*/
- (void)doAddAttachment:(id)data
                success:(void (^)(id data))succ
                failure:(void (^)(id data))fail;

/* 返回附件列表 */
- (void)doGetAttachmentListWithType:(ICRAttachmentType)eType
                              objID:(NSString *)objID
                            success:(void (^)(id data))succ
                            failure:(void (^)(id data))fail;

/* 下载附件 */
- (void)doDownloadAttachmentWithID:(NSNumber *)attachmentID
                           success:(void (^)(id data))succ
                           failure:(void (^)(id data))fail;

/* 添加附件（读）直接上传方式 */
- (void)doAddDirectAttachment:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;

+ (NSString *)AttachmentUrlWithID:(id)attachmentID;

/* 下载附件，直接下载方式 */
- (void)doDownloadDirectAttachment:(NSString *)attachmentId
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

// Version
/* 查询版本（读）*/
- (void)doFetchVersionWithCurrent:(NSString *)currentVersion
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//1.添加行情调研单
- (void)saveSurveyWithAuthenticode:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

//2.获取行情调研单列表
- (void)querySurveyWithBillData:(id)data
                               success:(void (^)(id))succ
                               failure:(void (^)(id))fail;
//3.获取行情调研单详情
- (void)getResultWithSurveyUuid:(NSString *)surveyUuid
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//4.生成行情反馈图片
- (void)resultChartWithResultUuid:(NSString *)uuid
                            width:(NSNumber *)width
                           height:(NSNumber *)height
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;

//5.结束行情反馈(写)
- (void)surveyFinishWithUuid:(NSString *)uuid
                     version:(NSNumber *)version
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;

//6.获取行情调研单反馈列表
- (void)getResultsWithUuid:(NSString *)uuid
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;
//7.下载附件
- (void)downLoadAttachmentWithUuid:(NSString *)uuid
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;



//1.下载商品信息
- (void)getProductWithStartDate:(NSString *)startDate
                        Page_number:(NSUInteger)page_number
                        page_size:(NSUInteger)page_size
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//2.下载用户信息
- (void)getUserWithStartDate:(NSString *)startDate
                 Page_number:(NSUInteger)page_number
                     page_size:(NSUInteger)page_size
                       success:(void (^)(id))succ
                       failure:(void (^)(id))fail;


//3.供应商
- (void)getVendorWithStartDate:(NSString *)stateDate
                   Page_number:(NSUInteger)page_number
                        page_size:(NSUInteger)page_size
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;
//4.仓库
- (void)getWarehouseWithStartDate:(NSString *)stateDate
                          Page_number:(NSUInteger)page_number
                       page_size:(NSUInteger)page_size
                         success:(void (^)(id))succ
                         failure:(void (^)(id))fail;
//4.用户仓库
- (void)downloadUserWarehouseWithStartDate:(NSString *)stateDate
                      Page_number:(NSUInteger)page_number
                        page_size:(NSUInteger)page_size
                          success:(void (^)(id))succ
                          failure:(void (^)(id))fail;


//5.科目账款
- (void)getAccounttitleWithStartDate:(NSString *)stateDate
                         Page_number:(NSUInteger)page_number
                          page_size:(NSUInteger)page_size
                            success:(void (^)(id))succ
                            failure:(void (^)(id))fail;


//	新增行情反馈(写)
- (void)surveySaveResultWithDict: (NSDictionary *)dict
                      surveyUuid: (NSString *)surveyUuid
                         success: (void (^)(id))succ
                         failure: (void (^)(id))fail;
//1.7	商品单位
- (void)getProductunitWithPage_number:(NSUInteger)page_number
                            page_size:(NSUInteger)page_size
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;
//7.1	保存加工单(写)
- (void)saveProcessWithAuthenticode:(id)data
                            success:(void (^)(id))succ
                            failure:(void (^)(id))fail;

//7.2	获取加工单列表(读)
- (void)processQueryWithBillData:(id)data
                        success:(void (^)(id))succ
                        failure:(void (^)(id))fail;

//7.3	加工单明细(读) [已实现]
- (void)getResultWithProcessUuid:(NSString *)processUuid
                        success:(void (^)(id))succ
                        failure:(void (^)(id))fail;

//7.4	7.4	结束加工单(写)
- (void)finishProcessWithAuthenticode:(id)data
                            success:(void (^)(id))succ
                            failure:(void (^)(id))fail;
//7.5	作废加工单
- (void)abortProcessWithAuthenticode:(id)data
                            success:(void (^)(id))succ
                            failure:(void (^)(id))fail;
//1·保存采购通知单
- (void)savePurchaseNoticeWithData:(id)data
                            success:(void (^)(id))succ
                            failure:(void (^)(id))fail;
//2·获取采购通知单列表
- (void)getPurchaseNoticeListWithData:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

//3·采购通知单明细(读)
- (void)getPurchaseNoticeDetailedWithPurchaseUuid:(NSString *)purchaseUuid
                                          success:(void (^)(id))succ
                                          failure:(void (^)(id))fail;
//4·保存并提交采购通知单
- (void)saveAndSubmitPurchaseNoticeWithData:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;

//5·提交采购通知单
- (void)ComitPurchaseNoticeWithData:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;
//6·接受采购通知单
- (void)acceptPurchaseNoticeWithUuid:(NSString *)purchaseNoticeuuid
                             version:(NSNumber *)version
                            success:(void (^)(id))succ
                            failure:(void (^)(id))fail;
//7·结束采购通知单
- (void)finishPurchaseNoticeWithUuid:(NSString *)purchaseNoticeuuid
                             version:(NSNumber *)version                             success:(void (^)(id))succ
                             failure:(void (^)(id))fail;
//8·获取采购通知单跟进记录
- (void)getPurchaseNoticeRecodWithData:(NSString *)purchaseUuid
                             success:(void (^)(id))succ
                               failure:(void (^)(id))fail;

- (void)getProductUnitWithStartDate:(NSString *)startDate
                        Page_number:(NSUInteger)page_number
                            page_size:(NSUInteger)page_size
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;


//1.添加采购单
- (void)savePurchaseWithData:(id)data
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;
//2.获取采购单列表
- (void)queryPurchaseWithData:(id)data
                        success:(void (^)(id))succ
                        failure:(void (^)(id))fail;
//3.获取采购单详情
- (void)getPurchaseResultWithPurchaseUuid:(NSString *)purchaseUuid
                        success:(void (^)(id))succ
                        failure:(void (^)(id))fail;
//4.审核/拒绝/供应商确认/结束/作废采购单
- (void)dealByActionWithPurchaseUuid:(NSString *)purchaseUuid
                              action:(NSString *)action
                              remark:(NSString *)remark
                             version:(NSNumber *)version
                             success:(void (^)(id))succ
                                  failure:(void (^)(id))fail;

//5.采购单收货
- (void)recievePurchase:(id)data
                    success:(void (^)(id))succ
                    failure:(void (^)(id))fail;
/**
 *  发运单收货
 *
 *  @param data data description
 *  @param succ succ description
 *  @param fail fail description
 */
- (void)recieveTransport:(id)data
                 success:(void (^)(id))succ
                 failure:(void (^)(id))fail;
/**
 *  获取采购单库存库存
 *
 *  @param PurchaseUuid PurchaseUuid description
 *  @param succ         succ description
 *  @param fail         fail description
 */
- (void)purchaseStockWithPurchaseUuid:(NSString *)PurchaseUuid
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;
- (void)purchaseStockWithPurchaseUuid:(NSString *)PurchaseUuid product:(NSString *)productCode
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;

/**
 *  是否wms仓库
 *
 *  @param uuid 仓库uuid
 *  @param succ succ description
 *  @param fail fail description
 */
- (void)isWmsWarehouse:(NSString *)uuid success:(void (^)(id succ))succ
               failure:(void (^)(id fail))fail;

/**
 *  是否产品中心仓库
 *
 *  @param uuid 仓库uuid
 *  @param succ succ description
 *  @param fail fail description
 */
- (void)isCenterWarehouse:(NSString *)uuid success:(void (^)(id succ))succ
                  failure:(void (^)(id fail))fail;
//1.添加发运单
- (void)saveTransportWithData:(id)data
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;
//2.保存并提交
- (void)saveAndSubmitTransportWithData:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;
//3.获取发运单列表
- (void)queryTransPortWithData:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;

//4.获取发运单详情
- (void)getTransportResultWithTransportUuid:(NSString *)transportUuid
                                  success:(void (^)(id))succ
                                  failure:(void (^)(id))fail;
//5.结束发运单
- (void)endTransportWithTransportUuid:(NSString *)transportUuid
                              version:(NSNumber *)version
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;
//6.作废发运单
- (void)abortTransportWithTransportUuid:(NSString *)transportUuid
                              version:(NSNumber *)version
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;


//1.添加转运单
- (void)saveTransferWithData:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;

/**
 *  保存并提交转运单
 */
- (void)saveAndSubmitTransferWithData:(id)data
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;

//2.获取转运单列表
- (void)queryTransferWithData:(id)data
                      success:(void (^)(id))succ
                      failure:(void (^)(id))fail;


//3.获取转运单详情
- (void)getTransferResultWithTransferUuid:(NSString *)transferUuid
                                    success:(void (^)(id))succ
                                    failure:(void (^)(id))fail;
//4.结束转运单
- (void)endTransferWithTransferUuid:(NSString *)transferUuid
                              version:(NSNumber *)version
                              success:(void (^)(id))succ
                              failure:(void (^)(id))fail;
//5.作废转运单
- (void)abortTransferWithTransferUuid:(NSString *)transferUuid
                                version:(NSNumber *)version
                                success:(void (^)(id))succ
                                failure:(void (^)(id))fail;


//6.保存收货单
- (void)saveReceiveWithData:(id)data
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;

//7.保存并收货
-(void)saveReceiptAndReceiveWithData:(id)data
                   success:(void (^)(id))succ
                   failure:(void (^)(id))fail;
//版本更新
- (void)getVeisionIdWithType:(NSString *)type
                     success:(void (^)(id))succ
                     failure:(void (^)(id))fail;


//8.2 根据日期获取周
- (void)getWeekbydayWithStringDate: (NSString *)strDate
                           success:(void (^)(id))succ
                           failure:(void (^)(id))fail;
//1.报表首页，数据罗盘

- (void)queryHomepageWith:(id)data
                  success:(void (^)(id))succ
                  failure:(void (^)(id))fail;
//2.查询下级组织列表
- (void)queryLowerOrgsWith:(id)data
                  success:(void (^)(id))succ
                  failure:(void (^)(id))fail;
@end


