//
//  BottomSheetView.m
//  XFFruit
//
//  Created by n22 on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BottomSheetView.h"
#import "MaterialVIewController.h"
#import "GoodsViewController.h"
#import "CostViewController.h"
#define ContentHeight 44
#define BtnWidth (ScreenSize.width - 20*4)/3
#define BeginTag 8000
#define SpaceWidth 20


@interface BottomSheetView ()<UIScrollViewDelegate>
{
    UIScrollView *_bottomSV;
    UIImageView *_moveImageView;
    UIButton *_currentBtn;
    UIButton *_addBtn;
    MaterialVIewController *_materialVC;
    GoodsViewController *_goodsVC;
    CostViewController *_costVC;
}
@end

@implementation BottomSheetView

- (instancetype)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
        //界面
        [self bulidLayout];
    }
    return self;
}
#pragma mark - 布局
- (void)bulidLayout
{
    [self addChildView];

    [self createBottomView];
}
- (void)createBottomView{
    NSArray *arr = @[@"原料明细",@"成品明细",@"费用明细"];
    
    _bottomSV = [[UIScrollView alloc]initWithFrame:CGRectMake(0,ContentHeight + 4, ScreenSize.width, CGRectGetHeight(self.frame) - ContentHeight-2)];
    _bottomSV.showsHorizontalScrollIndicator  = NO;
    _bottomSV.showsVerticalScrollIndicator = NO;
    _bottomSV.pagingEnabled = YES;
    _bottomSV.delegate = self;
    _bottomSV.backgroundColor = [UIColor yellowColor];
    _bottomSV.contentSize = CGSizeMake(ScreenSize.width * arr.count, CGRectGetHeight(_bottomSV.frame));
    [self addSubview:_bottomSV];
    
    for (NSInteger i = 0; i < arr.count; i++) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
        [btn setTitle:arr[i] forState:UIControlStateNormal];
        btn.frame = CGRectMake(SpaceWidth + (BtnWidth+SpaceWidth) * i, 0, BtnWidth, ContentHeight);
        [btn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
        [btn setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
        btn.titleLabel.font = GXF_SIXTEENTEH_SIZE;
        btn.tag = i + BeginTag;
        [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:btn];
        
        UIView *view = [[UIView alloc]initWithFrame:CGRectMake(CGRectGetWidth(_bottomSV.frame) * i, 0, CGRectGetWidth(_bottomSV.frame), CGRectGetHeight(_bottomSV.frame))];
        
        if (i == 0) {
             view.backgroundColor = [UIColor redColor];
            _materialVC.viewFrame = view.bounds;
            [view addSubview:_materialVC.view];
        }else if(i == 1){
            view.backgroundColor = [UIColor blackColor];
            _goodsVC.viewFrame = view.bounds;
            [view addSubview:_goodsVC.view];
            
        }else if(i == 2){
            _costVC.viewFrame = view.bounds;
            [view addSubview:_costVC.view];
            view.backgroundColor = [UIColor blueColor];
        }
        [_bottomSV addSubview:view];
    }
    _moveImageView = [[UIImageView alloc]initWithFrame:CGRectMake(SpaceWidth, ContentHeight, BtnWidth,4)];
    _moveImageView.image  = [UIImage imageNamed:@"tab_line"];
    [self addSubview:_moveImageView];
}

- (void)addChildView{
    _materialVC = [[MaterialVIewController alloc]init];
    _goodsVC = [[GoodsViewController alloc]init];
    _costVC = [[CostViewController alloc]init];
}
- (void)btnClick:(UIButton *)btn{
    NSInteger index = btn.tag - BeginTag;
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * index;
        _moveImageView.frame = moveFrame;
        _bottomSV.contentOffset=CGPointMake(index * self.frame.size.width, 0);
    }];
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView{
    CGFloat offsetX = scrollView.contentOffset.x / self.frame.size.width;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * offsetX;
        _moveImageView.frame = moveFrame;
    }];
    _currentBtn.enabled = YES;
    UIButton *btn = (UIButton *) [self viewWithTag:offsetX + BeginTag];
    btn.enabled = NO;
    _currentBtn = btn;
}
@end
