//
//  CostCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "CostCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30
@implementation CostCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth - RightWidth - SpaceMargin* (4 -1))/4;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.typeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.typeLabel.textAlignment = NSTextAlignmentLeft;
    self.typeLabel.textColor = GXF_CONTENT_COLOR;
    self.typeLabel.text = @"苹果桃子";
    self.typeLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.actualLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.typeLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.actualLabel.textAlignment = NSTextAlignmentLeft;
    self.actualLabel.textColor = GXF_CONTENT_COLOR;
    self.actualLabel.text = @"30000";
    self.actualLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.paidLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.actualLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.paidLabel.textAlignment = NSTextAlignmentLeft;
    self.paidLabel.text = @"2015-04-05";
    self.paidLabel.textColor = GXF_CONTENT_COLOR;
    self.paidLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.leftLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.paidLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.leftLabel.textAlignment = NSTextAlignmentLeft;
    self.leftLabel.text = @"2015-04-05";
    self.leftLabel.textColor = GXF_CONTENT_COLOR;
    self.leftLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth, TableHeight);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.typeLabel];
    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.actualLabel];
    [self.contentView addSubview:self.paidLabel];
    [self.contentView addSubview:self.leftLabel];
    [self.contentView addSubview:self.lineLabel];


}
- (void)setFeeCost:(FeeAcountDetail *)fee row:(NSInteger)row
{
    self.seqLabel.text = [NSString stringWithFormat:@"%@",@(row+1)];
    self.typeLabel.text = fee.accounttitle;
    self.actualLabel.text = [fee.actualmoney stringValue];
    self.paidLabel.text = [fee.paidmoney stringValue];
    self.leftLabel.text = [fee.leftmoney stringValue];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
