//
//  TransportDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportDetailViewController.h"
#import "TransportProductViewController.h"
#import "Transport.h"
#import "TransportPdtDetail.h"
#import "FeeAcountDetail.h"
#import "BottomTransportView.h"
#define BottomHeight                                50
#define LeftMargin                                  15
#define LeftWidth                                   100
#define LeftHeight                                  30
#define TopMargin                                   15
typedef enum : NSUInteger {
    AbortTag = 20000,
    EndTag
    
} BtnTag;

@interface TransportDetailViewController ()
{
    UIScrollView *_scrollView;
    UIView *_transportView;
    UIView *_bottomView;
    UIButton *_firstBtn;
    UIButton *_secondBtn;
    BottomTransportView *_transView;
}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *purchaseLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *warehouseLabel;
@property (nonatomic,strong)UILabel *rwarehouseLabel;
@property (nonatomic,strong)UILabel *carnumberLabel;
@property (nonatomic,strong)UILabel *carhoneLabel;
@property (nonatomic,strong)UILabel *createOperLabel;
@property (nonatomic,strong)UILabel *noteLabel;
@end

@implementation TransportDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"发运单详情";
    [self bulifLayout];
        [self getDataFromServer];
}

- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                Transport *transport = [[Transport alloc]init];
                [transport setValuesForKeysWithDictionary:dictData];
                self.transport = transport;
                [strongSelf fetchtTransportDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getTransportResultWithTransportUuid:self.transport.uuid success:succ failure:fail];
}




- (void)fetchtTransportDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.transport.billnumber];
//    self.purchaseLabel.text = 
    if ([self.transport.state isEqualToString:TRANSPORT_STATE_UNRECEIVED]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"未发货";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_RECEIVED]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已发货";
    }else if ([self.transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已作废";
    }
//    self.noticeNumberLabel.text = (self.bill.noticeNumber.length == 0) ? @"无":(self.bill.noticeNumber);
    self.warehouseLabel.text = [IBTCommon checkString:self.transport.warehouseName];
    self.rwarehouseLabel.text = [IBTCommon checkString:self.transport.rwarehouseName];
    self.carnumberLabel.text = [IBTCommon checkString:self.transport.carnumber];
    self.carhoneLabel.text = [IBTCommon checkString:self.transport.carphone];
    self.noteLabel.text = [IBTCommon checkString:self.transport.note];
    self.createOperLabel.text = [NSString stringWithFormat:@"%@%@",[IBTCommon checkString:self.transport.create_operName],self.transport.create_time];
    
    
    [_transView refreshTranProduct:self.transport.pdtDetails];
    [_transView refreshCost:self.transport.accountDetails];
    [self setNoteHeight];
}

- (void)setNoteHeight
{
    CGFloat height =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = height;
    self.noteLabel.frame = noteFrame;
    
    CGFloat totalHeight = height + LeftHeight*9;
//    CGRect purchaseFrame = _purchaseView.frame;
//    purchaseFrame.size.height = totalHeight;
//    _purchaseView.frame = purchaseFrame;
//    
//    
//    CGRect bottomFrame = _bottomView.frame;
//    bottomFrame.origin.y = CGRectGetMaxY(_purchaseView.frame) + TopMargin;
//    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}

- (void)btnClick:(UIButton *)btn{
    CLog(@"%ld",(long)btn.tag);
    switch (btn.tag) {
        case AbortTag:
        {
            CLog(@"作废");
            [self dealByAction:TRANSPORT_STATE_ABORTED];
        }
            break;
        case EndTag:
        {
            CLog(@"结束");
            [self dealByAction:TRANSPORT_STATE_RECEIVED];
        }
            break;

        default:
            break;
    }
}
- (void)dealByAction:(NSString *)action{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                [ICRUserUtil sharedInstance].needFresh = YES;
                [self PopViewControllerAnimated:YES];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"操作异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    if ([action isEqualToString:TRANSPORT_STATE_ABORTED]) {
        [[ICRHTTPController sharedController] abortTransportWithTransportUuid:self.transport.uuid version:self.transport.version success:succ failure:fail];
    }else{
        [[ICRHTTPController sharedController] endTransportWithTransportUuid:self.transport.uuid version:self.transport.version success:succ failure:fail];
    }
}


#pragma mark - 视图初始化
- (void)bulifLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];
    
    _firstBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:AbortTag image:nil title:@"作废" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [self.view addSubview:_firstBtn];
    
    _secondBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(_firstBtn.frame)+ LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:EndTag image:nil title:@"结束" titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [self.view addSubview:_secondBtn];
    
    if ([self.transport.state isEqualToString:TRANSPORT_STATE_RECEIVED] || [self.transport.state isEqualToString:TRANSPORT_STATE_ABORTED]) {
        _firstBtn.hidden = YES;
        _secondBtn.hidden = YES;
        CGRect scrollViewFrame = _scrollView.frame;
        scrollViewFrame.size.height = ScreenSize.height - 64;
        _scrollView.frame = scrollViewFrame;
    }

    
    NSArray *leftArr = @[@"单号:",@"采购单:",@"状态:",@"发货仓库:",@"收货仓库:",@"车辆:",@"司机电话:",@"创建:",@"备注"];
    
    _transportView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight*leftArr.count +LeftMargin)];
    _transportView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_transportView];
    
    
    for (NSInteger i = 0 ; i < leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = leftArr[i];
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_transportView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _transportView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        
        if (i == 0) {
            self.billNumberLabel = rightLabel;
        }else if (i == 1) {
            self.purchaseLabel = rightLabel;
        }else if(i == 2){
            self.stateLabel = rightLabel;
        }else if(i == 3){
            self.warehouseLabel = rightLabel;
        }else if(i == 4){
            self.rwarehouseLabel = rightLabel;
        }else if(i == 5){
            self.carnumberLabel = rightLabel;
        }else if(i == 6){
            self.carhoneLabel = rightLabel;
        }else if(i == 7){
            self.createOperLabel = rightLabel;
        }else if(i == leftArr.count - 1){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
        }
        [_transportView addSubview:rightLabel];
    }
    [self createBottomView];
}
- (void)createBottomView{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_transportView.frame) + TopMargin, ScreenSize.width, 300)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _transView = [[BottomTransportView alloc]initWithFrame:_bottomView.bounds withHidden:YES];
//    _transView.backgroundColor = [UIColor redColor];
    [_bottomView addSubview:_transView];
    
//    _tpv = [[TransportProductViewController alloc]init];
//    [self addChildViewController:_tpv];
//    
//    _tpv.viewFrame = _bottomView.bounds;
//    _tpv.isHiddenEdit = YES;
//    [_bottomView addSubview:_tpv.view];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
