//
//  ChooseProductUnitViewController.m
//  XFFruit
//
//  Created by mac on 15/9/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseProductUnitViewController.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseProductUnitViewController ()

@end

@implementation ChooseProductUnitViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    //记录更新时间
    self.tableView.header.lastUpdatedTimeKey = ChooseProductUpdateDate;
    self.title = @"选择包装单位";
    [self fetchDataList:@"" tableStr:GXF_BASECLASS_PRODUCTUNIT];
}
- (void)getBaseDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf endRefreshing];
        [strongSelf fetchDataList:@"" tableStr:GXF_BASECLASS_PRODUCTUNIT];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getProductWithPage_number:0 page_size:100 success:succ failure:fail];
}
#pragma mark -成功
- (void)fetchProductList:(NSString *)titleStr{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = @"";
        if (titleStr.length > 0) {
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ WHERE NAME LIKE '%%%@%%' ORDER BY %@", [Product TableName],titleStr, @"uuid"];
        }else{
            sql = [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Product TableName], @"uuid"];
        }
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (![GXF_NSUSERFEFTAULTS objectForKey:ChooseProductUpdateDate]) {
            [GXF_NSUSERFEFTAULTS setObject:[NSDate date] forKey:ChooseProductUpdateDate];
            [GXF_NSUSERFEFTAULTS synchronize];
            [self getBaseDataFromServer];
        }else{
            [strongSelf.dataArr removeAllObjects];
            [strongSelf.dataArr addObject:self.tableView.header.lastUpdatedTime];
            [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
            [self tableViewRefresh];
        }
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[Product class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}



- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (self.currentIndexPath) {
            if (indexPath.row == self.currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            Product *product = self.dataArr[indexPath.row];
            cell.titleLabel.textColor = GXF_LEFTSIX_COLOR;
            NSString *proStr = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            [cell setTitleStr:proStr];
        }
    }
    return cell;
}
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GXF_BASECLASS_PRODUCTUNIT];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
