//
//  NewPurchaseNoticeViewController.m
//  XFFruit
//
//  Created by mac on 15/8/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewPurchaseNoticeViewController.h"

#import "SurveyCell.h"
#import "HPGrowingTextView.h"

#import "ChosePersonViewController.h"
#import "SurveyUser.h"
#import "Survey.h"
#import "PurchaseNoticeCell.h"
#import "ShopDetaileViewController.h"
#import "ShopDetail.h"
#define LeftMargin 15
#define LeftWidth 40
#define RightWidth 30
#define SpaceMargin 1
#define BtnHeight 44
#define TableHeight 46
#define CornerRadius 5
#define TitleSize 15
#define BtnSize 19
#define TotalHeight 432
#define KeyboardHeight 258
#define DateViewHeight 300
#define FootOfsetHeight 140
#define BottomViewHeight 60


typedef enum : NSUInteger {
    SaveTag = 8000,
    CommitTag,
} BtnTag;
@interface NewPurchaseNoticeViewController()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate,HPGrowingTextViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    NSMutableArray *_shopeArr;
    UITextField *_titleField;
    UILabel *_productLabel;
    UILabel *_startDateLabel;
    UILabel *_endDateLabel;
    UILabel *_personLabel;
    HPGrowingTextView *_noteTextView;
    NSIndexPath *selectedCellIndexPath;
    NSMutableArray *selectCellAry;
    BOOL _isClickStart;
    UITableView *mingXiTableView;
    
    
}
@property (nonatomic,strong)NSString *titleStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *beginDateStr;
@property (nonatomic,strong)NSString *endDateStr;
@property (nonatomic,strong)NSString *remarkStr;
@property (nonatomic,strong)NSMutableArray *users;
@property (nonatomic,strong)Survey *survey;
@property (nonatomic,strong)UILabel *HeardLabel;
@property (nonatomic,strong)UILabel *FootLabel;
@property (nonatomic,strong)UIButton *addDetailedButton;



@end

@implementation NewPurchaseNoticeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupSubviews];
    // Do any additional setup after loading the view.
}
-(void)setupSubviews
{
    selectCellAry=[[NSMutableArray alloc]initWithCapacity:1000];
    _dataArr=[[NSMutableArray alloc]initWithObjects:@"标题：",@"采购员：",@"备注：", nil];
    _shopeArr=[[NSMutableArray alloc]initWithObjects: nil];
    self.view.backgroundColor  = XXFBgColor;
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height/3-LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.tag=1001;
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    mingXiTableView=[[UITableView alloc]initWithFrame:CGRectMake(0, 2*LeftMargin+_tableView.frame.size.height, ScreenSize.width, ScreenSize.height-_tableView.height-ScreenSize.height/5)];
    mingXiTableView.backgroundColor = [UIColor whiteColor];
    mingXiTableView.tag=1002;
    mingXiTableView.bounces=NO;
    mingXiTableView.delegate=self;
    mingXiTableView.dataSource=self;
    
    UIView *footView2=[[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TableHeight)];
    footView2.backgroundColor=[UIColor clearColor];
    NSArray *ary=[NSArray arrayWithObjects:@"商品",@"价格",@"包装规格",@"包装数量", nil];
    //    NSArray *ary=[NSArray arrayWithObjects: nil];
    CGFloat gipWidth = (ScreenSize.width-(((RightWidth+70)+(LeftWidth+35))+(35+70)))/3;
    
    for (int i=0; i< ary.count;i++ ) {
        UILabel *lable=[[UILabel alloc]init];
        if (i==0) {
            lable.frame=CGRectMake(LeftWidth, 0, 35,TableHeight);
        }
        if (i==1) {
            lable.frame=CGRectMake(LeftWidth+35+gipWidth, 0, 35,TableHeight);
        }
        if (i==2) {
            lable.frame=CGRectMake(LeftWidth+35+gipWidth+35+gipWidth, 0, 70,TableHeight);
        }
        if (i==3) {
            lable.frame=CGRectMake(ScreenSize.width-RightWidth-70, 0, 70,TableHeight);
        }
        //        UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(LeftWidth + (SpaceMargin + headWidth)*i,0, headWidth, 50)];
        lable.text=[ary objectAtIndex:i];
        lable.textColor=GXF_CONTENT_COLOR;
        [footView2 addSubview:lable];
        
    }
    
    UIView *footView3 = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TableHeight)];
    footView3.backgroundColor=[UIColor clearColor];
    self.addDetailedButton=[UIButton  buttonWithType: UIButtonTypeCustom];
    [self.addDetailedButton  setFrame:CGRectMake(0, 0, ScreenSize.width, TableHeight)];
    [self.addDetailedButton setTitle:@"+ 点击添加商品明细" forState:UIControlStateNormal];
    [self.addDetailedButton addTarget:self action:@selector(addShopeDetailed) forControlEvents:UIControlEventTouchUpInside];
    [self.addDetailedButton setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    self.FootLabel=[[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, footView3.size.height-1, footView3.size.width-2*LeftMargin, 1))];
    self.FootLabel.backgroundColor = HexColor(@"e5e5e5");
    self.FootLabel.font = FontSize(TitleSize);
    self.HeardLabel=[[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, footView3.size.width-2*LeftMargin, 1))];
    self.HeardLabel.backgroundColor = HexColor(@"e5e5e5");
    self.HeardLabel.font = FontSize(TitleSize);
    //HexColor(@"e5e5e5")
    
    
    UIView *footView4 = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"50bd62")];
    [footView4 addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"f69100")];
    [footView4 addSubview:commitBtn];
    
    [self.view addSubview:footView4];
    [footView3 addSubview:self.addDetailedButton];
    [footView3 addSubview:self.HeardLabel];
    [footView3 addSubview:self.FootLabel];
    
    
    
    mingXiTableView.tableFooterView = footView3;
    mingXiTableView.tableHeaderView=footView2;
    [self.view addSubview:_tableView];
    [self.view addSubview:mingXiTableView];
    [self.view addSubview:footView4];
    
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    if ([tableView isEqual:_tableView]) {
        return 1;
    }else if ([tableView isEqual:mingXiTableView])
    {
        return 1;
    }
    
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if ([tableView isEqual:_tableView]) {
        return _dataArr.count;
    }else if ([tableView isEqual:mingXiTableView])
    {
        return _shopeArr.count;
    }
    return 1;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if ([tableView isEqual:_tableView]) {
        
        static NSString *cellID = @"cellID";
        SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
        
        if (cell == nil) {
            cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
            tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            if (indexPath.row >0 && indexPath.row < _dataArr.count - 1) {
                cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
            }
            [self createViewInCell:cell indexPath:indexPath];
        }
        [cell setTitleStr:_dataArr[indexPath.row]];
        return cell;
    }else if ([tableView isEqual:mingXiTableView])
    {
        
        static NSString *CellID = @"CellID";
        PurchaseNoticeCell *Cell = [tableView dequeueReusableCellWithIdentifier:CellID];
        if (Cell == nil) {
            Cell = [[PurchaseNoticeCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellID];
            tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
            Cell.selectionStyle = UITableViewCellSelectionStyleNone;
            
            //            Cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;向左箭头
            //            [self  showShopDetail:Cell indexPath:indexPath];
        }
        [self  showShopDetail:Cell indexPath:indexPath];
        if (Cell.isSelected==YES) {
            Cell.arrowView.image = [UIImage imageNamed:@"arrowdown"];
            Cell.backgroundColor=XXFBgColor;
            Cell.subSview.hidden=NO;
        }else
        {
            Cell.arrowView.image = [UIImage imageNamed:@"arrowright"];
            Cell.backgroundColor=[UIColor whiteColor];
            Cell.subSview.hidden=YES;
            
        }
        Cell.button.tag=indexPath.row;
        [Cell.button addTarget:self action:@selector(didtoucher:) forControlEvents:UIControlEventTouchUpInside];
        return Cell;
        
    }
    return nil;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([tableView isEqual:_tableView]) {
        if (indexPath.row == 2){
            return TableHeight*2;
        }else{
            return TableHeight;
        }
        
    }else if ([tableView isEqual:mingXiTableView])
    {
        
        
        if ([self  comperIndexpath:indexPath]) {
            return TableHeight*3;
        }else
        {
            return TableHeight;
        }
        
    }
    return TableHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([tableView isEqual:_tableView]) {
        
        if (indexPath.row == 2 || indexPath.row == 3) {
            [self keyboardHidden];
            if (indexPath.row == 2) {
                _isClickStart = YES;
            }else{
                _isClickStart = NO;
            }
            
        }else if(indexPath.row == 1){
            ChosePersonViewController *cvc = [ChosePersonViewController new];
            cvc.choseBaseInfo = ^(NSArray *users){
                NSString *textStr = @"";
                if (self.users.count <=0) {
                    [self.users removeAllObjects];
                }
                for (SurveyUser *user in users) {
                    if (textStr.length == 0) {
                        textStr = [textStr stringByAppendingFormat:@"%@",user.userName];
                    }else {
                        textStr = [textStr stringByAppendingFormat:@"、%@",user.userName];
                    }
                    [self.users addObject:[user dictForCommit]];
                }
                _personLabel.text = textStr;
                _personLabel.textColor = GXF_CONTENT_COLOR;
                
            };
            cvc.isMoreChose = NO;
            [self PushViewController:cvc animated:YES];
        }
    }else if ([tableView isEqual:mingXiTableView])
    {
        PurchaseNoticeCell *Cell=(PurchaseNoticeCell*)[mingXiTableView cellForRowAtIndexPath:indexPath ];
        if (Cell.isSelected==NO) {
            Cell.isSelected=YES;
            [selectCellAry addObject:indexPath];
        }else{
            Cell.isSelected=NO;
            [selectCellAry removeObject:indexPath];
        }
        
        selectedCellIndexPath = indexPath;
        
        
        [mingXiTableView reloadData];
    }
}


-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        _titleField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight)];
        _titleField.textAlignment = NSTextAlignmentRight;
        _titleField.textColor = GXF_CONTENT_COLOR;
        _titleField.placeholder = @"输入采购通知标题";
        _titleField.font = FontSize(15);
        _titleField.returnKeyType = UIReturnKeyDone;
        _titleField.delegate = self;
        [cell.contentView addSubview:_titleField];
        
    }else if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 4;
        _noteTextView.font = FontSize(15);
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
        CGRect lineFrame =  cell.lineLabel.frame;
        lineFrame.origin.y = TableHeight*2-1;
        cell.lineLabel.frame = lineFrame;
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 1) {
            contentLabel.text = @"选择采购员";
            _personLabel = contentLabel;
            [self preferDataInPersonLabel];
        }
    }
}
-(BOOL)comperIndexpath:(NSIndexPath *)indexPath
{
    for (NSIndexPath *path in selectCellAry) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)preferDataInPersonLabel{
    if (self.survey) {
        if (self.survey.users.count > 0) {
            NSString *personStr = @"";
            for (SurveyUser * surveyUser in self.survey.users) {
                if (personStr.length == 0) {
                    personStr = [personStr stringByAppendingFormat:@"%@",surveyUser.userName];
                }else {
                    personStr = [personStr stringByAppendingFormat:@"、%@",surveyUser.userName];
                }
            }
            _personLabel.text = personStr;
            _personLabel.textColor = GXF_CONTENT_COLOR;
            
        }
        if (self.users > 0) {
            [self.users addObjectsFromArray:self.survey.users];
        }
    }
}
//添加商品明细
-(void)addShopeDetailed
{
    
    ShopDetaileViewController *svc = [[ShopDetaileViewController    alloc] init];
    // 回调
    svc.choseShopDetail = ^(ShopDetail *shopDetail){
        [_shopeArr addObject:shopDetail];
        [mingXiTableView reloadData];
    };
    
    svc.title = [IBTCommon localizableString:@"AddShopDetail"];
    [self PushViewController:svc animated:YES];
    
}
-(void)showShopDetail:(PurchaseNoticeCell*)Cell indexPath:(NSIndexPath *)indexPath
{
    ShopDetail *shopDetail=[_shopeArr objectAtIndex:indexPath.row];
    Cell.SpLabel.text=shopDetail.merchandise;//商品
    Cell.DjLabel.text=shopDetail.packageUnitPrice;//包装单价
    Cell.BzggLabel.text=shopDetail.packageSpecification;//包装规格
    Cell.BzslLabel.text=shopDetail.packageQuantity;//包装数量
    Cell.packageSpecification.text=shopDetail.packageSpecification;//包装规格
    Cell.foundationQuantity.text=shopDetail.foundationQuantity;//基础数量
    Cell.packageUnitPrice.text=shopDetail.packageUnitPrice;//包装单价
    Cell.remark.text=shopDetail.remark;//备注
    Cell.packageQuantity.text=shopDetail.packageQuantity;//包装数量
    Cell.foundationUnitPrice.text=shopDetail.foundationUnitPrice;//基础单价
    Cell.totalMoney.text=shopDetail.totalMoney;//总金额
    
}
//编辑
- (void)didtoucher:(UIButton*)button
{
    ShopDetail *shopDetail=[_shopeArr objectAtIndex:button.tag];
    shopDetail.IsXiuGai=YES;
    //    EditorShopDetail
    ShopDetaileViewController *svc = [[ShopDetaileViewController    alloc] init];
    svc.choseShopDetail = ^(ShopDetail *Detail){
        if (Detail.IsDeleted) {
            [_shopeArr removeObjectAtIndex:button.tag];
        }else{
            [_shopeArr replaceObjectAtIndex:button.tag withObject:Detail];
        }
        
        [mingXiTableView reloadData];
        //        NSIndexPath *indexPath_1=[NSIndexPath indexPathForRow:button.tag inSection:0];
        //        NSArray *indexArray=[NSArray  arrayWithObject:indexPath_1];
        //        [mingXiTableView  reloadRowsAtIndexPaths:indexArray withRowAnimation:UITableViewRowAnimationLeft];
        
    };
    
    svc.shopDetail=shopDetail;
    svc.title = [IBTCommon localizableString:@"EditorShopDetail"];
    [self PushViewController:svc animated:YES];
    //
    NSLog(@"123213232332323223");
}
#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
    return YES;
}
- (void)growingTextViewDidBeginEditing:(HPGrowingTextView *)growingTextView{
    CGFloat offset = ScreenSize.height - TotalHeight - KeyboardHeight;
    if (offset < 0) {//上移
        [self setTableFrame:LeftMargin+offset];
    }
}
- (void)setTableFrame:(CGFloat)tabelH{
    [UIView animateWithDuration:0.25 animations:^{
        CGRect tableFrame = _tableView.frame;
        tableFrame.origin.y = tabelH;
        _tableView.frame = tableFrame;
    }];
}

- (void)keyboardHidden{
    [_titleField resignFirstResponder];
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
}
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag:
        {
            //            if ([self checkSurvey]) {
            //                [self saveSurvey:@"initial" message:@"正在保存..."];
            //            }
        }
            break;
        case CommitTag:
        {
            //            if ([self checkSurvey]) {
            //                [self saveSurvey:@"submitted" message:@"正在提交..."];
            //            }
        }
            break;
        default:
            break;
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
