//
//  PurchaseViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseViewController.h"
#import "NewPurchaseViewController.h"
#import "PurchaseCell.h"
#import "PurchaseBill.h"
#import "PurchaseDetailViewController.h"
#import "QueryOrder.h"
#import "SortMaskView.h"
#import "PurchaseBoltView.h"
#import "MJRefresh.h"

#define TopMargin 44
#define TableHeight 120
#define LeftMargin 20
#define BtnWidth 60
#define BtnHeight 24
#define BtnSize 16

typedef enum : NSUInteger {
    SortTag = 3000,
    BoltTag
    
} BtnTag;
@interface PurchaseViewController ()<UITableViewDataSource,UITableViewDelegate,PurchaseViewDelegate,SortMaskViewDelegate>
{
    UIView *_maskView;
    UIButton *currentBtn;
    SortMaskView *_sortView;
    PurchaseBoltView *_boltView;
    UIBarButtonItem  *_sureBtn;
    UIButton *_sortBtn;
    UIButton *_boltBtn;
    BOOL _isRefresh;
    BOOL _isLoadMore;
    NSInteger _currentPage;
}
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSString *noticeLike;
@property (nonatomic,strong)NSString *state;
@property (nonatomic,strong)NSString *billLike;
@property (nonatomic,strong)NSString *orderDirection;//asc(升序)，desc(降序)
@end

@implementation PurchaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [self initData];
    [self createBackBtn];
    [self createTableView];
    [self createRefresh];
    [self getData];

}
- (void)initData{
    self.dataArr = [NSMutableArray array];
//    for (NSInteger i = 0; i < 6; i++) {
//        PurchaseBill *bill = [PurchaseBill new];
//        bill.billNumber = @"150903000013";
//        bill.noticeNumber = @"134594059654";
//        bill.create_operName = @"创建人";
//        bill.create_time = @"2013-03-04";
//        bill.vendor_name  = @"供应商";
//        bill.total = [NSNumber numberWithFloat:22];
//        bill.charge = [NSNumber numberWithFloat:333];
//        bill.remark = @"备注";
//        bill.lastModify_operName = @"最后修改人";
//        bill.vendorConfirmTime = @"否";
//        
//        if (i == 0) {
//            bill.state = @"initial";
//        }else if(i == 1){
//            bill.state = @"submitted";
//        }else if(i == 2){
//            bill.state = @"rejected";
//        }else if(i == 3){
//            bill.state = @"approved";
//        }else if(i == 4){
//            bill.state = @"shipping";
//        }else if(i == 5){
//            bill.state = @"finished";
//        }
//        [self.dataArr addObject:bill];
//    }
}
- (void)getData{
    [ICRUserUtil sharedInstance].needFresh = NO;
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf fetchtPuchaseList:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    
    NSMutableArray *orderArr =[NSMutableArray array];
    if (self.orderDirection.length > 0 && ![self.orderDirection isEqualToString:@"none"]) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"lastModified";
        order.direction = self.orderDirection;
        [orderArr addObject:[order dictForCommit]];
    }
    id billObject = [NSNull null];
    if (self.billLike.length > 0) {
        billObject = self.billLike;
        if (self.orderDirection.length > 0 && ![self.orderDirection isEqualToString:@"none"]) {
            QueryOrder *order = [QueryOrder new];
            order.field = @"billNumber";
            order.direction = self.orderDirection;
            [orderArr addObject:[order dictForCommit]];
        }
    }
    id stateObject = [NSNull null];
    if (self.state.length > 0 && ![self.state isEqualToString:@"none"]) {
        stateObject = self.state;
        if (self.orderDirection.length > 0 && ![self.orderDirection isEqualToString:@"none"]) {
            QueryOrder *order = [QueryOrder new];
            order.field = @"state";
            order.direction = self.orderDirection;
            [orderArr addObject:[order dictForCommit]];
        }
    }
    id noticeObject = [NSNull null];
    if (self.noticeLike.length > 0) {
        noticeObject = self.noticeLike;
        if (self.orderDirection.length > 0 && ![self.orderDirection isEqualToString:@"none"]) {
            QueryOrder *order = [QueryOrder new];
            order.field = @"noticeNumber";
            order.direction = self.orderDirection;
            [orderArr addObject:[order dictForCommit]];
        }
    }
    if (orderArr.count == 0) {
        QueryOrder *order = [QueryOrder new];
        order.field = @"billNumber";
        order.direction = @"desc";
        [orderArr addObject:[order dictForCommit]];
        
    }
    NSDictionary *dict = @{
                           @"billNumberLike":billObject,
                           @"state":stateObject,
//                           @"noticeNumberLike":noticeObject,
                           @"titleLike":[NSNull null],
                           @"vendorUuid":[NSNull null],
                           @"queryOrders":orderArr,
                           @"userUuid":userUtil.userId,
                           @"pageNumber":@(_currentPage),
                           @"pageSize":@(20)};
    [[ICRHTTPController sharedController] queryPurchaseWithData:dict success:succ failure:fail];
}
- (void)fetchtPuchaseList:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            if (_currentPage == 0) {
                if (self.dataArr.count > 0) {
                    [self.dataArr removeAllObjects];
                }
            }
            NSArray *recodesArr = data[ @"data" ][ @"records" ];
            for (NSDictionary *purchaseBillDict in recodesArr) {
                PurchaseBill *purchaseBill = [[PurchaseBill alloc]init];
                [purchaseBill setValuesForKeysWithDictionary:purchaseBillDict];
                [self.dataArr addObject:purchaseBill];
            }
            NSDictionary *pageDict = data[ @"data" ][ @"paging" ];
            NSInteger pageCount = [pageDict[@"pageCount"] integerValue];
            [self.tableView reloadData];
            [self endRefreshing];
            if (pageCount <= _currentPage) {
                [self.tableView.footer noticeNoMoreData];
            }
            if (_currentPage == 0 && self.dataArr.count > 0) {
                [self.tableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:0 inSection:0] atScrollPosition:UITableViewScrollPositionTop animated:YES];
            }
        }else{
            [IBTLoadingView showTips:message];
        }
    }else{
        [IBTLoadingView showTips:@"      无记录      "];
    }


}
- (void)createRefresh{
    self.tableView.header = [MJRefreshNormalHeader headerWithRefreshingBlock:^{
        if (_isRefresh) {
            return ;
        }
        _isRefresh = YES;
        _currentPage = 0;
        [self getData];
    }];
    self.tableView.header.lastUpdatedTimeKey = PurchaseUpdateDate;
    
    self.tableView.footer = [MJRefreshAutoNormalFooter footerWithRefreshingBlock:^{
        if (_isLoadMore) {
            return ;
        }
        _isLoadMore = YES;
        _currentPage ++;
        [self getData];
    } ];
}
#pragma mark - 结束刷新
- (void)endRefreshing{
    _isLoadMore = NO;
    _isRefresh = NO;
    [self.tableView.header endRefreshing];
    [self.tableView.footer endRefreshing];
}
- (void)createTableView
{
    _sureBtn = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = _sureBtn;

    _sortBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:SortTag image:@"black_arrow_down_with_text" title:nil titleColor:GXF_DETAIL_COLOR isCorner:NO corner:0 bgColor:nil];
    _sortBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_sortBtn];
    
    _boltBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(ScreenSize.width-BtnWidth - LeftMargin,10,BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:BoltTag image:@"black_filter_with_text" title:nil titleColor:GXF_DETAIL_COLOR isCorner:NO corner:0 bgColor:nil];
    _boltBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_boltBtn];
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    _maskView = [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, ScreenSize.height - 64- TopMargin)];
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    _maskView.hidden = YES;
    [self.view addSubview:_maskView];
}

#pragma mark -按钮事件
- (void)sortClick:(UIButton *)btn{
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    _maskView.hidden = NO;
    if (btn.tag == SortTag) {
        if(_boltView){
            [self hiddenBoltMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
            [self hiddenSortMaskView:YES];
            currentBtn = nil;
        }else{
            [btn setImage:[UIImage imageNamed:@"select_arrow_up_text"] forState:UIControlStateNormal];
            if (_sortView == nil) {
                _sortView = [[SortMaskView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 150) withOrderDirection:self.orderDirection];
                _sortView.dataArr = [[NSMutableArray alloc]initWithObjects:@"按时间顺序",@"按时间逆序",@"默认排序",nil];
                _sortView.delegate = self;
                [_maskView addSubview:_sortView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _sortView.frame;
                    sortFrame.origin.y = 0;
                    _sortView.frame = sortFrame;
                }];
            }
            currentBtn = btn;
        }
    }else if(btn.tag == BoltTag){
        if (_sortView) {
            [self hiddenSortMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
            [self hiddenBoltMaskView:YES];
            currentBtn = nil;
            
        }else{
            [btn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
            if (_boltView == nil) {
                _boltView = [[PurchaseBoltView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 274) state:self.state billNumber:self.billLike noticeNumber:self.noticeLike];
                
                _boltView.backgroundColor = XXFBgColor;
                _boltView.delegate = self;
                //initial(未提交)submitted(已提交)rejected(已拒绝)approved(已审批)shipping(发运中)finished(已完成)
                _boltView.dataArr = [[NSMutableArray alloc]initWithObjects:@"未提交",@"已提交",@"已拒绝" ,@"已审批",@"发运中",@"已完成",nil];
                [_maskView addSubview:_boltView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _boltView.frame;
                    sortFrame.origin.y = 0;
                    _boltView.frame = sortFrame;
                }];
                currentBtn = btn;
            }
        }
    }
}

- (void)hiddenSortMaskView:(BOOL)isHide{
    currentBtn = nil;
    [self checkSortBtnColor];
    if (isHide == NO) {
        [_sortView removeFromSuperview];
        _sortView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _sortView.frame;
            sortFrame.origin.y = -105;
            _sortView.frame = sortFrame;
            _maskView.backgroundColor = RGBA(0, 0, 0, 0);
        }completion:^(BOOL finished) {
            [_sortView removeFromSuperview];
            _sortView = nil;
            _maskView.hidden = YES;
        }];
    }
}
- (void)hiddenBoltMaskView:(BOOL)isHide{
    currentBtn = nil;
    [self checkBoltBtnColor];
    if (isHide == NO) {
        [_boltView removeFromSuperview];
        _boltView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _boltView.frame;
            sortFrame.origin.y = -105;
            _boltView.frame = sortFrame;
            _maskView.backgroundColor = RGBA(0, 0, 0, 0);
        }completion:^(BOOL finished) {
            [_boltView removeFromSuperview];
            _boltView = nil;
            _maskView.hidden = YES;
        }];
    }
}

//检测排序的颜色
- (void)checkSortBtnColor{
    if (self.orderDirection.length > 0) {
        [_sortBtn setImage:[UIImage imageNamed:@"select_arrow_up_text"] forState:UIControlStateNormal];
    }else{
        [_sortBtn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
        
    }
}
- (void)checkBoltBtnColor{
    if (self.state.length > 0 || self.noticeLike.length > 0 || self.billLike.length > 0) {
        [_boltBtn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
    }else{
        [_boltBtn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
        
    }
}
#pragma mark - 确定
- (void)sureClick{
    
    if (self.state.length > 0 || self.billLike.length > 0 || self.noticeLike.length > 0 ||self.orderDirection.length > 0) {
        [_boltView.noticeFiled resignFirstResponder];
        [_boltView.billFiled resignFirstResponder];
        _currentPage = 0;
        
        //请求
        [self getData];
        //还原数据
        if (_sortView) {
            [self hiddenSortMaskView:YES];
        }
        if (_boltView) {
            [self hiddenBoltMaskView:YES];
        }
    }

}

#pragma mark - sortDelegate
- (void)getSortValueSelectRow:(NSString *)state{
    if (state.length > 0) {
        self.orderDirection = state;
        CLog(@"%@",state);
    }
}
#pragma mark - boltDelegate
- (void)getBoltValueSelectRow:(NSString *)state{
    self.state = state;
    CLog(@"%@",state);
}
- (void)getbillLike:(NSString *)billLike{
    self.billLike = billLike;
    CLog(@"%@",billLike);
}
- (void)getnoticeLike:(NSString *)noticeLike{
    self.noticeLike = noticeLike;
    CLog(@"%@",noticeLike);
}
- (void)clearBoltInformation{
    //清空所有条件
    if (self.billLike.length > 0) {
        self.billLike = @"";
    }
    if (self.noticeLike.length > 0) {
        self.noticeLike = @"";
    }
    if (self.state.length > 0) {
        self.state = @"";
    }
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"SurveyID";
    PurchaseCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[PurchaseCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (self.dataArr.count > 0) {
        PurchaseBill *bill = self.dataArr[indexPath.row];
        [cell setPurchaseBill:bill];
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    if (_dataArr.count > 0) {
        PurchaseBill *bill = _dataArr[indexPath.row];
        if ([bill.state isEqualToString:PURCHASE_STATE_INITIAL] || [bill.state isEqualToString:PURCHASE_STATE_REJECTED]) {
            NewPurchaseViewController *nvc = [NewPurchaseViewController new];
            nvc.purchaseBill = bill;
            nvc.title = @"修改采购单";
            [self PushViewController:nvc animated:YES];
        }else{
            PurchaseDetailViewController *pvc = [PurchaseDetailViewController new];
            pvc.title = @"查看采购单";
            pvc.bill = bill;
            [self PushViewController:pvc animated:YES];
        }
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (void)createBackBtn{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    [btn setImage:[UIImage imageNamed:@"back"] forState:UIControlStateNormal];
    btn.frame  = CGRectMake(0, 0, 12, 20);
    [btn addTarget:self action:@selector(backRV) forControlEvents:UIControlEventTouchUpInside];
    UIBarButtonItem *back = [[UIBarButtonItem alloc]initWithCustomView:btn];
    self.navigationItem.leftBarButtonItem = back;
}
- (void)backRV{
    [self PopToRootViewControllerAnimated:YES];
}
- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    if ([ICRUserUtil sharedInstance].needFresh && self.tableView != nil) {
        [self.tableView.header beginRefreshing];
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
