//
//  ICRAppViewControllerManager.m
//  XFFruit
//
//  Created by Xummer on 3/23/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRAppViewControllerManager.h"
#import "ICRUIAppearance.h"

#import "IBTUINavigationController.h"
#import "ICRLoginViewController.h"
#import "ICRHomeViewController.h"
#import "BusinessViewController.h"
#import "ICRStoreViewController.h"
#import "ICRSyncViewController.h"
#import "ICRSystemViewController.h"

@interface ICRAppViewControllerManager ()
<
    UITabBarControllerDelegate
>
@end

@implementation ICRAppViewControllerManager

+ (UINavigationController *)getCurrentNavigationController {
    return nil;
}

+ (IBTTabBarController *)getTabBarController {
    return [[self getAppViewControllerManager] getTabBarController];
}

+ (ICRAppViewControllerManager *)getAppViewControllerManager {
    static ICRAppViewControllerManager *_sharedMgr = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
        _sharedMgr = [[ICRAppViewControllerManager alloc] initWithWindow:keyWindow];
    });
    
    return _sharedMgr;
}

- (id)initWithWindow:(UIWindow *)window {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    [ICRUIAppearance CustomAppearance];
    
    m_window = window;
    m_arrTabBarBaseViewController = [NSMutableArray array];
    m_arrViewController = [NSMutableArray array];
    
    // Automatic login
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    if ([userUtil isLogin]) {
        [self openMainFrame];
    }
    else {
        [self openFirstView];
    }
    
    return self;
}

- (void)dealloc {
    m_window = nil;
    m_arrViewController = nil;
    m_arrTabBarBaseViewController = nil;
    m_tabbarController = nil;
}

#pragma mark - Public Method
- (CGSize)getRootViewSize {
    return m_window.rootViewController.view.frame.size;
}

- (IBTTabBarController *)getTabBarController {
    return m_tabbarController;
}

- (NSUInteger)getCurTabBarIndex {
    return m_tabbarController.selectedIndex;
}

- (UIViewController *)getTabBarBaseViewController:(CRTapBarItemIndex)index {
    if (index > kCRSystem || index > [m_arrTabBarBaseViewController count]) {
        return nil;
    }
    
    return m_arrTabBarBaseViewController[ index ];
}

- (void)openFirstView {
    if ([m_window.rootViewController isKindOfClass:[IBTUINavigationController class]]) {
        IBTUINavigationController *navCtrl = (IBTUINavigationController *)m_window.rootViewController;
        
        if ([[navCtrl.viewControllers lastObject] isKindOfClass:[ICRLoginViewController class]]) {
            return;
        }
        else if ([[navCtrl.viewControllers firstObject] isKindOfClass:[ICRLoginViewController class]]) {
            [navCtrl popToRootViewControllerAnimated:YES];
            return;
        }
    }
    
    ICRLoginViewController *loginCtrl = [[ICRLoginViewController alloc] init];
    IBTUINavigationController *naviCtrl = [[IBTUINavigationController alloc] initWithRootViewController:loginCtrl];
    naviCtrl.navigationBarHidden = YES;
    
    m_window.rootViewController = naviCtrl;
}
//   主页面
- (void)openMainFrame {
    if (m_window.rootViewController &&
        m_window.rootViewController == m_tabbarController) {
        return;
    }
    
    [m_arrTabBarBaseViewController removeAllObjects];
    [m_arrViewController removeAllObjects];
    
    [self createHomeViewController];//首页
    [self  createBusinessViewController];//业务
    [self createStoreViewController];
    [self createSyncViewController];
    [self createSystemViewController];
    
    
    if (!m_tabbarController) {
        m_tabbarController = [[IBTTabBarController alloc] init];
        m_tabbarController.delegate = self;
    }
//    添加  首页  门店  同步   系统
    [m_tabbarController setViewControllers:m_arrViewController];
//    默认首次进入
    [m_tabbarController setSelectedIndex:kCRHome];
//    底部bar
    m_window.rootViewController = m_tabbarController;
}

#pragma mark - Actions
- (void)doLogout {
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    [userUtil logout];
    [ICRDataBaseController CleanUpDBPath];
    
    [self openFirstView];
}

#pragma mark - Creation
- (void)createHomeViewController {
    
    NSString *nsTitle = ACETapBarItemNames[ kCRHome ];
    
    ICRHomeViewController *homeVCtrl = [[ICRHomeViewController alloc] init];
    [m_arrTabBarBaseViewController addObject:homeVCtrl];
    homeVCtrl.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:homeVCtrl];
    [m_arrViewController addObject:navCtrl];
    
    navCtrl.title = nsTitle;
}
-(void)createBusinessViewController
{
    NSString *nsTitle = ACETapBarItemNames[ kCRBusiness ];
    BusinessViewController *businessVCtrl=[[BusinessViewController alloc]init];
    [m_arrTabBarBaseViewController addObject:businessVCtrl];
    businessVCtrl.title=[IBTCommon localizableString:nsTitle];
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:businessVCtrl];
    [m_arrViewController addObject:navCtrl];
    
    navCtrl.title = nsTitle;

}
- (void)createStoreViewController {
    NSString *nsTitle = ACETapBarItemNames[ kCRStore ];
    
    ICRStoreViewController *storeVCtrl = [[ICRStoreViewController alloc] init];
    [m_arrTabBarBaseViewController addObject:storeVCtrl];
    storeVCtrl.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:storeVCtrl];
    [m_arrViewController addObject:navCtrl];
    
    navCtrl.title = nsTitle;
}

- (void)createSyncViewController {
    NSString *nsTitle = ACETapBarItemNames[ kCRSync ];
    
    ICRSyncViewController *syncVCtrl = [[ICRSyncViewController alloc] init];
    [m_arrTabBarBaseViewController addObject:syncVCtrl];
    syncVCtrl.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:syncVCtrl];
    [m_arrViewController addObject:navCtrl];
    
    navCtrl.title = nsTitle;
}

- (void)createSystemViewController {
    NSString *nsTitle = ACETapBarItemNames[ kCRSystem ];
    
    ICRSystemViewController *systemVCtrl = [[ICRSystemViewController alloc] init];
    [m_arrTabBarBaseViewController addObject:systemVCtrl];
    systemVCtrl.title = [IBTCommon localizableString:nsTitle];
    
    IBTUINavigationController *navCtrl = [[IBTUINavigationController alloc] initWithRootViewController:systemVCtrl];
    [m_arrViewController addObject:navCtrl];
    
    navCtrl.title = nsTitle;
}

@end
