//
//  ICRAppDelegate.m
//  XFFruit
//
//  Created by Xummer on 3/23/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRAppDelegate.h"
#import "ICRAppViewControllerManager.h"
#import "ICRURLProtocol.h"
#import "BMKMapManager.h"

@interface ICRAppDelegate ()
@property (strong, nonatomic) BMKMapManager *mapManager;

@end

@implementation ICRAppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    // Override point for customization after application launch.
    
    self.window.backgroundColor = [UIColor whiteColor];
    [self.window makeKeyWindow];
    
    [NSURLProtocol registerClass:[ICRURLProtocol class]];
    NSString * path = [NSSearchPathForDirectoriesInDomains(NSDocumentationDirectory, NSUserDomainMask, YES) lastObject];
    CLog(@"%@",path);
    
    [self setupBMKMapMgr];
    _m_appViewControllerMgr = [ICRAppViewControllerManager getAppViewControllerManager];
    
    
    
#pragma 版本更新
   // [self enterpriseUpdate];
    [self.window makeKeyAndVisible];
    
    return YES;
}
#pragma mark enterprise alertView 企业版提示
- (void)enterpriseUpdate{
    NSString *currentVersion = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"];

    NSComparisonResult comResult = [self p_compareVersions: currentVersion betweenVersion2:@"后台返回的app版本"];//_versionModel.ClientVersion];
    if (comResult == NSOrderedAscending) {
        //299企业版的更新  @"有新的版本可供下载"
  
        UIAlertView *alertV = [[UIAlertView alloc]initWithTitle:@"新版本" message:  @"" delegate:self cancelButtonTitle:@"下次再说"otherButtonTitles: @"去下载", nil];//_versionModel.UpgradeRemark
//        alertV.tag = alertVEnterprise;
//        [alertV show];
      
    }else{
        [IBTLoadingView showProgressLabel:@"暂无新版本"];
        
    }
    
    
}
- (void) alertView:(UIAlertView *)alertView
clickedButtonAtIndex:(NSInteger)buttonIndex {
    if (buttonIndex == 1) {
        [[UIApplication sharedApplication] openURL:[NSURL URLWithString:@"app下载的url"]];
    }
}
//比较版本号
- (NSComparisonResult)p_compareVersions: (NSString *)version1 betweenVersion2: (NSString *)version2{
    NSComparisonResult result = NSOrderedSame;
    if ([version2 isEqualToString:@""]) {
        result = NSOrderedDescending;
        return result ;
    }
    
    NSMutableArray *a = (NSMutableArray *)[version1 componentsSeparatedByString:@"."];
    NSMutableArray *b = (NSMutableArray *)[version2 componentsSeparatedByString:@"."];
    
    while (a.count < b.count) {[ a addObject:@"0"];}
    while (b.count < a.count) {[ b addObject:@"0"];}
    
    for(int i = 0; i < a.count; ++i){
        if ([[a objectAtIndex:i] integerValue] < [[b objectAtIndex:i] integerValue]) {
            result = NSOrderedAscending;
            break;
        }else if ([[b objectAtIndex:i] integerValue] < [[a objectAtIndex:i] integerValue]){
            result = NSOrderedDescending;
            break;
        }
    }
    return  result;
    
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

#pragma mark - Private
- (void)setupBMKMapMgr {
    self.mapManager = [[BMKMapManager alloc] init];
    BOOL ret = [_mapManager start:BMK_ID generalDelegate:nil];
    if (!ret) {
        CLog(@"mapManager start failed!");
    }
}

@end
