//
//  TransportPurchaseCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportPurchaseCell.h"
#import "TransportPurductCell.h"
#import "HeaderCell.h"
#define TableHeight 44
#define ShowHeight  110

@interface TransportPurchaseCell ()
@property (strong, nonatomic) HeaderCell *headCell;
@end
@implementation TransportPurchaseCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.contentView.backgroundColor = XXFBgColor;
    
    self.bgView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 170)];
    self.bgView.backgroundColor = [UIColor whiteColor];
    [self.contentView addSubview:self.bgView];
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,0, ScreenSize.width, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;

    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, 0, ScreenSize.width, 44))];
    self.titleLabel.textColor = GXF_NAVIGAYION_COLOR;
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.font = GXF_SEVENTEENTH_SIZE;
    
    self.secondLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,44-1, ScreenSize.width, 1))];;
    self.secondLabel.backgroundColor = GXF_LINE_COLOR;

    
    [self.bgView addSubview:self.titleLabel];
    [self.bgView addSubview:self.lineLabel];
    [self.bgView addSubview:self.secondLabel];

    self.secondTable = [[UITableView alloc]initWithFrame:(CGRectMake(0, 44,ScreenSize.width, self.bgView.height-45)) style:(UITableViewStylePlain)];
    
    self.secondTable.delegate = self;
    self.secondTable.dataSource = self;
        self.secondTable.bounces = NO;
    self.secondTable.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.bgView addSubview:self.secondTable];
    NSArray *arr = @[@"商品",@"包装规格",@"已收货包装数",@"可运包装数"];
    
    __weak TransportPurchaseCell *weakSelf = self;
    self.headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) WithCheckBoxArr:arr checkBox:^(BOOL isSelect) {
        if (isSelect) {
//            [weakSelf.selectArr removeAllObjects];
            
            for (TransportPdtDetail *pdt in weakSelf.secondArr) {
                if (pdt.shippedFlag.boolValue) {
                    NSString *msg = [NSString stringWithFormat:@"商品[%@]已被转运或者发运！", pdt.productName];
                    ShowMessage(msg);
                    weakSelf.headCell.checkBox.isSelected = NO;
                    return ;
                }
            }
            
            for (TransportPdtDetail *pdt in weakSelf.secondArr) {
                if (![weakSelf.selectArr containsObject:pdt]) {
                    [weakSelf.selectArr addObject:pdt];
                }
            }
            
//            [weakSelf.selectArr addObjectsFromArray:weakSelf.secondArr];
            
        }else{
            [weakSelf.selectArr removeObjectsInArray:weakSelf.secondArr];
        }
        [weakSelf.secondTable reloadData];
    }];
    self.secondTable.tableHeaderView = self.headCell;
    

}
- (void)setPurchaseBill:(PurchaseBill *)bill selectArr:(NSMutableArray *)selectArr{
    self.bill = bill;
    self.bgView.height = 92 + bill.products.count * 44;
    self.secondTable.height = self.bgView.height - 45;
    self.titleLabel.text = [NSString stringWithFormat:@"采购单:%@  创建人:%@",
                            bill.billNumber, bill.create_operName];
    self.secondArr = [NSMutableArray array];
    self.selectArr = selectArr;
    [self.secondArr addObjectsFromArray:bill.products];
    
    //重要
    [self.secondTable reloadData];
}

- (void)setTransPort:(Transport *)bill selectArr:(NSMutableArray *)selectArr{
    self.bgView.height = 92 + bill.pdtDetails.count * 44;
    self.secondTable.height = self.bgView.height - 45;
    self.titleLabel.text = [NSString stringWithFormat:@"发运单号:%@",bill.billnumber];
    self.secondArr = [NSMutableArray array];
    self.selectArr = selectArr;
    [self.secondArr addObjectsFromArray:bill.pdtDetails];
    //重要
    [self.secondTable reloadData];
}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.secondArr.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellID = @"TransportPurductCell";
    TransportPurductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    cell.editBtn.enabled = NO;
    [self checkIsSelectAll];
    if (cell == nil) {
        cell = [[TransportPurductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID withImageName:@"selected"];
        cell.editBtn.hidden = YES;
        cell.rightImageName = @"edit";
    }
    if (self.secondArr.count > 0) {
        TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
        [cell setPdtDetail:billProduct row:indexPath.row];
        
        if ([self isHaveIndexPath:billProduct]) {
            cell.editBtn.hidden = NO;
            //        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
            //        cell.lineLabel.y = ShowHeight + TableHeight -1;
            //        cell.showView.height = ShowHeight;
            //        cell.backgroundColor = XXFBgColor;
        }else{
            cell.editBtn.hidden = YES;
            //        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
            //        cell.lineLabel.y =  TableHeight -1;
            //        cell.showView.height = 0;
            //        cell.backgroundColor = [UIColor whiteColor];
        }
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}

- (void)checkIsSelectAll {
    BOOL isHasAll = YES;
    for (TransportPdtDetail *detail in self.bill.products) {
        if (![self.selectArr containsObject:detail]) {
            isHasAll = NO;
        }
    }
    
    self.headCell.checkBox.isSelected = isHasAll;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
//    TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
//    if ([self isHaveIndexPath:billProduct]) {
//        return ShowHeight + TableHeight;
//    }
    return TableHeight;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    //如果不是发运单，则可以单选
//    if (!self.isTransportIn) {
        TransportPdtDetail * billProduct = self.secondArr[indexPath.row];
        if (billProduct.shippedFlag.boolValue) {
            ShowMessage(@"该商品已经被转运或发运！");
            return;
        }
        
        TransportPurductCell *cell = (TransportPurductCell *)[tableView cellForRowAtIndexPath:indexPath];
        if (![self isHaveIndexPath:billProduct]) {
            cell.editBtn.hidden = NO;
            [self.selectArr addObject:billProduct];
            
        }else{
            [self.selectArr removeObject:billProduct];
            cell.editBtn.hidden = YES;
        }
        self.headCell.checkBox.isSelected = self.selectArr.count == self.secondArr.count;
        [self.secondTable reloadData];
        
//    }
}
- (BOOL)isHaveIndexPath:(TransportPdtDetail *)billProduct{
    for (TransportPdtDetail *detail in self.selectArr) {
        if (detail.uuid == billProduct.uuid || [detail.uuid isEqualToString:billProduct.uuid]) {
            return YES;
        }
    }
    return NO;
}
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
