//
//  TransportCreateProductCell.m
//  XFFruit
//
//  Created by Javen on 2017/7/7.
//  Copyright © 2017年 Xummer. All rights reserved.
//

#import "TransportCreateProductCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowWidth (ScreenSize.width  - LeftMargin*2 - SmallSize)/2
#define ShowHeight 20
@implementation TransportCreateProductCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier withImageName:(NSString *)imageName{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.rightImageName = imageName;
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (4 -1))/4;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    self.smallImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = GXF_CONTENT_COLOR;
    self.seqLabel.text = @"13";
    self.seqLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.textColor = GXF_CONTENT_COLOR;
    self.titleLabel.text = @"苹果桃子";
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.qpcLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.qpcLabel.textAlignment = NSTextAlignmentCenter;
    self.qpcLabel.textColor = GXF_CONTENT_COLOR;
    self.qpcLabel.font = GXF_SIXTEENTEH_SIZE;
    self.qpcLabel.text = @"规格";
    
    self.waitRecieveQtyLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.qpcLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.waitRecieveQtyLabel.textAlignment = NSTextAlignmentCenter;
    self.waitRecieveQtyLabel.textColor = GXF_CONTENT_COLOR;
    self.waitRecieveQtyLabel.text = @"80";
    self.waitRecieveQtyLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.recievedQtyLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.waitRecieveQtyLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.recievedQtyLabel.textAlignment = NSTextAlignmentCenter;
    self.recievedQtyLabel.text = @"200";
    self.recievedQtyLabel.textColor = GXF_CONTENT_COLOR;
    self.recievedQtyLabel.font = GXF_SIXTEENTEH_SIZE;
    

    
    
    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
    self.showView.clipsToBounds = YES;
    
    self.showNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.seqLabel.frame), 0, ShowWidth*2, ShowHeight))];
    self.showNameLabel.textAlignment = NSTextAlignmentLeft;
    self.showNameLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNameLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showStandLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.seqLabel.frame), CGRectGetMaxY(self.showNameLabel.frame), ShowWidth, ShowHeight))];
    self.showStandLabel.textAlignment = NSTextAlignmentLeft;
    self.showStandLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showStandLabel.text = @"包装规格：1*12斤";
    self.showStandLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showStandLabel.frame), CGRectGetMaxY(self.showNameLabel.frame), ShowWidth, ShowHeight))];
    self.showCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCountLabel.text = @"包装数量：10000";
    self.showCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showBaseCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showBaseCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showBaseCountLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showBaseCountLabel.text = @"基础数量：300";
    self.showBaseCountLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showBasePrice = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showStandLabel.frame), ShowWidth, ShowHeight))];
    self.showBasePrice.textAlignment = NSTextAlignmentLeft;
    self.showBasePrice.textColor = GXF_PLACEHOLDER_COLOR;
    self.showBasePrice.text = @"基础单价：300";
    self.showBasePrice.font = GXF_THREETEENTH_SIZE;
    
    self.showPriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showBaseCountLabel.frame), CGRectGetMaxY(self.showBasePrice.frame), ShowWidth, ShowHeight))];
    self.showPriceLabel.textAlignment = NSTextAlignmentLeft;
    self.showPriceLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showPriceLabel.text = @"包装单价：11元";
    self.showPriceLabel.font = GXF_THREETEENTH_SIZE;
    
    
    
    self.showTotalLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showStandLabel.frame), CGRectGetMaxY(self.showBaseCountLabel.frame), ShowWidth, ShowHeight))];
    self.showTotalLabel.textAlignment = NSTextAlignmentLeft;
    self.showTotalLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showTotalLabel.text = @"总金额：100";
    self.showTotalLabel.font = GXF_THREETEENTH_SIZE;
    
    
    self.showPurchaseLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showPriceLabel.frame), ShowWidth+ 100, ShowHeight))];
    self.showPurchaseLabel.textAlignment = NSTextAlignmentLeft;
    self.showPurchaseLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showPurchaseLabel.text = @"采购单号：1000";
    self.showPurchaseLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showNoteLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showTotalLabel.frame), ShowWidth, ShowHeight))];
    self.showNoteLabel.textAlignment = NSTextAlignmentLeft;
    self.showNoteLabel.textColor = GXF_PLACEHOLDER_COLOR;
    self.showNoteLabel.text = @"备注：1000";
    self.showNoteLabel.font = GXF_THREETEENTH_SIZE;
    
    self.showCheckPrice = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showStandLabel.frame), CGRectGetMaxY(self.showNoteLabel.frame), ShowWidth, ShowHeight))];
    self.showCheckPrice.textAlignment = NSTextAlignmentLeft;
    self.showCheckPrice.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCheckPrice.text = @"考核单价：200";
    self.showCheckPrice.font = GXF_THREETEENTH_SIZE;
    
    self.showCheckTotal = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showCountLabel.frame), CGRectGetMaxY(self.showNoteLabel.frame), ShowWidth, ShowHeight))];
    self.showCheckTotal.textAlignment = NSTextAlignmentLeft;
    self.showCheckTotal.textColor = GXF_PLACEHOLDER_COLOR;
    self.showCheckTotal.text = @"考核总金额：200";
    self.showCheckTotal.font = GXF_THREETEENTH_SIZE;
    
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:self.rightImageName] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.waitRecieveQtyLabel];
    [self.contentView addSubview:self.recievedQtyLabel];
    [self.contentView addSubview:self.qpcLabel];
    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.showView];
    
    [self.showView addSubview:self.showNameLabel];
    [self.showView addSubview:self.showStandLabel];
    [self.showView addSubview:self.showCountLabel];
    [self.showView addSubview:self.showBaseCountLabel];
    [self.showView addSubview:self.showPriceLabel];
    [self.showView addSubview:self.showPurchaseLabel];
    [self.showView addSubview:self.showTotalLabel];
    [self.showView addSubview:self.showShippedBaseQty];
    [self.showView addSubview:self.showShippedQty];
    [self.showView addSubview:self.showBasePrice];
    [self.showView addSubview:self.showTotalLabel];
    [self.showView addSubview:self.showNoteLabel];
    [self.showView addSubview:self.showCheckPrice];
    [self.showView addSubview:self.showCheckTotal];
    
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setPdtDetail:(TransportPdtDetail *)pdtDetail row:(NSInteger)row{
    self.seqLabel.text = [NSString stringWithFormat:@"%@",@(row+1)];
    self.titleLabel.text = pdtDetail.productName;
    self.waitRecieveQtyLabel.text =  [NSString stringWithFormat:@"%@",pdtDetail.qty];
    self.recievedQtyLabel.text = @"0";
    self.showNameLabel.text = [NSString stringWithFormat:@"商品：%@[%@]",pdtDetail.productName,pdtDetail.productCode];
    self.qpcLabel.text = [pdtDetail.qpcStr stringByAppendingString:pdtDetail.baseUnit];
    self.showStandLabel.text = [NSString stringWithFormat:@"包装规格：1*%@%@",[pdtDetail.qpc stringValue],pdtDetail.baseUnit];
    self.showCountLabel.text = [NSString stringWithFormat:@"包装数量：%@%@",[pdtDetail.qty stringValue],pdtDetail.unit];
    self.showBaseCountLabel.text =[NSString stringWithFormat:@"基础数量：%@%@",pdtDetail.baseQty,
                                   pdtDetail.baseUnit];
    self.showBasePrice.text = [NSString stringWithFormat:@"基础单价：%@元", pdtDetail.price];
    self.showPriceLabel.text = [NSString stringWithFormat:@"包装单价：%.2f元",[pdtDetail.packprice floatValue]];
    self.showPurchaseLabel.text = [NSString stringWithFormat:@"采购单号：%@",pdtDetail.purchasebillnumber.length > 0 ? pdtDetail.purchasebillnumber: @"无"];
    self.showTotalLabel.text = [NSString stringWithFormat:@"总金额：%.2f元",[pdtDetail.total floatValue]];
    self.showShippedBaseQty.text = [NSString stringWithFormat:@"转运包装数量：%@%@",pdtDetail.transferQty ? [pdtDetail.transferQty stringValue]:@"0",pdtDetail.unit];
    self.showShippedQty.text = [NSString stringWithFormat:@"转运运基础数量：%@%@",pdtDetail.transferBaseQty ? [pdtDetail.transferBaseQty stringValue]:@"0",pdtDetail.baseUnit];
    self.showNoteLabel.text =[NSString stringWithFormat:@"备注：%@",pdtDetail.note ? pdtDetail.note :@"无"];
    
    self.showCheckPrice.text = [NSString stringWithFormat:@"考核单价：%.2f元", pdtDetail.checkPrice.doubleValue];
    
    self.showCheckTotal.text = [NSString stringWithFormat:@"考核总金额：%.2f元", pdtDetail.checkTotal.doubleValue];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
