//
//  TransportProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportProductViewController.h"
#import "FooterCell.h"
#import "HeaderCell.h"
#import "TransportCreateProductCell.h"
#import "TransportPdtDetail.h"

#import "GXFPopView.h"

#define TableHeight 44
#define ShowHeight  150
#define HeaderHeight 40
@interface TransportProductViewController ()
<UITableViewDataSource,UITableViewDelegate,FooterCellDelegate,HeaderCellDelegate,GXFPopViewDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
@property (nonatomic,strong)GXFPopView *popView;
//采购单号
@property (strong, nonatomic) NSMutableArray *arrBillNumber;
//按照采购单号区分之后的数据
@property (strong, nonatomic) NSMutableDictionary *dictData;
@end

@implementation TransportProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [self initData];
    [self createView];
}
- (void)initData{
    _selectRowArr = [[NSMutableArray alloc]init];
    if (!self.transportProductArr) {
        self.transportProductArr = [NSMutableArray array];
    }
}

- (void)setTransportProductArr:(NSMutableArray *)transportProductArr {
    _transportProductArr = transportProductArr;
    
    [self convertData];
}

- (void)convertData {
    self.arrBillNumber = [NSMutableArray array];
    self.dictData = [NSMutableDictionary dictionary];
    for (TransportPdtDetail *pdt in self.transportProductArr) {
        if (![self.arrBillNumber containsObject:pdt.purchasebillnumber]) {
            [self.arrBillNumber addObject:pdt.purchasebillnumber];
        }
        
        NSMutableArray *arrTemp = [self.dictData objectForKey:pdt.purchasebillnumber];
        if (!arrTemp) {
            arrTemp = [NSMutableArray array];
            [self.dictData setObject:arrTemp forKey:pdt.purchasebillnumber];
        }
        
        [arrTemp addObject:pdt];
    }
}

- (void)setViewFrame:(CGRect)viewFrame{
    _viewFrame = viewFrame;
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"商品",@"规格",@"待收包装数",@"已收包装数"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr withHiddenEdit:self.isHiddenEdit];
    [self.view addSubview:headCell];
    headCell.delegate = self;
    self.tableView.tableHeaderView = headCell;
    
//    if (!self.isHiddenEdit) {
//        FooterCell *footCell = [[FooterCell alloc]initWithFrame:CGRectMake(0, 0, _tableFrame.size.width, 50) withTitle:@"+点击添加商品明细" isTwo:self.twoTitle];
//        [self.view addSubview:footCell];
//        footCell.delegate = self;
//        self.tableView.tableFooterView = footCell;
//    }
}

#pragma mark - headCellDelegate
- (void)addClickList{
    if (!self.popView) {
//        NSArray *arr = @[@"添加商品明细",@"选择采购单"];
        NSArray *arr = @[@"选择采购单"];

        self.popView = [[GXFPopView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height) withArr:arr];
        self.popView.delegate = self;
        [AppWindow addSubview:self.popView];
    }
}
#pragma mark - popViewdelegate
- (void)selectRowTitle:(NSString *)str{
    if (self.popView) {
        [self.popView removeFromSuperview];
        self.popView= nil;
    }
    if ([str isEqualToString:@"添加商品明细"]) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil];
    }else if([str isEqualToString:@"选择采购单"]){
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_ChoseTransportPurchase object:nil];
    }
}
- (void)clearFromSuper{
    if (self.popView) {
        [self.popView removeFromSuperview];
        self.popView = nil;
    }
}

#pragma mark - footerDelegate
- (void)addClick{
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil];
}
- (void)editClick:(UIButton *)btn{
    NSInteger section = btn.tag / 1000;
    NSInteger row = btn.tag % 1000;
    NSMutableArray *arrSection = [self.dictData objectForKey:self.arrBillNumber[section]];
    
    TransportPdtDetail *pdDetail = arrSection[row];
    NSInteger index = [self.transportProductArr indexOfObject:pdDetail];
   [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil userInfo:@{@"transportPdtDetail":pdDetail,@"indexPath":@(index)}];
}

- (void)refresh {
    [self convertData];
    [self.tableView reloadData];
}

- (void)choosePurchase{
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_ChoseTransportPurchase object:nil];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return self.arrBillNumber.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return HeaderHeight;
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section {
    UIView *header = [[UIView alloc] initWithFrame:CGRectMake(0, 0, ScreenSize.width, HeaderHeight)];
    header.backgroundColor = [UIColor whiteColor];
    UILabel *transportBillNumber = [[UILabel alloc] initWithFrame:CGRectMake(16, 0, 250, HeaderHeight)];
    [header addSubview:transportBillNumber];
    transportBillNumber.text = [NSString stringWithFormat:@"[采购单：%@]",
                                self.arrBillNumber[section]];
    transportBillNumber.textColor = GXF_GREEN_COLOR;
    UIView *line = [[UIView alloc] initWithFrame:CGRectMake(0, HeaderHeight - 1, IBT_MAIN_SCREEN_WIDTH, 1)];
    line.backgroundColor = [UIColor colorWithWhite:0.835 alpha:1.000];
    [header addSubview:line];
    //删除按钮
    UIButton *btnDelete = [UIButton buttonWithType:UIButtonTypeCustom];
    btnDelete.frame = CGRectMake(IBT_MAIN_SCREEN_WIDTH - 16 - 30, (HeaderHeight - 30)/2, 30, 30);
    [btnDelete setImage:[UIImage imageNamed:@"xf_delete_pic"] forState:UIControlStateNormal];
    [header addSubview:btnDelete];
    btnDelete.tag = section;
    [btnDelete addTarget:self action:@selector(actionDeleteBillNumber:) forControlEvents:UIControlEventTouchUpInside];
    
    return header;
}

- (void)actionDeleteBillNumber:(UIButton *)btn {
    NSString *billNumber = self.arrBillNumber[btn.tag];
    UIAlertController *alert = [UIAlertController alertControllerWithTitle:@"温馨提示" message:[NSString stringWithFormat:@"确认删除该采购单%@下的商品？", billNumber] preferredStyle:(UIAlertControllerStyleAlert)];
    
    UIAlertAction *actionYes = [UIAlertAction actionWithTitle:@"确定" style:(UIAlertActionStyleDestructive) handler:^(UIAlertAction * _Nonnull action) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_DeleteTransportPdtInPurchase object:billNumber];
    }];
    
    UIAlertAction *actionCancel = [UIAlertAction actionWithTitle:@"取消" style:(UIAlertActionStyleDefault) handler:nil];
    
    [alert addAction:actionYes];
    [alert addAction:actionCancel];
    
    [self presentViewController:alert animated:YES completion:nil];
    
    
    
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    NSMutableArray *arrSection = [self.dictData objectForKey:self.arrBillNumber[section]];
    return arrSection.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"TransportPurductCell";
    TransportCreateProductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[TransportCreateProductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID withImageName:@"edit"];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = ShowHeight + TableHeight -1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = ShowHeight;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = [UIColor whiteColor];
    }
    cell.editBtn.tag = indexPath.section * 1000 + indexPath.row;
    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
    NSMutableArray *arrSection = [self.dictData objectForKey:self.arrBillNumber[indexPath.section]];
    if (arrSection.count > 0) {
        TransportPdtDetail *billP = arrSection[indexPath.row];
        [cell setPdtDetail:billP row:indexPath.row];
    }
    return cell;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row && path.section == indexPath.section) {
            return YES;
        }
    }
    return NO;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    TransportCreateProductCell *cell = (TransportCreateProductCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        
        Linefrmame.origin.y = ShowHeight + TableHeight - 1;
        showfrmame.size.height = ShowHeight;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return ShowHeight + TableHeight;
    }
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
