//
//  BoltMaskView.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BoltMaskView.h"
#import "MaskCell.h"
#define TableHeight 45
#define LeftMargin 80
#define TotalHeight 224
#define LeftHeight 44
#define BottomHeight 50

@interface BoltMaskView ()<UITextFieldDelegate>
{
    UIView *_leftView;
    UIButton *_currentBtn;
    NSIndexPath *_currentIndexPath;
    UIView *_titleView;
    UIView *_billNumberView;
    NSString *_state;
    NSString *_billNumber;
    NSString *_title;
    UIButton *_clearBtn;
}
@property (nonatomic,strong)NSString *state;
@property (nonatomic,strong)NSString *title;
@property (nonatomic,strong)NSString *billNumber;


@end

@implementation BoltMaskView
- (instancetype)initWithFrame:(CGRect)frame state:(NSString *)state title:(NSString *)title bill:(NSString *)bill{
    self = [super initWithFrame:frame];
    if (self) {
        self.title = title;
        self.billNumber = bill;
        self.state = state;
        [self createView];
        [self createRightView];
        [self preferData];
    }
    return self;
}
- (void)preferData{
    //initial(未提交)，submitted(已提交)，insurvey(调研中)
    if ([self.state isEqualToString:@"none"]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:0 inSection:0];
    }else if ([self.state isEqualToString:SURVEY_STATE_INITIAL]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:1 inSection:0];
    }else if ([self.state isEqualToString:SURVEY_STATE_SUBMITTED]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:2 inSection:0];
    }else if ([self.state isEqualToString:SURVEY_STATE_INSURVEY]) {
        _currentIndexPath = [NSIndexPath indexPathForRow:3 inSection:0];
    }
    _titleView.hidden = YES;
    if(self.title.length > 0){
        self.titleFiled.text = self.title;
    }
    _billNumberView.hidden = YES;
    if (self.billNumber.length > 0) {
        self.billFiled.text = self.billNumber;
    }
}

#pragma mark - 创建视图
- (void)createView
{
    _leftView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, LeftMargin,self.frame.size.height- BottomHeight)];
    [self addSubview:_leftView];
    NSArray *arr = @[@"按状态",@"单号",@"标题"];
    for (NSInteger i = 0; i<arr.count; i++) {
        UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
        button.frame = CGRectMake(0, LeftHeight * i ,  LeftMargin ,LeftHeight);
        [button setTitle:arr[i] forState:UIControlStateNormal];
        [button setTitleColor:GXF_DETAIL_COLOR forState:UIControlStateNormal];
        if (i == 0) {
            button.enabled = NO;
            _currentBtn = button;
        }
        [button setBackgroundImage:[UIImage imageNamed:@"maskEnable"] forState:UIControlStateDisabled];
        [button setBackgroundImage:[UIImage imageNamed:@"mask"] forState:UIControlStateNormal];
        button.tag = 1001+i;
        [button addTarget:self action:@selector(leftBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_leftView addSubview:button];
    }
    _clearBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    _clearBtn.frame = CGRectMake(0, CGRectGetMaxY(_leftView.frame), self.frame.size.width, BottomHeight);
    [_clearBtn setTitle:@"清空选项" forState:UIControlStateNormal];
    [_clearBtn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    _clearBtn.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [_clearBtn addTarget:self action:@selector(clearBolt) forControlEvents:UIControlEventTouchUpInside];
    [self addSubview:_clearBtn];
}
- (void)createRightView{
    
    _titleView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight)];
    _titleView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_titleView];
    UILabel *titleLabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20)];
    titleLabel.font = GXF_FIFTEENTEN_SIZE;
    titleLabel.text = @"类似于：";
    [_titleView addSubview:titleLabel];
    self.titleFiled = [[UITextField alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(titleLabel.frame) + 10, (ScreenSize.width - LeftMargin - 10*2), 30)];
    self.titleFiled.textAlignment = NSTextAlignmentLeft;
    self.titleFiled.textColor = GXF_CONTENT_COLOR;
    self.titleFiled.placeholder = @"输入类似标题";
    self.titleFiled.borderStyle = UITextBorderStyleRoundedRect;
    self.titleFiled.font = GXF_FIFTEENTEN_SIZE;
    self.titleFiled.returnKeyType = UIReturnKeyDone;
    self.titleFiled.delegate = self;
    [_titleView addSubview:self.titleFiled];
    
    
    _billNumberView = [[UIView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight)];
    _billNumberView.backgroundColor = [UIColor whiteColor];
    [self addSubview:_billNumberView];
    UILabel *billLabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 20, (ScreenSize.width - LeftMargin - 10*2), 20)];
    billLabel.font = GXF_FIFTEENTEN_SIZE;
    billLabel.text = @"类似于：";
    [_billNumberView addSubview:billLabel];
    
    self.billFiled = [[UITextField alloc]initWithFrame:CGRectMake(10, CGRectGetMaxY(billLabel.frame) + 10, (ScreenSize.width - LeftMargin - 10*2), 30)];
    self.billFiled.textAlignment = NSTextAlignmentLeft;
    self.billFiled.textColor = GXF_CONTENT_COLOR;
    self.billFiled.placeholder = @"输入类似单号";
    self.billFiled.borderStyle = UITextBorderStyleRoundedRect;
    self.billFiled.font = GXF_FIFTEENTEN_SIZE;
    self.billFiled.returnKeyType = UIReturnKeyDone;
    self.billFiled.delegate = self;
    [_billNumberView addSubview:self.billFiled];
    
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin, self.frame.size.height - BottomHeight) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self addSubview:self.tableView];
   
}


- (void)leftBtnClick:(UIButton *)btn{
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [self keyBoardHidden];
    switch (btn.tag) {
        case 1001://状态
        {
            self.tableView.hidden = NO;
            _titleView.hidden = YES;
            _billNumberView.hidden = YES;
        }
            break;
        case 1002://条件二
        {
            self.tableView.hidden = YES;
            _titleView.hidden = YES;
            _billNumberView.hidden = NO;
        }
            break;
        case 1003://条件三
        {
            self.tableView.hidden = YES;
            _titleView.hidden = NO;
            _billNumberView.hidden = YES;
        }
            break;
        default:
            break;
    }
}

- (void)clearBolt{
    if (_titleFiled.text.length > 0) {
        _titleFiled.text = @"";
    }
    if (_billFiled.text.length > 0) {
        _billFiled.text = @"";
    }
    if (_currentIndexPath) {
        _currentIndexPath = nil;
        [self.tableView reloadData];
    }
    if ([self.delegate respondsToSelector:@selector(clearBoltInformation)]) {
        [self.delegate clearBoltInformation];
    }
}

#pragma mark - 协议
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskID";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth: ScreenSize.width - 80 totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        cell.Commitbtn.hidden = YES;
        [cell setTitleStr:self.dataArr[indexPath.row]];
        
    }
    if (_currentIndexPath) {
        if (indexPath.row == _currentIndexPath.row) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    //获取选中的cell
    MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
    currentCell.Commitbtn.hidden = YES;
    MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
    cell.Commitbtn.hidden = NO;
    _currentIndexPath = indexPath;
    
    //initial(未提交)，submitted(已提交)，insurvey(调研中)

    NSString *stateStr = @"";
    if (indexPath.row == 0) {
        stateStr = @"none";
    }else if(indexPath.row == 1){
        stateStr = @"initial";
    }else if(indexPath.row == 2){
        stateStr = @"submitted";
    }else if(indexPath.row == 3){
        stateStr = @"insurvey";
    }
    [self.delegate getBoltValueSelectRow:stateStr];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField{
    [self keyBoardHidden];
    return YES;
}
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event{
    [self keyBoardHidden];
}
- (void)keyBoardHidden{
    [self.titleFiled resignFirstResponder];
    [self.billFiled resignFirstResponder];
}

- (void)textFieldDidEndEditing:(UITextField *)textField{
    if (textField == self.titleFiled) {
//        if (self.titleFiled.text.length > 0) {
            [self.delegate getTitleLike:self.titleFiled.text];
//        }
    }else if(textField == self.billFiled){
//        if (self.billFiled.text.length > 0) {
            [self.delegate getBillNumber:self.billFiled.text];
//        }
    }
}


@end
