//
//  ICRPatrolAllStoreViewController.m
//  XFFruit
//
//  Created by Xummer on 15/6/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRPatrolAllStoreViewController.h"

#import "IBTTableViewCell.h"

#import "ICRPatrolPlan.h"

static NSString *tableViewCell = @"IBTTableViewCell";

typedef NS_ENUM(NSUInteger, ICRPatrolStoreStatus) {
    kICRPatrolStoreStatusFinished = 0,
    kICRPatrolStoreStatusUnFinished,
    kICRPatrolStoreSectionCount
};


@interface ICRPatrolAllStoreViewController ()
<
UITableViewDelegate,
UITableViewDataSource
>

@property (strong, nonatomic) ICRPatrolPlan *m_plan;
@property (strong, nonatomic) IBTTableView *m_tableView;

@property (strong, nonatomic) NSMutableArray *m_arrUnfinishedStores;
@property (strong, nonatomic) NSMutableArray *m_arrFinishedStores;

@end

@implementation ICRPatrolAllStoreViewController

#pragma mark - Life Cycle

- (instancetype)initWithPatrolPlan:(id)plan {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    if ([plan isKindOfClass:[ICRPatrolPlan class]]) {
        self.m_plan = plan;
    }
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"巡店详情";
    
    [self initData];
    
    [self setupSubviews];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Private Method

- (void)setupSubviews {
    
    self.m_tableView = [[IBTTableView alloc] initWithFrame:self.view.bounds style:UITableViewStylePlain];
    _m_tableView.autoresizingMask = UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleHeight;
    [_m_tableView registerClass:[IBTTableViewCell class] forCellReuseIdentifier:tableViewCell];
    _m_tableView.dataSource = self;
    _m_tableView.delegate = self;
    
    _m_tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
    [self.view addSubview:_m_tableView];
    
}

- (void)initData {
    
    if (!_m_arrFinishedStores || !_m_arrUnfinishedStores) {
        _m_arrFinishedStores = [NSMutableArray array];
        _m_arrUnfinishedStores = [NSMutableArray array];
    }
    
//    if (_m_plan && _m_plan.stores.count > 0) {
//        
//        for (NSDictionary *dicStore in _m_plan.stores) {
//            
//            if ([dicStore[ @"status" ] integerValue] == 0) {
//                [_m_arrUnfinishedStores addObject:dicStore];
//            } else if ([dicStore[ @"status" ] integerValue] == 1) {
//                [_m_arrFinishedStores addObject:dicStore];
//            }
//        }
//    }
}

#pragma mark - UITableView DataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    switch (section) {
        case kICRPatrolStoreStatusFinished:
        {
            return _m_arrFinishedStores.count;
        }
            break;
        case kICRPatrolStoreStatusUnFinished:
        {
            return _m_arrUnfinishedStores.count;
        }
            break;
        default:
            return 0;
            break;
    }
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    UITableViewCell *cell =
    [tableView dequeueReusableCellWithIdentifier:tableViewCell forIndexPath:indexPath];
    
    [self configureCell:cell forRowAtIndexPath:indexPath];
    
    return cell;
}

- (void)configureCell:(UITableViewCell *)cell
    forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    cell.userInteractionEnabled = NO;
    
    cell.textLabel.textAlignment = NSTextAlignmentCenter;
    
    switch (indexPath.section) {
        case kICRPatrolStoreStatusFinished:
        {
            cell.textLabel.text = [_m_arrFinishedStores objectAtIndex:indexPath.row][ @"storeName" ];
        }
            break;
        case kICRPatrolStoreStatusUnFinished:
        {
            cell.textLabel.text = [_m_arrUnfinishedStores objectAtIndex:indexPath.row][ @"storeName" ];
        }
            break;
        default:
            break;
    }
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return kICRPatrolStoreSectionCount;
}

- (NSString *)tableView:(UITableView *)tableView titleForHeaderInSection:(NSInteger)section {
    
    switch (section) {
        case kICRPatrolStoreStatusFinished:
        {
            return @"已巡店";
        }
            break;
        case kICRPatrolStoreStatusUnFinished:
        {
            return @"未巡店";
        }
            break;
        default:
            return nil;
            break;
    }
}
@end
