//
//  PurchaseNoticeListCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseNoticeListCell.h"
#import "SurveyUser.h"
#define TitleSize 16
#define LeftMargin 90
#define TopMargin 10
#define TitleHeight 20
#define TableHeight 120

@implementation PurchaseNoticeListCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.stateBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.stateBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftMargin - TopMargin*3, 20);
    self.stateBtn.titleLabel.font = GXF_FOURTEENTH_SIZE;
    [self.stateBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stateBtn.enabled = NO;
    
    self.billNumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, TopMargin, ScreenSize.width - LeftMargin, TitleHeight))];
    self.billNumberLabel.textColor = GXF_CONTENT_COLOR;
    self.billNumberLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.billNumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.titleLabel.numberOfLines = 0;
    self.titleLabel.textColor = GXF_CELL_COLOR;
    self.titleLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.userLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.titleLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.userLabel.textColor = GXF_CELL_COLOR;
    self.userLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.createOperNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.userLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createOperNameLabel.textColor = GXF_CELL_COLOR;
    self.createOperNameLabel.font = GXF_FOURTEENTH_SIZE;
    
    
    self.createTimeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.createOperNameLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.createTimeLabel.textColor = GXF_CELL_COLOR;
    self.createTimeLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width - LeftMargin - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.stateBtn];
    [self.contentView addSubview:self.billNumberLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.userLabel];
    [self.contentView addSubview:self.createOperNameLabel];
    [self.contentView addSubview:self.createTimeLabel];
    [self.contentView addSubview:self.lineLabel];
}
- (void)setPurchaseNotice:(PurchaseNotice *)purchaseNotice{
    self.billNumberLabel.text = [NSString stringWithFormat:@"单号：%@",purchaseNotice.billnumber];
    self.titleLabel.text = [NSString stringWithFormat:@"标题：%@",purchaseNotice.title];
    NSString *textStr = @"";
    for (SurveyUser *user in purchaseNotice.purchasers) {
        if (textStr.length == 0) {
            textStr = [textStr stringByAppendingFormat:@"%@",user.userName];
        }else {
            textStr = [textStr stringByAppendingFormat:@"、%@",user.userName];
        }
    }
    self.userLabel.text = [NSString stringWithFormat:@"采购员：%@",textStr] ;
    self.createOperNameLabel.text = [NSString stringWithFormat:@"创建人：%@",purchaseNotice.create_operName] ;
    self.createTimeLabel.text =[NSString stringWithFormat:@"创建时间：%@",purchaseNotice.create_time];
    NSString *stateStr = @"";
    if ([purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_INITIAL]) {
        stateStr = @"未提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"initial"]  forState:UIControlStateDisabled];
    }else if ([purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_NOTACCEPTED]) {
        stateStr = @"未接受";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
    }else if ([purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_PURCHASEING]) {
        stateStr = @"采购中";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
    }else if ([purchaseNotice.state isEqualToString:PURCHASE_STATE_FINISHED]) {
        stateStr = @"已完成";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
        
    }
    [self.stateBtn setTitle:stateStr forState:UIControlStateNormal];
}




@end
