//
//  GXFPopNewMaterialView.m
//  XFFruit
//
//  Created by freecui on 15/9/3.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//



#import "GXFPopNewProductViewController.h"
#import "GXFBottomView.h"
#import "GXFTableViewCell.h"
#import "StartTimeView.h"
#import "GXFProcessProduct.h"
#import "GXFSearchVendorViewController.h"
#import "Product.h"
#import "GXFProductUnit.h"
@interface GXFPopNewProductViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate,StartTimeViewDelegate,GXFBottomViewDelegate>
{
    StartTimeView *_startTimeView;
}
@property (nonatomic, strong) UIView *c_bgView;
@property (nonatomic, strong) UITableView *c_tableView;
@property (nonatomic, strong) NSArray *d_leftArr;//uitableView左边显示的提示
@property (nonatomic, strong) NSArray *d_rightArr;//右边placeholder提示
@property (nonatomic, strong) NSArray *d_lableTextArr;
@property (nonatomic, strong) GXFProcessProduct *d_processProduct;
@property (nonatomic, strong) NSIndexPath *d_dateIndexPath;
@property (nonatomic, assign) BOOL d_hasSaved;
@property (nonatomic, strong) GXFBottomView *c_bottomV;
@property (nonatomic, assign) BOOL d_isEdited;
@end
@implementation GXFPopNewProductViewController


- (instancetype)initWithProcessProduct:(GXFProcessProduct *)processProduct isEdit: (BOOL) isEdited{
    self = [super init];
    if (!self) {
        return nil;
    }
    self.d_processProduct = processProduct;
    self.d_isEdited = isEdited;
    return self;
}
- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"新增成品明细";
    [self initData];
    [self initSubViews];
}




- (void)initData {
    self.d_leftArr = @[@"商品：",@"出库时间：",@"包装单位：",@"包装规格：",@"包装数量",@"基础数量：",@"备注：",];
    self.d_rightArr = @[@"选择商品",@"选择出库时间",@"选择包装单位",@"包装规格",@"包装数量",@"基础数量",@"输入备注内容"];
    self.d_lableTextArr = @[@"斤",@"筐",@"斤"];
    if (!_d_processProduct) {
         self.d_processProduct = [[GXFProcessProduct alloc]init];
    }
   
}
- (void)initSubViews {

    self.c_tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, 0, self.view.width , GXF_TABLEVIEW_NOMALCELL_HEIGHT * _d_leftArr.count) style:UITableViewStylePlain];
    
    self.c_tableView.delegate = self;
    self.c_tableView.dataSource = self;
    
    [self.view addSubview:_c_tableView];
    
    
    GXFBottomView *bottomV = [[GXFBottomView alloc]initWithFrame:CGRectMake(0, _c_tableView.bottom, self.view.width, BottomViewHeight) leftButtonColor:GXF_ORIGIN_COLOR rightButtonColor:GXF_GREEN_COLOR LeftBtnTitle:@"删除" rightBtnTitle:@"保存"];;
    bottomV.delegate = self;
    self.c_bottomV = bottomV;
    [self.view addSubview:bottomV];
    
    
    
    
}

- (void)viewDidAppear:(BOOL)animated {
    // [self registerForKeyboardNotifications];
}
- (void)viewWillDisappear:(BOOL)animated {
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
#pragma UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _d_leftArr.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    GXFTableViewCell *xfCell ;
    xfCell.width = _c_tableView.width;
    if ( indexPath.row == 0 || indexPath.row == 1 ||indexPath.row == 2) {
        xfCell = [tableView dequeueReusableCellWithIdentifier:arrowCell];
        if (!xfCell) {
            xfCell = [[GXFTableViewCell alloc]initWithWidth:_c_tableView.width Style:UITableViewCellStyleDefault reuseIdentifier:arrowCell textFieldPlaceholder:_d_rightArr[indexPath.row] isEdit:NO];
            xfCell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
            
        }
    } else if (  indexPath.row == 6) {
        xfCell = [tableView dequeueReusableCellWithIdentifier:noLblCell];//-
        if (!xfCell) {
            xfCell = [[GXFTableViewCell alloc]initWithWidth:_c_tableView.width Style:UITableViewCellStyleDefault reuseIdentifier:arrowCell textFieldPlaceholder:_d_rightArr[indexPath.row] isEdit:YES];
        }
        
    }else if (indexPath.row == 3 || indexPath.row == 4 || indexPath.row == 5) {
        xfCell = [tableView dequeueReusableCellWithIdentifier:lblCell];  //
        if (!xfCell) {
            xfCell = [[GXFTableViewCell alloc]initWithWidth:_c_tableView.width Style:UITableViewCellStyleDefault reuseIdentifier:lblCell textFieldPlaceholder:_d_rightArr[indexPath.row] hasLable:YES backLableText:_d_lableTextArr[indexPath.row - 3]];
             xfCell.f_textField.keyboardType = UIKeyboardTypeNumbersAndPunctuation;
        }
        
    }
    if (xfCell.f_textField) {
        xfCell.f_textField.delegate = self;
    }
    
    xfCell.selectionStyle = UITableViewCellAccessoryNone;
    xfCell.f_textField.tag = indexPath.row;
    xfCell.textLabel.text = _d_leftArr[indexPath.row];
    if (_d_isEdited) {
        switch (indexPath.row) {
            case 0:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.productName];//_d_processProduct.productName;
                break;
            case 1:
                
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.outstockDate];//[NSString stringWithFormat:@"%@",_d_processProduct.outstockDate];
                break;
            case 2:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.unit];//_d_processProduct.unit;
                break;
            case 3:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.qpc];//[NSString stringWithFormat:@"%@",_d_processProduct.qpc];
                break;
            case 4:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.quantity];//[NSString stringWithFormat:@"%@",_d_processProduct.quantity];
                break;
            case 5:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.baseQty];//[NSString stringWithFormat:@"%@",_d_processProduct.baseQty];
                break;
            case 6:
                xfCell.f_textField.text = [IBTCommon checkNull:_d_processProduct.remark];//_d_processProduct.remark;
                break;
            default:
                break;
        }
        
    }
    return xfCell;
    
}
#pragma UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
     GXFTableViewCell *xfCell = (GXFTableViewCell *)[_c_tableView cellForRowAtIndexPath:indexPath];
    if (indexPath.row == 0) {
        GXFSearchVendorViewController *vc = [[GXFSearchVendorViewController alloc]initWithTitle:[IBTCommon localizableString:@"ProductTitle"]];
        vc.choseVendor = ^(NSArray *vendors){
            if (vendors.count > 0) {
                Product *product = vendors[0];
                xfCell.f_textField.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
                _d_processProduct.productUuid = product.uuid;
                _d_processProduct.productCode = product.code;
                _d_processProduct.productName = product.name;
                _d_processProduct.qpcStr = @"1 X123.0";//product.qpcStr;
            }
        };
        [self PushViewController:vc animated:YES];

    }
    
    if (indexPath.row == 1) {
        [self startDatePickView];
        self.d_dateIndexPath = indexPath;
        
    }
    
    if (indexPath.row == 2) {
        GXFSearchVendorViewController *vc = [[GXFSearchVendorViewController alloc]initWithTitle:[IBTCommon localizableString:@"ProductUnitTitle"]];
        vc.choseVendor = ^(NSArray *vendors){
            if (vendors.count > 0) {
                GXFProductUnit *productUnit = vendors[0];
                xfCell.f_textField.text = [NSString stringWithFormat:@"%@[%@]",productUnit.name,productUnit.uuid];
                _d_processProduct.productUuid = productUnit.uuid;
                
                _d_processProduct.productName = productUnit.name;
            }
        };
        [self PushViewController:vc animated:YES];
    }
}


#pragma StartTimeViewDelegate
- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSDate *)time{
    GXFTableViewCell *xfCell = (GXFTableViewCell *)[_c_tableView cellForRowAtIndexPath:_d_dateIndexPath];
    xfCell.f_textField.text = [IBTCommon stringFromDate:time]; ;
    self.d_processProduct.outstockDate = time;
    // 关闭选择器
    [self clearDatePickView];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  _startTimeView.frame;
        startFrame.origin.y = ScreenSize.height;
        _startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [_startTimeView removeFromSuperview];
        _startTimeView = nil;
    }];
}

- (void)startDatePickView{
    if (!_startTimeView) {
        _startTimeView = [[StartTimeView alloc] initWithFrame:CGRectMake(0, ScreenSize.height, ScreenSize.width, ScreenSize.height - 64)];
        _startTimeView.delegate = self;
        _startTimeView.backgroundColor   = RGBA(0, 0, 0 ,0.5);
        [self.view addSubview:_startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  _startTimeView.frame;
            startFrame.origin.y =  0;
            _startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    [self textFieldShouldReturn:textField];
}
- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    // [self recoverTableViewFrame];
    [textField resignFirstResponder];
    switch (textField.tag) {
        case 0:
            self.d_processProduct.productName = textField.text;
            break;
        case 1:
            // self.d_processProduct.productName = textField.text;
            break;
        case 2:
            self.d_processProduct.unit = @"筐";//textField.text;
            break;
        case 3:
            self.d_processProduct.qpc = [NSNumber numberWithFloat:[textField.text floatValue]];
            break;
        case 4:
            self.d_processProduct.quantity= [NSNumber numberWithFloat:[textField.text floatValue]];
            break;
        case 5:
            self.d_processProduct.baseQty = [NSNumber numberWithFloat:[textField.text floatValue]];;
            break;
       
        case 6:
            self.d_processProduct.remark = textField.text;
            break;
        default:
            break;
    }
    return YES;
}
#pragma GXFBottomViewDelegate
- (void)bottomViewleftButtonClicked:(UIButton *)leftBtn {
    [self.c_bottomV.f_leftBtn setBackgroundColor:GXF_GRAY_COLOR];
    if (_d_isEdited) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_deleteProduct object:_d_processProduct];
    }
}
- (void)bottomViewRightButtonClicked:(UIButton *)rightBtn {
    self.d_hasSaved = YES;
    [self.c_bottomV.f_rightBtn setBackgroundColor:GXF_GRAY_COLOR];
    self.d_processProduct.unit = @"筐";
    if (_d_isEdited) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_editProduct object:_d_processProduct];
    } else {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_saveProduct object:_d_processProduct];
    }
    
    
    
}

@end
