//
//  GXFBottomView.m
//  XFFruit
//
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFBottomView.h"

#define LEFT_PADDING (15)
#define TOP_PADDING  (8)
#define BUTTON_WIDTH  (self.width - 3.0 * LEFT_PADDING ) / 2.0
#define BUTTON_HEIGHT (44)

#define LEFT_BUTTON_COLOR HexColor(@"50bd62")
#define RIGHT_BUTTON_COLOR HexColor(@"f69100")
@interface GXFBottomView ()

@end
@implementation GXFBottomView

- (instancetype)initWithFrame:(CGRect)frame LeftBtnTitle:(NSString *)leftTitle rightBtnTitle:(NSString *)rightTitle{
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    CGRect leftRect = CGRectMake(LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *leftBtn = [IBTCustomButtom creatButtonWithFrame:leftRect target:self sel:@selector(leftBtnClicked) tag:leftTag image:nil title:leftTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:LEFT_BUTTON_COLOR];
    self.f_leftBtn = leftBtn;
    [self addSubview:_f_leftBtn];
    
    CGRect rightRect = CGRectMake(leftBtn.right +  LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *rightBtn = [IBTCustomButtom creatButtonWithFrame:rightRect target:self sel:@selector(rightBtnClicked) tag:rightTag image:nil title:rightTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:RIGHT_BUTTON_COLOR];
    self.f_rightBtn = rightBtn;
    [self addSubview:_f_rightBtn];
    
    return self;

}

- (instancetype)initWithFrame:(CGRect)frame
              leftButtonColor: (UIColor *)leftBtnColor
             rightButtonColor: (UIColor *)rightBtnColor
                 LeftBtnTitle: (NSString *)leftTitle
                rightBtnTitle: (NSString *)rightTitle {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    CGRect leftRect = CGRectMake(LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *leftBtn = [IBTCustomButtom creatButtonWithFrame:leftRect target:self sel:@selector(leftBtnClicked) tag:leftTag image:nil title:leftTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:leftBtnColor];
    self.f_leftBtn = leftBtn;
    [self addSubview:_f_leftBtn];
    
    CGRect rightRect = CGRectMake(leftBtn.right +  LEFT_PADDING, TOP_PADDING, BUTTON_WIDTH, BUTTON_HEIGHT);
    UIButton *rightBtn = [IBTCustomButtom creatButtonWithFrame:rightRect target:self sel:@selector(rightBtnClicked) tag:rightTag image:nil title:rightTitle titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:rightBtnColor];
    self.f_rightBtn = rightBtn;
    [self addSubview:_f_rightBtn];
    
    return self;

}
- (void)leftBtnClicked {
    if ([_delegate respondsToSelector:@selector(bottomViewleftButtonClicked:)]) {
        [_delegate bottomViewleftButtonClicked:_f_leftBtn];
    }
}
- (void)rightBtnClicked {
    if ([_delegate respondsToSelector:@selector(bottomViewRightButtonClicked:)]) {
        [_delegate bottomViewRightButtonClicked:_f_rightBtn];
    }

}

- (instancetype)initOneButtonWithFrame:(CGRect)frame buttonColor:(UIColor *)btnColor buttonTitle:(NSString *)title {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    CGRect rect = CGRectMake(LEFT_PADDING, TOP_PADDING, frame.size.width - 2 * LEFT_PADDING, BUTTON_HEIGHT);
    UIButton *btn = [IBTCustomButtom creatButtonWithFrame:rect target:self sel:@selector(oneBtnClicked) tag:0 image:nil title:title titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:btnColor];
    self.f_oneBtn = btn;
    [self addSubview:_f_oneBtn];
    return self;
}
- (void)oneBtnClicked {
    if ([_delegate respondsToSelector:@selector(bottomViewOneButtonClicked:)]) {
        [_delegate bottomViewOneButtonClicked:_f_oneBtn];
    }
}
@end
