//
//  Photo.h
//  PhotoDemo
//
//  Created by Harry on 12-12-6.
//  Copyright (c) 2012年 Harry. All rights reserved.
//

#import <UIKit/UIKit.h>

@class HGPhoto;

@protocol HGPhotoDelegate <NSObject>

@optional
- (void)photoTaped:(HGPhoto*)photo;
- (void)photoMoveFinished:(HGPhoto*)photo;
- (void)photoDel : (HGPhoto *)photo;

@end

typedef NS_ENUM(NSInteger, PhotoType) {
    PhotoTypePhoto  = 0, //Default
    PhotoTypeAdd = 1,
};

@interface HGPhoto : UIView

@property (assign) id<HGPhotoDelegate> delegate;

- (id)initWithOrigin:(CGPoint)origin;
- (id)initWithOrigin:(CGPoint)origin andLength: (CGFloat)length;
- (void)setPhotoType:(PhotoType)type;
- (PhotoType)getPhotoType;
- (void)setPhotoUrl:(NSString*)photoUrl;
- (void)setPhotoImg : (UIImage *)img;
- (void)moveToPosition:(CGPoint)point;
- (void)setEditModel:(BOOL)edit;
- (void)showImage;//点击扩大图片
@end
