//
//  IBTTabBarController.m
//  AceMTer
//
//  Created by Xummer on 2/27/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTTabBarController.h"
#import "IBTBadgeView.h"
#import "UITabBarItem+Universal.h"
#import "IBTCommon.h"

@interface IBTTabBarController ()
{
    NSMutableArray *m_arrBadgesViews;
    NSMutableArray *m_arrTabBarBtns;
}
@end

@implementation IBTTabBarController

#pragma mark - Life Cycle
- (id)init
{
    self = [super init];
    if (self) {
        // Custom initialization
        [self _init];
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    [self bringBadgeViewsToFront];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc
{
    m_arrBadgesViews = nil;
    m_arrTabBarBtns = nil;
}

- (void)_init {
    if ([self.tabBar respondsToSelector:@selector(setTranslucent:)]) {
        self.tabBar.translucent = NO;
    }
    
    m_arrBadgesViews = [NSMutableArray array];
    m_arrTabBarBtns = [NSMutableArray array];
}

#pragma mark - Public Method
- (void)setTabBarBadgeImage:(UIImage *)image forIndex:(NSUInteger)index {
    UIViewController *vc = [self getTabBarBaseViewController:index];
    
    if (!vc) {
        return;
    }
    
    IBTBadgeView *badgeV = m_arrBadgesViews[ index ];
    
    vc.tabBarItem.badgeValue = nil;
    
    [badgeV setImage:image];
    badgeV.hidden = image == nil;
}

- (void)setTabBarBadgeString:(NSString *)string forIndex:(NSUInteger)index {
    UIViewController *vc = [self getTabBarBaseViewController:index];
    
    if (!vc) {
        return;
    }
    
    IBTBadgeView *badgeV = m_arrBadgesViews[ index ];
    
    vc.tabBarItem.badgeValue = string;
    badgeV.hidden = YES;
}

- (void)setTabBarBadgeValue:(NSInteger)value forIndex:(NSUInteger)index {
    if (index >= [m_arrBadgesViews count]) {
        return;
    }
    
    NSString *valueStr = [NSString stringWithFormat:@"%ld", (unsigned long)value];
    
    [self setTabBarBadgeString:valueStr forIndex:index];
}

- (void)bringBadgeViewsToFront {
    for (IBTBadgeView *badgeV in m_arrBadgesViews) {
        [self.tabBar bringSubviewToFront:badgeV];
    }
}

- (IBTBadgeView *)getBadgeViewForIndex:(NSUInteger)index {
    if (index >= [m_arrBadgesViews count]) {
        return nil;
    }
    return m_arrBadgesViews[ index ];
}

- (NSArray *)getBadgeViews {
    return m_arrBadgesViews;
}

#pragma mark - Private Method

- (UIViewController *)getTabBarBaseViewController:(NSUInteger)index {
    if (index >= [m_arrBadgesViews count]) {
        return nil;
    }
    return self.viewControllers[ index ];
}

- (UIViewController *)currentViewController {
    return self.viewControllers[ self.selectedIndex ];
}

- (void)setViewControllers:(NSArray *)controllers {
    
    [m_arrBadgesViews removeAllObjects];
    
    CGFloat perItemW = CGRectGetWidth(self.view.frame) / [controllers count];
    
    NSInteger i = 0;
    CGRect frame;
    NSString *iconImgName = nil;
    for (UIViewController *vCtrl in controllers) {
        
        // Normal图片命名 Tab+|subname|+Icon+@2x.png
        iconImgName = [NSString stringWithFormat:@"Tab%@", vCtrl.title];
        
        UITabBarItem *tabBarItem =
        [UITabBarItem itemWithTitle:[IBTCommon localizableString:vCtrl.title]
                              image:[UIImage imageNamed:iconImgName]
                      selectedImage:[UIImage imageNamed:[iconImgName stringByAppendingString:@"_HL"]]];
        [tabBarItem setTitlePositionAdjustment:UIOffsetMake(0,-5)];
        vCtrl.tabBarItem = tabBarItem;
        self.tabBar.tintColor = [UIColor colorWithRed:0.421 green:0.716 blue:0.367 alpha:1.000];
        UIImage *image  = [UIImage imageNamed:@"tabbar_item_bg"];
        // 创建一个bitmap的context
        // 并把它设置成为当前正在使用的context
        UIGraphicsBeginImageContext(CGSizeMake(ScreenSize.width / 4, 49));
            [image drawInRect:CGRectMake(0, 0, ScreenSize.width / 4 , 49)];

        
        // 从当前context中创建一个改变大小后的图片
        UIImage *newImage = UIGraphicsGetImageFromCurrentImageContext();
        // 使当前的context出堆栈
        UIGraphicsEndImageContext();
        
        self.tabBar.selectionIndicatorImage = newImage;
        
        
        // badge
        frame = (CGRect){
            .origin.x = perItemW * (i + 1) - 20 - 10,
            .origin.y = 1,
            .size.width = 20,
            .size.height = 20
        };
        
        IBTBadgeView *badgeV = [[IBTBadgeView alloc] initWithFrame:frame];
        badgeV.hidden = YES;
        
        [m_arrBadgesViews addObject:badgeV];
        [self.tabBar addSubview:badgeV];
        
        i ++;
    }
    
    [super setViewControllers:controllers];
}


@end
