//
//  ICRUtilsMacro.h
//  XFFruit
//
//  Created by Xummer on 15/3/25.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#ifndef XFFruit_ICRUtilsMacro_h
#define XFFruit_ICRUtilsMacro_h

#define IsNotNullObject(Object)          ![(Object) isKindOfClass:[NSNull class]]
#define IsNumObject(Object)              (IsNotNullObject(Object) && [(Object) isKindOfClass:[NSNumber class]])
#define IsStrObject(Object)              (IsNotNullObject(Object) && [(Object) isKindOfClass:[NSString class]] && [Object length] > 0)
#define IsIntObject(Object)              (IsNotNullObject(Object) && [Object integerValue] >= 0)
#define IsFloatObject(Object)            (IsNotNullObject(Object) && [Object floatValue] >= 0)
#define IsUintObject(Object)             (IsNotNullObject(Object) && [Object intValue] > 0)
#define IsArrayObject(Object)            [(Object) isKindOfClass:[NSArray class]]
#define IsDictObject(Object)             [(Object) isKindOfClass:[NSDictionary class]]
#define IsErrorObject(Object)            ![(Object) isKindOfClass:[NSError class]]

#define WS(weakSelf)  __weak __typeof(&*self)weakSelf = self

#endif
