//
//  ICRSyncCellContentView.m
//  XFFruit
//
//  Created by Lili Wang on 15/4/30.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRSyncCellContentView.h"

#define LABEL_HEIGHT  15
#define LEFT_MARGIN   30

@interface ICRSyncCellContentView  ()

@property (strong, nonatomic) UILabel *m_itemLabel;
@property (strong, nonatomic) UILabel *m_numberLabel;
@property (strong, nonatomic) UILabel *m_valueLabel;

@end

@implementation ICRSyncCellContentView

#pragma mark - Life Style

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        //code
        [self _init];
    }
    return self;
}

- (void)layoutSubviews {
    
    CGFloat MaxW = self.width - LEFT_MARGIN * 2;
    
    CGSize size = CGSizeMake(MaxW * 0.5, LABEL_HEIGHT);
    size = [_m_itemLabel widthLimitedSizeThatFits:size];
    
    _m_itemLabel.frame = (CGRect){
        .origin.x = self.width * 0.5 - size.width - 10,
        .origin.y = (self.height - LABEL_HEIGHT) * 0.5,
        .size = size
    };
    
    size = CGSizeMake(MaxW * 0.5, LABEL_HEIGHT);
    size = [_m_numberLabel widthLimitedSizeThatFits:size];
    
    _m_numberLabel.frame = (CGRect){
        .origin.x = self.width * 0.5,
        .origin.y = _m_itemLabel.top,
        .size = size
    };
    
    size = CGSizeMake(MaxW - _m_numberLabel.size.width , LABEL_HEIGHT);
    size = [_m_valueLabel widthLimitedSizeThatFits:size];
    
    _m_valueLabel.frame = (CGRect){
        .origin.x = _m_numberLabel.right + 2,
        .origin.y = _m_numberLabel.top,
        .size = size
    };
}

#pragma mark - Private Method

- (void)_init {
    
    self.m_itemLabel = [[UILabel alloc] init];
    _m_itemLabel.textColor = [UIColor blackColor];
    _m_itemLabel.textAlignment = NSTextAlignmentRight;
    _m_itemLabel.font = [UIFont systemFontOfSize:13];
    [self addSubview:_m_itemLabel];
    
    self.m_numberLabel = [[UILabel alloc] init];
    _m_numberLabel.textColor = [UIColor blackColor];
    _m_numberLabel.textAlignment = NSTextAlignmentLeft;
    _m_numberLabel.font = [UIFont systemFontOfSize:13];
    _m_numberLabel.text = [IBTCommon localizableString:@"Count:"];
    [self addSubview:_m_numberLabel];

    
    self.m_valueLabel = [[UILabel alloc] init];
    _m_valueLabel.textColor = [UIColor blackColor];
    _m_valueLabel.textAlignment = NSTextAlignmentRight;
    _m_valueLabel.font = [UIFont systemFontOfSize:13];
    [self addSubview:_m_valueLabel];
    
}

#pragma mark - Public Method

- (void)updateItemLabelTitle:(NSString *)strTitle valueLabelText:(NSNumber *)numValue{
    _m_itemLabel.text = strTitle;
    _m_valueLabel.text = [[numValue stringValue]
                          stringByAppendingString:
                          [IBTCommon localizableString:@"numbers"]];
    [self setNeedsLayout];
}

@end
