//
//  ICRCheckBox.m
//  XFFruit
//
//  Created by Xummer on 15/3/30.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRCheckBox.h"

@interface ICRCheckBox ()
@property (strong, nonatomic) UIButton *m_checkBoxBtn;

@property (strong, nonatomic) UIImageView *m_checkBoxBG;
@end

@implementation ICRCheckBox

#pragma mark - Life Cycle

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubviews];
    
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    _m_checkBoxBG.origin = (CGPoint){
        .x = (self.width - _m_checkBoxBG.width) * .5f,
        .y = (self.height - _m_checkBoxBG.height) * .5f
    };
    
    _m_checkBoxBtn.frame = self.bounds;
}

#pragma mark - Setter
- (void)setIsSelected:(BOOL)isSelected {
    if (_isSelected == isSelected) {
        return;
    }
    
    _isSelected = isSelected;
    _m_checkBoxBtn.selected = _isSelected;
}

- (void)setM_eBGType:(CheckBoxBGType)eBGType {
    if (_m_eBGType == eBGType) {
        return;
    }
    _m_eBGType = eBGType;
    
    NSString *nsBGIcon = nil;
    switch (_m_eBGType) {
        case kCheckBoxBGWhite:
            nsBGIcon = @"LoginCheckBox";
            break;
        case kCheckBoxBGGray:
            nsBGIcon = @"GrayCheckBox";
            break;
            
        default:
            break;
    }
    
    self.m_checkBoxBG.image = [UIImage imageNamed:nsBGIcon];
    
}

#pragma mark - Private Method
- (void)initSubviews {
    self.m_checkBoxBG = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"LoginCheckBox"]];
    [self addSubview:_m_checkBoxBG];
    self.m_eBGType = kCheckBoxBGWhite;
    
    self.m_checkBoxBtn = [IBTUIButton buttonWithType:UIButtonTypeCustom];
    [self.m_checkBoxBtn setImage:[UIImage imageNamed:@"LoginCheckMark"]
                        forState:UIControlStateSelected];
    [self.m_checkBoxBtn addTarget:self
                           action:@selector(onCheckBoxAction:)
                 forControlEvents:UIControlEventTouchUpInside];
    
    [self addSubview:_m_checkBoxBtn];
}

#pragma mark - Actions
- (void)onCheckBoxAction:(id)sender {
    self.isSelected = !_isSelected;
    if (self.blockCheckBox) {
        self.blockCheckBox(self.isSelected);
    }
}

@end
