//
//  UIViewController+LogicController.h
//  XFFruit
//
//  Created by Xummer on 15/4/3.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIViewController (LogicController)

- (UIImage *)getViewControllerImage:(CGSize)imageSize;

// Navigation
- (BOOL)isCurrentViewController;

- (void)onBackButtonClicked;

- (UIViewController *)getViewControllerAtIndex:(NSInteger)iIndex;

- (void)PushViewController:(UIViewController *)viewController animated:(BOOL)bAnimated;

- (UIViewController *)PopViewControllerAnimated:(BOOL)bAnimated;
- (NSArray *)PopToViewController:(UIViewController *)viewController animated:(BOOL)bAnimated;
- (NSArray *)PopToRootViewControllerAnimated:(BOOL)bAnimated;
- (NSArray *)PopToViewControllerWithClass:(Class)vcClass animated:(BOOL)bAnimated;
- (NSArray *)PopToViewControllerAtIndex:(NSInteger)index animated:(BOOL)bAnimated;

@end

@interface UIViewController (ModalView)
//- (void)releasePopoverController:(id)controller;
//- (void)popoverControllerDidDismissPopover:(id)popoverController;
- (void)DismissMyselfAnimated:(BOOL)bAnimated;
- (void)DismissModalViewControllerAnimated:(BOOL)bAnimated;
- (void)PresentModalViewController:(UIViewController *)viewControllerToPresent animated:(BOOL)bAnimated;
- (void)PresentViewControllerInNewNavigation:(UIViewController *)viewControllerToPresent    animated:(BOOL)bAnimated completion:(void (^)(void))completion;
@end

@interface UIViewController (margin)

- (void)setLeftBarButtonItem:(UIBarButtonItem *)item;
- (UIBarButtonItem *)leftBarButtonItem;

- (void)setRightBarButtonItem:(UIBarButtonItem *)item;
- (UIBarButtonItem *)rightBarButtonItem;

- (void)setLeftBarButtonItems:(NSArray *)items;
- (void)setRightBarButtonItems:(NSArray *)items;

- (UIBarButtonItem *)addLeftBarBtnItemWithName:(NSString *)btnName action:(SEL)selector;
- (UIBarButtonItem *)addRightBarBtnItemWithName:(NSString *)btnName action:(SEL)selector;

@end
