//
//  ICRDataBaseController.h
//  XFFruit
//
//  Created by Xummer on 4/5/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "FMDB.h"

typedef void (^ICRDatabaseUpdateBlock)(FMDatabase *db);
typedef FMResultSet *(^ICRDatabaseFetchBlock)(FMDatabase *db);
typedef void(^ICRDatabaseFetchResultsBlock)(NSArray *fetchedObjects);

@protocol IBTDatabaseObject;
@interface ICRDataBaseController : IBTObject

+ (instancetype)sharedController;

+ (NSString *)GetDataBasePath;
+ (void)CleanUpDBPath;

#pragma mark - Storage
- (void)storageEntities:(NSArray *)arrObjects
            objectClass:(Class<IBTDatabaseObject>)DBObjClass
            deleteLocal:(BOOL)bDeleteLocal
             handleData:(void (^)(id <IBTDatabaseObject>))handleDataBlock
               complete:(void (^)(void))complete
                   fail:(void (^)(NSError *))fail;

- (void)storageEntities:(NSArray *)arrObjects
            objectClass:(Class<IBTDatabaseObject>)DBObjClass
              updateNil:(BOOL)bUpdateNil
            deleteLocal:(BOOL)bDeleteLocal
             handleData:(void (^)(id <IBTDatabaseObject>))handleDataBlock
               complete:(void (^)(void))complete
                   fail:(void (^)(NSError *))fail;

- (void)storageEntity:(NSDictionary *)dictObject
          objectClass:(Class<IBTDatabaseObject>)DBObjClass
           handleData:(void (^)(id <IBTDatabaseObject>))handleDataBlock
             complete:(void (^)(void))complete
                 fail:(void (^)(NSError *))fail;

- (void)storageDBObject:(id<IBTDatabaseObject>)dbObj
             handleData:(void (^)(id <IBTDatabaseObject>))handleDataBlock
               complete:(void (^)(void))complete
                   fail:(void (^)(NSError *))fail;
/**
 *  兼容性校验，对于后来增加的字段进行校验，没有的话进行对应操作。应该在APP初始化的时候就调用
 */
- (void)compatibilityCheck;

#pragma mark - Query
- (void)runFetchForClass:(Class<IBTDatabaseObject>)dbObjClass
              fetchBlock:(ICRDatabaseFetchBlock)fetchBlock
       fetchResultsBlock:(ICRDatabaseFetchResultsBlock)fetchResultBlock;

@end
