//
//  TransportProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportProductViewController.h"
#import "FooterCell.h"
#import "HeaderCell.h"
#import "TransportPurductCell.h"
#import "TransportPdtDetail.h"

#import "GXFPopView.h"

#define TableHeight 44
#define ShowHeight  110

@interface TransportProductViewController ()
<UITableViewDataSource,UITableViewDelegate,FooterCellDelegate,HeaderCellDelegate,GXFPopViewDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell
}
@property (nonatomic,strong)GXFPopView *popView;
@end

@implementation TransportProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor  = XXFBgColor;
    [self initData];
    [self createView];
}
- (void)initData{
    _selectRowArr = [[NSMutableArray alloc]init];
    if (!self.transportProductArr) {
        self.transportProductArr = [NSMutableArray array];
    }
}

- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr withHiddenEdit:self.isHiddenEdit];
    [self.view addSubview:headCell];
    headCell.delegate = self;
    self.tableView.tableHeaderView = headCell;
    
    if (!self.isHiddenEdit) {
        FooterCell *footCell = [[FooterCell alloc]initWithFrame:CGRectMake(0, 0, _tableFrame.size.width, 50) withTitle:@"+点击添加商品明细" isTwo:self.twoTitle];
        [self.view addSubview:footCell];
        footCell.delegate = self;
        self.tableView.tableFooterView = footCell;
    }
}

#pragma mark - headCellDelegate
- (void)addClickList{
    if (!self.popView) {
        NSArray *arr = @[@"添加商品明细",@"选择采购单"];
        self.popView = [[GXFPopView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height) withArr:arr];
        self.popView.delegate = self;
        [AppWindow addSubview:self.popView];
    }
}
#pragma mark - popViewdelegate
- (void)selectRowTitle:(NSString *)str{
    if (self.popView) {
        [self.popView removeFromSuperview];
        self.popView= nil;
    }
    if ([str isEqualToString:@"添加商品明细"]) {
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil];
    }else if([str isEqualToString:@"选择采购单"]){
        [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_ChoseTransportPurchase object:nil];
    }
}
- (void)clearFromSuper{
    if (self.popView) {
        [self.popView removeFromSuperview];
        self.popView = nil;
    }
}

#pragma mark - footerDelegate
- (void)addClick{
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil];
}
- (void)editClick:(UIButton *)btn{
    TransportPdtDetail *pdDetail = self.transportProductArr[btn.tag];
   [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddPurchaseProduct object:nil userInfo:@{@"transportPdtDetail":pdDetail,@"indexTag":@(btn.tag)}];
}

- (void)choosePurchase{
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_ChoseTransportPurchase object:nil];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.transportProductArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"TransportPurductCell";
    TransportPurductCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[TransportPurductCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID withImageName:@"edit"];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = ShowHeight + TableHeight -1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = ShowHeight;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        CGRect Linefrmame = cell.lineLabel.frame;
        Linefrmame.origin.y = TableHeight-1;
        cell.lineLabel.frame = Linefrmame;
        CGRect showfrmame = cell.showView.frame;
        showfrmame.size.height = 0;
        cell.showView.frame = showfrmame;
        cell.backgroundColor = [UIColor whiteColor];
    }
    cell.editBtn.tag = indexPath.row;
    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
    
    if (self.transportProductArr.count > 0) {
        TransportPdtDetail *billP = self.transportProductArr[indexPath.row];
        [cell setPdtDetail:billP row:indexPath.row];
    }
    return cell;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    TransportPurductCell *cell = (TransportPurductCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        
        Linefrmame.origin.y = ShowHeight + TableHeight - 1;
        showfrmame.size.height = ShowHeight;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return ShowHeight + TableHeight;
    }
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
