//
//  CostViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "CostViewController.h"
#import "HeaderCell.h"
#import "FooterCell.h"
#import "CostCell.h"

#define TableHeight 44
#define ShowHeight  80

@interface CostViewController ()<UITableViewDataSource,UITableViewDelegate,FooterCellDelegate,HeaderCellDelegate>
{
    CGRect _tableFrame;
    NSMutableArray *_selectRowArr;//记录当前选中的cell

}
@end

@implementation CostViewController


- (void)viewDidLoad {
    self.view.backgroundColor  = XXFBgColor;
    [super viewDidLoad];
    _selectRowArr = [[NSMutableArray alloc]init];
    _costArr = [NSMutableArray array];
    [self createView];
}
- (void)setViewFrame:(CGRect)viewFrame{
    _tableFrame = viewFrame;
}
- (void)createView{
    self.tableView = [[UITableView alloc]initWithFrame:_tableFrame style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.view addSubview:self.tableView];
    
    NSArray *arr = @[@"费用",@"应付金额",@"已付金额",@"尾款"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr withHiddenEdit:self.isHiddenEdit];
    headCell.delegate = self;
    [self.view addSubview:headCell];
    self.tableView.tableHeaderView = headCell;
    if (!self.isHiddenEdit) {
        FooterCell *footCell = [[FooterCell alloc]initWithFrame:CGRectMake(0, 0, _tableFrame.size.width, 50) withTitle:@"+点击添加费用明细" isTwo:@""];
        [self.view addSubview:footCell];
        footCell.delegate = self;
        self.tableView.tableFooterView = footCell;
    }
}
- (void)addClickList{
    [self addClick];
}
- (void)addClick{
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddTransportCost object:nil];
}
- (void)editClick:(UIButton *)btn{
    FeeAcountDetail *fee = self.costArr[btn.tag];
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_AddTransportCost object:nil userInfo:@{@"indexPath":[NSIndexPath indexPathForRow:btn.tag inSection:0],@"feeAccountDetail":fee}];
}
#pragma mark footDelegate
- (void)choosePurchase{}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.costArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"CostCell";
    CostCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[CostCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (self.isHiddenEdit) {
            cell.editBtn.hidden = YES;
        }
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
//        CGRect Linefrmame = cell.lineLabel.frame;
//        Linefrmame.origin.y = ShowHeight + TableHeight -1;
//        cell.lineLabel.frame = Linefrmame;
        cell.lineLabel.top = ShowHeight + TableHeight -1;
//        CGRect showfrmame = cell.showView.frame;
//        showfrmame.size.height = ShowHeight;
//        cell.showView.frame = showfrmame;
        cell.showView.height = ShowHeight;
        cell.backgroundColor = XXFBgColor;
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
//        CGRect Linefrmame = cell.lineLabel.frame;
//        Linefrmame.origin.y = TableHeight-1;
//        cell.lineLabel.frame = Linefrmame;
        cell.lineLabel.top = TableHeight-1;

//        CGRect showfrmame = cell.showView.frame;
//        showfrmame.size.height = 0;
//        cell.showView.frame = showfrmame;
        cell.showView.height = 0;

        cell.backgroundColor = [UIColor whiteColor];
    }
    
    
    
    
    cell.editBtn.tag = indexPath.row;
    [cell.editBtn addTarget:self action:@selector(editClick:) forControlEvents:UIControlEventTouchUpInside];
    if (self.costArr.count) {
        FeeAcountDetail *fee = self.costArr[indexPath.row];
        [cell setFeeCost:fee row:indexPath.row];
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    CostCell *cell = (CostCell *)[tableView cellForRowAtIndexPath:indexPath];
    CGRect Linefrmame = cell.lineLabel.frame;
    CGRect showfrmame = cell.showView.frame;
    if (Linefrmame.origin.y == TableHeight - 1) {
        cell.smallImageView.image = [UIImage imageNamed:@"arrowdown"];
        Linefrmame.origin.y = ShowHeight + TableHeight - 1;
        showfrmame.size.height = ShowHeight;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr addObject:indexPath];
    }else{
        cell.smallImageView.image = [UIImage imageNamed:@"arrowright"];
        Linefrmame.origin.y = TableHeight -1;
        showfrmame.size.height = 0;
        cell.backgroundColor = [UIColor whiteColor];
        [_selectRowArr removeObject:indexPath];
    }
    cell.lineLabel.frame = Linefrmame;
    cell.showView.frame = showfrmame;
    [self.tableView reloadData];
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([self isHaveIndexPath:indexPath]) {
        return ShowHeight + TableHeight;
    }
    return TableHeight;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _selectRowArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}



/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
