//
//  BottomTransferView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/28.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BottomTransferView.h"
#import "TransportPdtDetail.h"
#import "FeeAcountDetail.h"
#define ContentHeight 44
#define BtnWidth 100
#define BeginTag 8000
#define SpaceWidth (ScreenSize.width - 100*2)/3

@interface BottomTransferView ()<UIScrollViewDelegate>
{
    UIScrollView *_bottomSV;
    UIImageView *_moveImageView;
    UIButton *_currentBtn;
    UIButton *_addBtn;
}
@end

@implementation BottomTransferView

- (instancetype)initWithFrame:(CGRect)frame withHidden:(BOOL)isHidden{
    self = [super initWithFrame:frame];
    if (self) {
        self.isHiddenEdit = isHidden;
        //界面
        [self bulidLayout];
    }
    return self;
}
#pragma mark - 布局
- (void)bulidLayout
{
    [self addChildView];
    
    [self createBottomView];
}
- (void)createBottomView{
    NSArray *arr = @[@"商品明细",@"费用明细"];
    
    _bottomSV = [[UIScrollView alloc]initWithFrame:CGRectMake(0,ContentHeight + 4, ScreenSize.width, CGRectGetHeight(self.frame) - ContentHeight-2)];
    _bottomSV.showsHorizontalScrollIndicator  = NO;
    _bottomSV.showsVerticalScrollIndicator = NO;
    _bottomSV.pagingEnabled = YES;
    _bottomSV.delegate = self;
    _bottomSV.contentSize = CGSizeMake(ScreenSize.width * arr.count, CGRectGetHeight(_bottomSV.frame));
    [self addSubview:_bottomSV];
    
    for (NSInteger i = 0; i < arr.count; i++) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
        [btn setTitle:arr[i] forState:UIControlStateNormal];
        btn.frame = CGRectMake(SpaceWidth + (BtnWidth+SpaceWidth) * i, 0, BtnWidth, ContentHeight);
        [btn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
        [btn setTitleColor:GXF_SAVE_COLOR forState:UIControlStateDisabled];
        btn.titleLabel.font = GXF_SIXTEENTEH_SIZE;
        btn.tag = i + BeginTag;
        [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:btn];
        
        UIView *view = [[UIView alloc]initWithFrame:CGRectMake(CGRectGetWidth(_bottomSV.frame) * i, 0, CGRectGetWidth(_bottomSV.frame), CGRectGetHeight(_bottomSV.frame))];
        
        if (i == 0) {
            view.backgroundColor = [UIColor redColor];
            self.productVC.viewFrame = view.bounds;
            self.productVC.isHiddenEdit = self.isHiddenEdit;
            [view addSubview:self.productVC.view];
        }else if(i == 1){
            self.costVC.viewFrame = view.bounds;
            self.costVC.isHiddenEdit = self.isHiddenEdit;
            [view addSubview:self.costVC.view];
            view.backgroundColor = [UIColor blueColor];
        }
        [_bottomSV addSubview:view];
    }
    _moveImageView = [[UIImageView alloc]initWithFrame:CGRectMake(SpaceWidth, ContentHeight, BtnWidth,4)];
    _moveImageView.image  = [UIImage imageNamed:@"tab_line"];
    
    UILabel  *lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, ContentHeight +1, ScreenSize.width, 1))];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [self addSubview:lineLabel];
    [self addSubview:_moveImageView];
}

- (void)addChildView{
    self.productVC = [[TransferProductViewController alloc]init];
    self.costVC = [[CostViewController alloc]init];
}
- (void)btnClick:(UIButton *)btn{
    NSInteger index = btn.tag - BeginTag;
    _currentBtn.enabled = YES;
    btn.enabled = NO;
    _currentBtn = btn;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * index;
        _moveImageView.frame = moveFrame;
        _bottomSV.contentOffset=CGPointMake(index * self.frame.size.width, 0);
    }];
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView{
    CGFloat offsetX = scrollView.contentOffset.x / self.frame.size.width;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * offsetX;
        _moveImageView.frame = moveFrame;
    }];
    _currentBtn.enabled = YES;
    UIButton *btn = (UIButton *) [self viewWithTag:offsetX + BeginTag];
    btn.enabled = NO;
    _currentBtn = btn;
}
//添加商品
- (void)refreshProduct:(TransportPdtDetail *)transportPdtDetail
{
    if (self.productVC.transferProductArr) {
        [self.productVC.transferProductArr addObject:transportPdtDetail];
        [self.productVC.tableView reloadData];
    }
}
//添加编辑
- (void)refreshCost:(FeeAcountDetail *)fee indexPath:(NSIndexPath *)indexPath{
    if (indexPath) {
        [self.costVC.costArr replaceObjectAtIndex:indexPath.row withObject:fee];
        [self.costVC.tableView reloadData];
    }else{
        if (self.costVC.costArr) {
            [self.costVC.costArr addObject:fee];
            [self.costVC.tableView reloadData];
        }
    }
}
//删除
- (void)refreshDelCost:(FeeAcountDetail *)fee indexPath:(NSIndexPath *)indexPath{
    if (indexPath) {
        [self.costVC.costArr removeObjectAtIndex:indexPath.row];
        [self.costVC.tableView reloadData];
    }
}
//刷新
- (void)refreshCost:(NSArray *)costArr{
    NSMutableArray *feeArr = [NSMutableArray array];
    for (NSDictionary *billDict in costArr) {
        FeeAcountDetail *billProbuct = [FeeAcountDetail new];
        [billProbuct setValuesForKeysWithDictionary:billDict];
        [feeArr addObject:billProbuct];
    }
    self.costVC.costArr = feeArr;
    [self.costVC.tableView reloadData];
}
- (void)refreshTranProduct:(NSArray *)tranProductArr{
    NSMutableArray *productArr = [NSMutableArray array];
    for (NSDictionary *billDict in tranProductArr) {
        TransferPdtDetail *billProbuct = [TransferPdtDetail new];
        [billProbuct setValuesForKeysWithDictionary:billDict];
        [productArr addObject:billProbuct];
    }
    self.productVC.transferProductArr = productArr;
    [self.productVC.tableView reloadData];
}
- (void)reProduct:(NSArray *)tranProductArr{
    [self.productVC.transferProductArr addObjectsFromArray:tranProductArr];
    [self.productVC.tableView reloadData];
}
- (void)refreshDelProduct:(TransferPdtDetail *)fee tag:(NSInteger)indexTag{
    if (fee) {
        [self.productVC.transferProductArr removeObjectAtIndex:indexTag];
        [self.productVC.tableView reloadData];
    }
}
- (void)refreshEditProduct:(TransferPdtDetail *)transportPdtDetail tag:(NSInteger)indexTag{
    [self.productVC.transferProductArr replaceObjectAtIndex:indexTag withObject:transportPdtDetail];
    [self.productVC.tableView reloadData];
}

@end
