//
//  SurveyListCell.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyListCell.h"
#define LeftMargin 90
#define TopMargin 10
#define TitleHeight 20
#define TableHeight 120
@implementation SurveyListCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.stateBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.stateBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftMargin - TopMargin*3, 20);
    self.stateBtn.titleLabel.font = GXF_FOURTEENTH_SIZE;
    [self.stateBtn setTitleColor:[UIColor whiteColor] forState:UIControlStateNormal];
    self.stateBtn.enabled = NO;
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, TopMargin, ScreenSize.width - LeftMargin, TitleHeight))];
    self.titleLabel.textColor = GXF_CONTENT_COLOR;
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.billnumberLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.titleLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.billnumberLabel.textColor = GXF_CELL_COLOR;
    self.billnumberLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.productnameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.billnumberLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.productnameLabel.textColor = GXF_CELL_COLOR;
    self.productnameLabel.font = GXF_FOURTEENTH_SIZE;
    
    
    self.begindateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.productnameLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.begindateLabel.textColor = GXF_CELL_COLOR;
    self.begindateLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.enddateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, CGRectGetMaxY(self.begindateLabel.frame), ScreenSize.width - LeftMargin, TitleHeight))];
    self.enddateLabel.textColor = GXF_CELL_COLOR;
    self.enddateLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width - LeftMargin - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.stateBtn];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.billnumberLabel];
    [self.contentView addSubview:self.productnameLabel];
    [self.contentView addSubview:self.begindateLabel];
    [self.contentView addSubview:self.enddateLabel];
    [self.contentView addSubview:self.lineLabel];

}


- (void)setSurvey:(Survey *)survey{
    self.titleLabel.text = survey.title;
    self.billnumberLabel.text = [NSString stringWithFormat:@"单号：%@",survey.billNumber];
    self.productnameLabel.text = [NSString stringWithFormat:@"商品：%@[%@]",survey.productName,survey.productCode];
    self.begindateLabel.text = [NSString stringWithFormat:@"开始时间：%@",survey.beginDate.length > 10 ? [survey.beginDate substringToIndex:10] :survey.beginDate];
    self.enddateLabel.text = [NSString stringWithFormat:@"结束时间：%@",survey.endDate.length > 10 ? [survey.endDate substringToIndex:10] :survey.endDate];
    NSString *stateStr = @"";
    if ([survey.state isEqualToString:SURVEY_STATE_INITIAL]) {
        stateStr = @"未提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"initial"]  forState:UIControlStateDisabled];
    }else if ([survey.state isEqualToString:SURVEY_STATE_SUBMITTED]) {
        stateStr = @"已提交";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
    }else if ([survey.state isEqualToString:SURVEY_STATE_INSURVEY]) {
        stateStr = @"调研中";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"insurvey"] forState:UIControlStateDisabled];
        
    }else if ([survey.state isEqualToString:SURVEY_STATE_FINISHED]) {
        stateStr = @"已完成";
        [self.stateBtn setBackgroundImage:[UIImage imageNamed:@"finish"] forState:UIControlStateDisabled];
    }
    [self.stateBtn setTitle:stateStr forState:UIControlStateNormal];
    
}
- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];
}

@end
