//
//  ICRTaskResultViewController.m
//  XFFruit
//
//  Created by Xummer on 4/12/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRTaskResultViewController.h"

#import "ICRTaskResultContentView.h"
#import "ICRTask.h"

@interface ICRTaskResultViewController ()
@property (strong, nonatomic) IBTUIScrollView *m_scrollView;
@property (strong, nonatomic) ICRTaskResultContentView *m_contentView;

@property (strong, nonatomic) ICRTask *m_task;


@end

@implementation ICRTaskResultViewController

#pragma mark - Life Cycle
- (instancetype)initWithTaskData:(ICRTask *)task {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    self.m_task = task;
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = [IBTCommon localizableString:@"Task"];
    
    [self initContentView];
    
    [self registerContentViewForKVO];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
    [self unregisterContentViewFromKVO];
}

#pragma mark - Private Method
- (void)initContentView {
    self.m_scrollView = [[IBTUIScrollView alloc] initWithFrame:self.view.bounds];
    [_m_scrollView autoresizingWithStrechFullSize];
    
    [self.view addSubview:_m_scrollView];
    
    self.m_contentView = [[ICRTaskResultContentView alloc] init];
    _m_contentView.frame = _m_scrollView.bounds;
    [_m_contentView updateWithTask:_m_task];
    
    [_m_scrollView addSubview:_m_contentView];
    _m_scrollView.contentSize = _m_contentView.size;
}

#pragma mark - Update Data
- (void)doHttpGetAttachment {
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf.m_contentView updateWithTask:_m_task];
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView showTips:data];
    };
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetAttachmentListWithType:kAttachmentTask
                                    objID:_m_task.uuid
                                  success:succ
                                  failure:fail];
}

#pragma mark - KVO

- (void)registerContentViewForKVO {
    for (NSString *keyPath in [self observableKeypaths]) {
        [_m_contentView addObserver:self forKeyPath:keyPath options:NSKeyValueObservingOptionNew context:NULL];
    }
}

- (void)unregisterContentViewFromKVO {
    for (NSString *keyPath in [self observableKeypaths]) {
        [_m_contentView removeObserver:self forKeyPath:keyPath];
    }
}

- (NSArray *)observableKeypaths {
    return @[ @"frame" ];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context {
    _m_scrollView.contentSize = _m_contentView.size;
}


@end
