//
//  ICRTaskDetailViewController.m
//  XFFruit
//
//  Created by Xummer on 4/9/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "ICRTaskDetailViewController.h"
#import "ICRTaskDetailContentView.h"

#import "ICRTaskProcessViewController.h"

#import "ICRTask.h"

@interface ICRTaskDetailViewController ()

@property (strong, nonatomic) IBTUIScrollView *m_scrollView;
@property (strong, nonatomic) ICRTaskDetailContentView *m_contentView;
@property (strong, nonatomic) ICRTask *m_task;

@end

@implementation ICRTaskDetailViewController

#pragma mark - Life Cycle
- (instancetype)initWithTaskData:(ICRTask *)task {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    self.m_task = task;
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    self.title = [IBTCommon localizableString:@"Task Detail"];
    
    [self initContentView];
    
    [self registerContentViewForKVO];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
//    [self doHttpGetAttachment];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
    [self unregisterContentViewFromKVO];
}

#pragma mark - Private Method
- (void)initContentView {
    self.m_scrollView = [[IBTUIScrollView alloc] initWithFrame:self.view.bounds];
    [_m_scrollView autoresizingWithStrechFullSize];
    
    [self.view addSubview:_m_scrollView];
    self.m_contentView = [[ICRTaskDetailContentView alloc] initWithIsAttach:NO];
    _m_contentView.frame = _m_scrollView.bounds;
//    [_m_contentView setBackgroundColor:[UIColor colorWithR:0 g:0 b:0 a:1]];
    [_m_contentView updateWithTask:_m_task];
    [_m_contentView.m_startBtn addTarget:self action:@selector(onStartProcess:)
                        forControlEvents:UIControlEventTouchUpInside];
    [_m_contentView.m_startBtn setHidden:false];
    [_m_scrollView addSubview:_m_contentView];
    _m_scrollView.contentSize = _m_contentView.size;
}

#pragma mark - Actions
- (void)onStartProcess:(__unused id)sender {
    ICRTaskProcessViewController *pVC = [[ICRTaskProcessViewController alloc] initWithTaskData:self.m_task];
    [self PushViewController:pVC animated:YES];
}

#pragma mark - Update Data
- (void)doHttpGetAttachment {
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf.m_contentView updateWithTask:_m_task];
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView showTips:data];
    };
    
    ICRHTTPController *httpCtrl = [ICRHTTPController sharedController];
    [httpCtrl doGetAttachmentListWithType:kAttachmentTask
                                    objID:_m_task.uuid
                                  success:succ
                                  failure:fail];
}

#pragma mark - KVO

- (void)registerContentViewForKVO {
    for (NSString *keyPath in [self observableKeypaths]) {
        [_m_contentView addObserver:self forKeyPath:keyPath options:NSKeyValueObservingOptionNew context:NULL];
    }
}

- (void)unregisterContentViewFromKVO {
    for (NSString *keyPath in [self observableKeypaths]) {
        [_m_contentView removeObserver:self forKeyPath:keyPath];
    }
}

- (NSArray *)observableKeypaths {
    return @[ @"frame" ];
}

- (void)observeValueForKeyPath:(NSString *)keyPath ofObject:(id)object change:(NSDictionary *)change context:(void *)context {
    _m_scrollView.contentSize = _m_contentView.size;
}

@end
