//
//  SaleViewCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleViewCell.h"

#define Sale_Cell_Height  50
#define Left_Width 85
#define Left_margin 10
@interface SaleViewCell ()
{
    BOOL    hasBuildLayout;         // default, NO;
}


@property (nonatomic, strong) UILabel *dqLabel;
@property (nonatomic, strong) UILabel *saleLabel;
@property (nonatomic, strong) UILabel *lastWeekLabel;
@property (nonatomic, strong) UILabel *rateLabel;

@property (nonatomic, strong) UIFont *textFont;
@property (nonatomic, strong) UIFont *titleFont;

@property (nonatomic, strong) NSIndexPath *indexPath;

@end


@implementation SaleViewCell


+ (CGFloat)cellHeight
{
    return Sale_Cell_Height;
}

#pragma mark - build view

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    hasBuildLayout = YES;
    
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:13];
    }
    
    if(self.titleFont == nil) {
        self.titleFont = [UIFont systemFontOfSize:17];
    }
    
    //页面布局
    [self createView];
}

//创建视图
- (void)createView
{

    CGRect rect = CGRectMake(Left_margin,0, Left_Width, Sale_Cell_Height);
    self.dqLabel = [IBTCommon labelWithTitle:@"0101第一片区" frame:rect textFont:self.textFont];
    self.dqLabel.textColor = GXF_NAVIGAYION_COLOR;
    [self.contentView addSubview:self.dqLabel];
    
    CGFloat width = (ScreenSize.width - self.dqLabel.width)/3;
    
    rect = CGRectMake(self.dqLabel.right , 0, width, Sale_Cell_Height);
    self.saleLabel = [IBTCommon labelWithTitle:@"56,080" frame:rect textFont:self.textFont];
    self.saleLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.saleLabel];
    
    rect = CGRectMake(self.saleLabel.right, 0, width, Sale_Cell_Height);
    self.lastWeekLabel = [IBTCommon labelWithTitle:@"14.20%" frame:rect textFont:self.textFont];
    self.lastWeekLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.lastWeekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.right, 0, width, Sale_Cell_Height);
    self.rateLabel = [IBTCommon labelWithTitle:@"60%" frame:rect textFont:self.textFont];
    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.rateLabel];

    UILabel *lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(10, Sale_Cell_Height - 1, ScreenSize.width - 10 * 2, 1))];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    [self.contentView addSubview:lineLabel];
    
}


#pragma mark - update view

- (void)updateCellWith:(id)policy index:(NSIndexPath *)indexPath
{
    self.indexPath = indexPath;
    
    [self buildLayout];

}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
