//
//  SaleHeaderView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleHeaderView.h"

#define Sale_Header_Height 30

@interface SaleHeaderView ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) UIFont *textFont;

@end


@implementation SaleHeaderView


+ (CGFloat)viewHeight
{
    return Sale_Header_Height;
}

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:15];
    }
    
    hasBuildLayout = YES;
    self.contentView.backgroundColor = XXFBgColor;
    
    CGRect rect = CGRectMake(0, 0, 50, Sale_Header_Height);
    UILabel *searLabel = [IBTCommon labelWithTitle:@"280家" frame:rect textFont:self.textFont];
    searLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:searLabel];

    rect = CGRectMake(searLabel.right, 0,Sale_Header_Height - 5, Sale_Header_Height);
    
    self.searchBtn = [IBTCommon buttonWithImage:[UIImage imageNamed:@"search"] frame:rect];
    [self.contentView addSubview:self.searchBtn];
    
    
    CGFloat width = (ScreenSize.width  - searLabel.width - self.searchBtn.width - 20)/3;

    rect = CGRectMake(self.searchBtn.right + 20 , 0, width, Sale_Header_Height);
    UIButton * xsBtn = [IBTCommon buttonWithTitle:@"销售额" Image:[UIImage imageNamed:@"arrowdown"] frame:rect fontSize:15 fontColor:[UIColor blackColor]];
    [self.contentView addSubview:xsBtn];
    
    rect = CGRectMake(xsBtn.right , 0, width, Sale_Header_Height);
    UIButton * bszLabel = [IBTCommon buttonWithTitle:@"比上周" Image:[UIImage imageNamed:@"arrowdown"] frame:rect fontSize:15 fontColor:[UIColor blackColor]];
    [self.contentView addSubview:bszLabel];
    
    
    
    rect = CGRectMake(bszLabel.right , 0, width, Sale_Header_Height);
    UILabel * sclLabel = [IBTCommon labelWithTitle:@"达成率" frame:rect textFont:self.textFont];
    sclLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:sclLabel];
   
}

@end
