//
//  PassengerHeaderCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassengerHeaderCell.h"


#define Sale_Header_Height 30

@interface PassengerHeaderCell ()
{
    BOOL    hasBuildLayout;         // default, NO;
}

@property (nonatomic, strong) UILabel *label;
@property (nonatomic, strong) UIFont *textFont;

@end


@implementation PassengerHeaderCell


+ (CGFloat)viewHeight
{
    return Sale_Header_Height;
}

- (void)buildLayout
{
    if(hasBuildLayout) {
        return;
    }
    
    if(self.textFont == nil) {
        self.textFont = [UIFont systemFontOfSize:15];
    }
    
    hasBuildLayout = YES;
    self.contentView.backgroundColor = [UIColor lightGrayColor];
    
    CGRect rect = CGRectMake(0, 0, 50, Sale_Header_Height);
    UILabel *searLabel = [IBTCommon labelWithTitle:@"280家" frame:rect textFont:self.textFont];
    searLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:searLabel];
    
    rect = CGRectMake(searLabel.right, 0,Sale_Header_Height - 5, Sale_Header_Height);
    UIImageView *yearImage = [[UIImageView alloc]initWithFrame:rect];
    yearImage.image = [UIImage imageNamed:@"search"];
    [self.contentView addSubview:yearImage];
    
    
    CGFloat width = (ScreenSize.width  - searLabel.width - yearImage.width - 20)/2;
    
    rect = CGRectMake(yearImage.right + 20 , 0, width, Sale_Header_Height);
    UILabel * ksjLabel = [IBTCommon labelWithTitle:@"客单价" frame:rect textFont:self.textFont];
    ksjLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:ksjLabel];
    
    
    rect = CGRectMake(ksjLabel.right , 0, width, Sale_Header_Height);
    UILabel * bszLabel = [IBTCommon labelWithTitle:@"比上周" frame:rect textFont:self.textFont];
    bszLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:bszLabel];
    
}

@end
