//
//  SaleViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/6.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "SaleViewController.h"
#import "CustomSegView.h"
#import "SMPageControl.h"
#import "SaleViewCell.h"
#import "SaleHeaderView.h"
#define LeftWidth   50

static NSString *saleCellIdentify = @"saleCellIdentify";
static NSString *saleHeaderIdentify = @"saleHeaderIdentify";


@interface SaleViewController ()<CustomSegViewDelegate,UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)CustomSegView *segView;
@property (nonatomic,strong)SMPageControl *pageControl;
@property (nonatomic,strong)UILabel *leftLabel;
@property (nonatomic,strong)UILabel *centerLabel;
@property (nonatomic,strong)UILabel *rightLabel;
@property (nonatomic,strong)UILabel *dateLabel;
@property (nonatomic,strong)UILabel *lastWeekLabel;
@property (nonatomic,strong)UILabel *lastYearLabel;
@property (nonatomic,strong)UILabel *rateLabel;
@property (nonatomic,strong)UILabel *averageLabel;
@property (nonatomic,strong)UIImageView *lastWeekImage;
@property (nonatomic,strong)UIImageView *lastYearImage;

@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSMutableArray *dataArr;
@end

@implementation SaleViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout{
    self.view .backgroundColor = [UIColor whiteColor];
    CGRect rect = CGRectMake(10, 10, ScreenSize.width - 10*2, 30);
    NSArray *arr = @[SaleDay,SaleWeek,SaleMonth];
    self.segView = [[CustomSegView alloc]initWithFrame:rect withArr:arr];
    self.segView.delegate = self;
    [self.view addSubview:self.segView];
    
    
    rect = CGRectMake(0, self.segView.bottom + 30, LeftWidth, 20);
    self.leftLabel = [[UILabel alloc]initWithFrame:rect];
    self.leftLabel.textColor = [UIColor lightGrayColor];
    self.leftLabel.text = @"89.09";
    [self.view addSubview:self.leftLabel];
    
    NSMutableAttributedString *attributeStr1 = [IBTCommon setTextViewBoldFontOfString:@"$" paragraphStyle:8 fontSize:20 color:GXF_NAVIGAYION_COLOR];
    [attributeStr1 appendAttributedString:[IBTCommon setTextViewBoldFontOfString:@"  235,088" paragraphStyle:8 fontSize:30 color:[UIColor redColor]]];
    
    rect = CGRectMake(self.leftLabel.right, self.segView.bottom + 20, ScreenSize.width - self.leftLabel.width * 2 , 30);
    self.centerLabel = [[UILabel alloc]initWithFrame:rect];
    self.centerLabel.attributedText = attributeStr1;
    self.centerLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:self.centerLabel];

    rect = CGRectMake(ScreenSize.width - LeftWidth, self.segView.bottom + 30, LeftWidth, 20);
    self.rightLabel = [[UILabel alloc]initWithFrame:rect];
    self.rightLabel.textColor = [UIColor lightGrayColor];
    self.rightLabel.text = @"1290";
    self.rightLabel.textAlignment = NSTextAlignmentRight;
    [self.view addSubview:self.rightLabel];

    rect = CGRectMake(self.leftLabel.right, self.centerLabel.bottom,self.centerLabel.width, 20);
    self.dateLabel = [[UILabel alloc]initWithFrame:rect];
    self.dateLabel.textColor = GXF_CONTENT_COLOR;
    self.dateLabel.font =  GXF_FOURTEENTH_SIZE;
    self.dateLabel.textAlignment = NSTextAlignmentCenter;
    self.dateLabel.text = @"2015-10-21星期一累计销售额";
    [self.view addSubview:self.dateLabel];

    CGFloat bottomWidth = (ScreenSize.width - 20)/4;
    
    rect = CGRectMake(10, self.dateLabel.bottom + 5,30, 30);

    UIImageView *lastImage = [[UIImageView alloc]initWithFrame:rect];
    lastImage.image = [UIImage imageNamed:@"goSale"];
    [self.view addSubview:lastImage];
    self.lastWeekImage = lastImage;
    
    rect = CGRectMake(lastImage.right, lastImage.top,bottomWidth - lastImage.width, 30);
    self.lastWeekLabel = [[UILabel alloc]initWithFrame:rect];
    self.lastWeekLabel.textColor = GXF_CONTENT_COLOR;
    self.lastWeekLabel.text = @"13.2%";
    self.lastWeekLabel.textColor = [UIColor redColor];
    [self.view addSubview:self.lastWeekLabel];
    
    rect = CGRectMake(lastImage.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *weekLabel = [[UILabel alloc]initWithFrame:rect];
    weekLabel.textColor = [UIColor lightGrayColor];
    weekLabel.text = @"比上周同期";
    weekLabel.font = GXF_THREETEENTH_SIZE;
    weekLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:weekLabel];
    
    rect = CGRectMake(self.lastWeekLabel.right, lastImage.top,30, 30);
    UIImageView *yearImage = [[UIImageView alloc]initWithFrame:rect];
    yearImage.image = [UIImage imageNamed:@"downSale"];
    [self.view addSubview:yearImage];
    self.lastYearImage = yearImage;
    
    rect = CGRectMake(yearImage.right, lastImage.top,bottomWidth - yearImage.width, 30);
    self.lastYearLabel = [[UILabel alloc]initWithFrame:rect];
    self.lastYearLabel.textColor = GXF_CONTENT_COLOR;
    self.lastYearLabel.text = @"13.2%";
    self.lastYearLabel.textColor = GXF_NAVIGAYION_COLOR;
    [self.view addSubview:self.lastYearLabel];
    
    rect = CGRectMake(yearImage.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *yearLabel = [[UILabel alloc]initWithFrame:rect];
    yearLabel.textColor = [UIColor lightGrayColor];
    yearLabel.text = @"比去年同期";
    yearLabel.font = GXF_THREETEENTH_SIZE;
    yearLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:yearLabel];

    rect = CGRectMake(self.lastYearLabel.right,lastImage.top,bottomWidth, 30);
    self.rateLabel = [[UILabel alloc]initWithFrame:rect];
    self.rateLabel.textColor = [UIColor blueColor];
    self.rateLabel.text = @"60.4%";
    self.rateLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:self.rateLabel];
    
    rect = CGRectMake(self.rateLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *raLabel = [[UILabel alloc]initWithFrame:rect];
    raLabel.textColor = [UIColor lightGrayColor];
    raLabel.text = @"销售达成率";
    raLabel.font = GXF_THREETEENTH_SIZE;
    raLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:raLabel];
    
    rect = CGRectMake(self.rateLabel.right, lastImage.top,bottomWidth, 30);
    self.averageLabel = [[UILabel alloc]initWithFrame:rect];
    self.averageLabel.textColor = [UIColor blueColor];
    self.averageLabel.text = @"60,444";
    self.averageLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:self.averageLabel];
    
    rect = CGRectMake(self.averageLabel.left, self.lastWeekLabel.bottom,bottomWidth,20);
    UILabel *avLabel = [[UILabel alloc]initWithFrame:rect];
    avLabel.textColor = [UIColor lightGrayColor];
    avLabel.text = @"单店日均";
    avLabel.font = GXF_THREETEENTH_SIZE;
    avLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:avLabel];

    
    
    self.pageControl = [[SMPageControl alloc]initWithFrame:CGRectMake(0, weekLabel.bottom + 5 , self.view.width, 20)];
    self.pageControl.currentPage = 0;
    self.pageControl.pageIndicatorTintColor = XXFBgColor;
    self.pageControl.currentPageIndicatorTintColor = GXF_NAVIGAYION_COLOR;
    self.pageControl.numberOfPages = 3;
    self.pageControl.indicatorMargin = 15.0f;
    
    self.pageControl.indicatorDiameter = 15.0f;
    [self.view addSubview:self.pageControl];
    
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(pageClick)];
    [self.pageControl addGestureRecognizer:tap];
    
    CLog(@"%f---------",self.view.height);

    rect = CGRectMake(0, self.pageControl.bottom + 5, self.view.width, self.view.height - self.pageControl.bottom - 118);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerClass:[SaleViewCell class] forCellReuseIdentifier:saleCellIdentify];
    [self.tableView registerClass:[SaleHeaderView class] forHeaderFooterViewReuseIdentifier:saleHeaderIdentify];
    

    [self.view addSubview:self.tableView];

}


#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return 10;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
     SaleViewCell *cell = (SaleViewCell *)[tableView dequeueReusableCellWithIdentifier:saleCellIdentify forIndexPath:indexPath];
    
    if(cell == nil) {
        cell = [[SaleViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:saleCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    
//    if(task != nil) {
        [cell updateCellWith:nil index:indexPath];
//        cell.delegate = self;
    
    
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [SaleViewCell cellHeight];
}


- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    SaleHeaderView *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:saleHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[SaleHeaderView alloc] initWithReuseIdentifier:saleHeaderIdentify];
    }
    
    [headerView buildLayout];
    [headerView.searchBtn addTarget:self action:@selector(searchClick) forControlEvents:UIControlEventTouchUpInside];
    return headerView;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [SaleHeaderView viewHeight];
}

- (void)pageClick{
    CLog(@"=====");
}

#pragma mark - 搜索点击事件
- (void)searchClick{
    CLog(@"搜索============");
}

#pragma mark - segViewDelegate
- (void)customSegOneClick:(NSString *)title{
    //日周年切换

}
- (void)customSegTwoClick:(NSString *)title{
    //选择历史查看
}




- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
