//
//  GXFSearchView.m
//  XFFruit
//
//  Created by freecui on 15/9/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//
#define TopMargin 50
#import "GXFSearchView.h"
@interface GXFSearchView ()<UITextFieldDelegate>


@end
@implementation GXFSearchView
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    self.f_textFiled = [[UITextField alloc]initWithFrame:CGRectMake(20, 5, self.width - 20 * 2, TopMargin - 10)];
    self.f_textFiled.textAlignment = NSTextAlignmentLeft;
    self.f_textFiled.font = FontSize(15);
    [self addSubview:_f_textFiled];
    
    UIImageView *leftImgV = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftImgV.image = [UIImage imageNamed:@"search"];
    self.f_textFiled.background = [UIImage imageNamed:@"textFiled"];
    self.f_textFiled.leftView = leftImgV;
    self.f_textFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightBtn setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightBtn.frame = CGRectMake(0, 0, 35, 40);
    [rightBtn addTarget:self action:@selector(deleteClicked) forControlEvents:UIControlEventTouchUpInside];
    self.f_textFiled.rightView = rightBtn;
    self.f_textFiled.rightViewMode = UITextFieldViewModeAlways;
    
    return self;
}

- (void)deleteClicked {
    if ([_delegate respondsToSelector:@selector(searchViewClickedDelegateBtn)]) {
        [_delegate searchViewClickedDelegateBtn];
    }
}


@end
