//
//  GXFProcessProductTableViewCell.m
//  XFFruit
//
//  Created by freecui on 15/9/4.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//


#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define ContentColor @"444444"
#define ContentSize 16
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowColor @"bbbbbb"
#define ShowSize 13
#define ShowWidth 150
#define ShowHeight 20

#import "GXFProcessProductTableViewCell.h"

@interface GXFProcessProductTableViewCell ()

@property (nonatomic,strong)UILabel *titleLabel;
@property (nonatomic,strong)UILabel *baseQtyLabel;

@property (nonatomic,strong)UILabel *instockDateLabel;




@property (nonatomic,strong)UILabel *showTitleLabel;
@property (nonatomic,strong)UILabel *showBaseCountLabel;
@property (nonatomic,strong)UILabel *showDateLabel;
@property (nonatomic,strong)UILabel *basebaseQtyLabel;
@property (nonatomic,strong)UILabel *totalbaseQtyLabel;
@property (nonatomic,strong)UILabel *placeLabel;
@property (nonatomic,strong)UILabel *qualityLabel;
@property (nonatomic,strong)UILabel *remarkLabel;

@end
@implementation GXFProcessProductTableViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style
              reuseIdentifier:(NSString *)reuseIdentifier
              processProduct: (GXFProcessProduct *)processProduct {
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayoutWithprocessProduct: processProduct];
    }
    return self;
}

- (void)bulidLayoutWithprocessProduct: (GXFProcessProduct *)processProduct
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (3 -1))/3;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    self.smallImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = HexColor(ContentColor);
    self.seqLabel.text = processProduct.productUuid;//@"13";
    self.seqLabel.font = FontSize(ContentSize);
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentLeft;
    self.titleLabel.textColor = HexColor(ContentColor);
    self.titleLabel.text = processProduct.productName;//@"苹果桃子";
    self.titleLabel.font = FontSize(ContentSize);
    
    self.baseQtyLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.baseQtyLabel.textAlignment = NSTextAlignmentLeft;
    self.baseQtyLabel.textColor = HexColor(ContentColor);
    self.baseQtyLabel.text = [NSString stringWithFormat:@"%@",processProduct.baseQty];
    self.baseQtyLabel.font = FontSize(ContentSize);
    
    
    self.instockDateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.baseQtyLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.instockDateLabel.textAlignment = NSTextAlignmentLeft;
    self.instockDateLabel.text = [NSString stringWithFormat:@"%@",processProduct.outstockDate
                                  ];
    self.instockDateLabel.textColor = HexColor(ContentColor);
    self.instockDateLabel.font = FontSize(ContentSize);
    
    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
    //    self.showView.hidden = YES;
    self.showView.clipsToBounds = YES;
    
    self.showTitleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.seqLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showTitleLabel.textAlignment = NSTextAlignmentLeft;
    self.showTitleLabel.textColor = HexColor(ShowColor);
    self.showTitleLabel.text = [NSString stringWithFormat:@"原料：%@",processProduct.productName];
    self.showTitleLabel.font = FontSize(ShowSize);
    
    self.showBaseCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showTitleLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showBaseCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showBaseCountLabel.textColor = HexColor(ShowColor);
    self.showBaseCountLabel.text = [NSString stringWithFormat:@"基础数量：%@",processProduct.baseQty];//@"基础数量：10000";
    self.showBaseCountLabel.font = FontSize(ShowSize);
    
    self.showDateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.showTitleLabel.frame), ShowWidth, ShowHeight))];
    self.showDateLabel.textAlignment = NSTextAlignmentLeft;
    self.showDateLabel.textColor = HexColor(ShowColor);
    self.showDateLabel.text = [NSString stringWithFormat:@"出库时间：%@",processProduct.outstockDate];//@"入库时间：2015-02-04";
    self.showDateLabel.font = FontSize(ShowSize);
    
    self.basebaseQtyLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showBaseCountLabel.frame), CGRectGetMaxY(self.showTitleLabel.frame), ShowWidth, ShowHeight))];
    self.basebaseQtyLabel.textAlignment = NSTextAlignmentLeft;
    self.basebaseQtyLabel.textColor = HexColor(ShowColor);
    self.basebaseQtyLabel.text = [NSString stringWithFormat:@"包装单位：%@",processProduct.unit];//@"基础单价：11元";
    self.basebaseQtyLabel.font = FontSize(ShowSize);
    
    self.totalbaseQtyLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.showDateLabel.frame), ShowWidth, ShowHeight))];
    self.totalbaseQtyLabel.textAlignment = NSTextAlignmentLeft;
    self.totalbaseQtyLabel.textColor = HexColor(ShowColor);
    self.totalbaseQtyLabel.text =[NSString stringWithFormat:@"包装规格：%@",processProduct.qpc];// @"总金额：1000";
    self.totalbaseQtyLabel.font = FontSize(ShowSize);
    
    self.placeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showBaseCountLabel.frame), CGRectGetMaxY(self.showDateLabel.frame), ShowWidth, ShowHeight))];
    self.placeLabel.textAlignment = NSTextAlignmentLeft;
    self.placeLabel.textColor = HexColor(ShowColor);
    self.placeLabel.text = [NSString stringWithFormat:@"包装规格描述：%@",processProduct.qpcStr];//@"产地：河南省";
    self.placeLabel.font = FontSize(ShowSize);
    
    self.qualityLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.totalbaseQtyLabel.frame), ShowWidth, ShowHeight))];
    self.qualityLabel.textAlignment = NSTextAlignmentLeft;
    self.qualityLabel.textColor = HexColor(ShowColor);
    self.qualityLabel.text = [NSString stringWithFormat:@"包装数量：%@",processProduct.quantity];// @"质量：1000";
    self.qualityLabel.font = FontSize(ShowSize);
    
    self.remarkLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.qualityLabel.frame), ShowWidth, ShowHeight))];
    self.remarkLabel.textAlignment = NSTextAlignmentLeft;
    self.remarkLabel.textColor = HexColor(ShowColor);
    self.remarkLabel.text = [NSString stringWithFormat:@"备注：%@",processProduct.remark];//@"描述：河南省";
    self.remarkLabel.font = FontSize(ShowSize);
    
    
    
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.baseQtyLabel];
    //    [self.contentView addSubview:self.standardLabel];
    [self.contentView addSubview:self.instockDateLabel];
    
    
    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.showView];
    
    [self.showView addSubview:self.showTitleLabel];
    [self.showView addSubview:self.showBaseCountLabel];
    [self.showView addSubview:self.showDateLabel];
    [self.showView addSubview:self.basebaseQtyLabel];
    [self.showView addSubview:self.totalbaseQtyLabel];
    [self.showView addSubview:self.placeLabel];
    [self.showView addSubview:self.qualityLabel];
    [self.showView addSubview:self.remarkLabel];
    [self.contentView addSubview:self.lineLabel];
    
    
}

//- (void)
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
