//
//  ICRUserUtil.h
//  XFFruit
//
//  Created by Xummer on 3/29/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface ICRUserUtil : IBTObject <NSCoding, NSCopying>

// Login Data
@property (copy, nonatomic) NSString *userName;
@property (copy, nonatomic) NSString *password;
@property (copy, nonatomic) NSString *registerCode;  //企业认证码
@property (copy, nonatomic) NSString *token;
@property (copy, nonatomic) NSNumber *bAutoLogin;
@property (copy, nonatomic) NSString *authenticode;//企业认证码
@property (assign,nonatomic)BOOL needFresh;

// User Data
@property (copy, nonatomic) NSString *userId;  // 唯一标识
@property (copy, nonatomic) NSString *displayName; //用户名称
@property (copy, nonatomic) NSString *userCode; // 用户代码

@property (copy, nonatomic) NSString *orgCode; // 企业代码
@property (copy, nonatomic) NSString *orgName; // 企业名称
@property (copy, nonatomic) NSString *orgId;   //  唯一标识

@property (strong, nonatomic) NSArray *permissions; //权限列表




@property (copy, nonatomic) NSString *currentStoreID;  //
@property (copy, nonatomic) NSString *uniqueID;  //

+ (instancetype)sharedInstance;

- (BOOL)saveArchive;

- (BOOL)isLogin;

- (void)logout;

- (NSString *)mobileID;

- (void)storageUserName:(NSString *)userName
               password:(NSString *)password
           registerCode:(NSString *)registerCode
                  token:(NSString *)token;

- (void)storageCurrentStoreID:(NSString *)currentStoreID;

- (void)updatePassword:(NSString *)pwd;

@end
