//
//  IBTUINavigationController.m
//  IBTImagePicker
//
//  Created by Xummer on 1/17/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTUINavigationController.h"

@interface IBTUINavigationController ()

@end

@implementation IBTUINavigationController

#pragma mark - Life Cycle
- (id)initWithRootViewController:(UIViewController *)rootViewController {
    self = [super initWithRootViewController:rootViewController];
    if (self) {
        
        self.navigationBar.translucent = NO;
        
        // iOS 7 手势返回
        if (IBT_IOS7_OR_LATER) {
            self.interactivePopGestureRecognizer.delegate = _bEnablePopGesture ? (id<UIGestureRecognizerDelegate>)self : nil;
        }
        
        self.bEnablePopGesture = YES;
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

#pragma mark - Setter
- (void)setBEnablePopGesture:(BOOL)bEnablePopGesture {
    _bEnablePopGesture = bEnablePopGesture;
    
    if ([self respondsToSelector:@selector(interactivePopGestureRecognizer)]) {
        self.interactivePopGestureRecognizer.enabled = _bEnablePopGesture;
    }
}

#pragma mark - Route

// below iOS6 use this method
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return UIInterfaceOrientationIsPortrait(interfaceOrientation);
}

// Above iOS6 use these two methods
- (BOOL)shouldAutorotate {
    return YES;
}

- (NSUInteger)supportedInterfaceOrientations {
    return UIInterfaceOrientationMaskPortrait;
}

#pragma mark - iOS7 Status bar

- (UIStatusBarStyle)preferredStatusBarStyle {
    return UIStatusBarStyleLightContent;
}

- (BOOL)prefersStatusBarHidden {
    return NO;
}

@end
