//
//  ICRAppViewControllerManager.h
//  XFFruit
//
//  Created by Xummer on 3/23/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"
#import "IBTTabBarController.h"

#define CR_NAME_HOME            @"Home"
#define CR_name_BUSINESS        @"Business"
#define CR_NAME_Report           @"Report"
#define CR_NAME_SYNC            @"Message"
#define CR_NAME_SYSTEM          @"Me"

typedef NS_ENUM(NSUInteger, CRTapBarItemIndex) {
    kCRHome = 0,
    kCRBusiness,
    kCRReport,
    kCRSync,
    kCRSystem,
};

static NSString * const ACETapBarItemNames[] = {
    [ kCRHome ]     = CR_NAME_HOME,
    [ kCRBusiness ] = CR_name_BUSINESS,
    [ kCRReport ]    = CR_NAME_Report,
    [ kCRSync ]     = CR_NAME_SYNC,
    [ kCRSystem ]   = CR_NAME_SYSTEM,
};

@interface ICRAppViewControllerManager : IBTObject
{
    UIWindow *m_window;
    NSMutableArray *m_arrViewController;
    NSMutableArray *m_arrTabBarBaseViewController;
    IBTTabBarController *m_tabbarController;
}

+ (UINavigationController *)getCurrentNavigationController;
+ (IBTTabBarController *)getTabBarController;
+ (ICRAppViewControllerManager *)getAppViewControllerManager;

- (id)initWithWindow:(UIWindow *)window;

- (CGSize)getRootViewSize;

- (UIViewController *)getTabBarBaseViewController:(CRTapBarItemIndex)index;

- (IBTTabBarController *)getTabBarController;
- (NSUInteger)getCurTabBarIndex;

- (void)doLogout;

- (void)openFirstView;
- (void)openMainFrame;

- (void)createHomeViewController;
- (void)createStoreViewController;
- (void)createSyncViewController;
- (void)createSystemViewController;

@end
