//
//  SingleScrollView.m
//  PhotoWallDemo
//
//  Created by LZXuan on 14-8-18.
//  Copyright (c) 2014年 LZXuan. All rights reserved.
//

#import "SingleScrollView.h"
#import "UIImageView+WebCache.h"
#define SW  1

@interface SingleScrollView()
@property (nonatomic,assign) id target;
@property (nonatomic,assign) SEL action;

@property (nonatomic,assign) id targetD;
@property (nonatomic,assign) SEL actionD;
@end
@implementation SingleScrollView
{
    UIImageView *_imageView;
}

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code
        
        
    }
    return self;
}
- (SingleScrollView *)initWithFrame:(CGRect)frame image:(NSString *)image{
    if (self = [super initWithFrame:frame]) {
        self.showsHorizontalScrollIndicator = NO;
        self.showsVerticalScrollIndicator = NO;
        //设置最大放大倍数
        self.minimumZoomScale = 1.0;
        self.maximumZoomScale = 2.0;
        //粘贴一张图片
        _imageView = [[UIImageView alloc] init];
        
     
        _imageView.frame = CGRectMake(0, 0, self.frame.size.width - 10*2, self.frame.size.height);
        _imageView.center = CGPointMake(self.frame.size.width/2, self.frame.size.height/2);
        if ([image hasPrefix:@"http://"]) {
            NSURL *url = [NSURL URLWithString:image];
            [_imageView sd_setImageWithURL:url placeholderImage:[UIImage imageNamed:@"leftDetailBg.png"]];
        }else{
            _imageView.image=[UIImage imageNamed:image];
        }
         _imageView.contentMode = UIViewContentModeScaleAspectFit;
        [self addSubview:_imageView];
    }
    return self;
}
- (void)addSingleClickTarget:(id)target action:(SEL)action{
    self.target = target;
    self.action = action;
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(tap:)];

    tap.numberOfTapsRequired = 1;
    [self addGestureRecognizer:tap];
//    UIPinchGestureRecognizer *pinch = [[UIPinchGestureRecognizer alloc]
//                                       initWithTarget:self action:@selector(pinch:)];
//    [self addGestureRecognizer:pinch];

    
}
- (void)tap:(UITapGestureRecognizer *)tap{
        if ([self.target respondsToSelector:self.action]) {
            [self.target performSelector:self.action withObject:self];
        }
}

//- (void)pinch:(UIPinchGestureRecognizer *)pinch{
//    //通过触摸当前的图片视图 让目标对象指向目标对象的行为
//    if ([self.target respondsToSelector:self.action]) {
//        [self.target performSelector:self.action withObject:pinch withObject:self];
//    }
//}
@end
