//
//  NewReceiveProductViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/10/15.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewReceiveProductViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "ChooseProductViewController.h"
#import "ChooseProductUnitViewController.h"
#import "GeometryView.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableRowHeight 46
#define CornerRadius 5
#define BtnSize 19
#define TotalHeight 230
#define KeyboardHeight 258

@interface NewReceiveProductViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate,UIAlertViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    
    UILabel *_chooseProductLabel;
    UILabel *_choosePackUnitLabel;
    UILabel *_choosePackStandLabel;
    UILabel *_choosePackCountLabel;
    UILabel *_chooseBaseCountLabel;
    UILabel *_choosePackPriceLabel;
    UILabel *_chooseBasePriceLabel;
    UILabel *_chooseTotalLabel;
    UILabel *_chooseTotalPriceLabel;
    

    UITextField *_shPackField;
    UITextField *_shBaseQuantityField;
    UILabel *_shjcLabel;
    UILabel *_shbzLabel;
    
    HPGrowingTextView *_noteTextView;
    GeometryView *_geometryView;
}
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *productQpcStr;//商品规格描述
@property (nonatomic,strong)NSMutableArray *selectProducts;
@property (nonatomic,strong)NSString *selectUnit;

@end

@implementation NewReceiveProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self createTableView];
    
}
- (void)initData{
    
    _dataArr = [NSMutableArray array];
    self.selectProducts = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装单价"];
    [_dataArr addObject:@"基础单价"];
    [_dataArr addObject:@"包装数量[实收]"];
    [_dataArr addObject:@"基础数量[实收]"];
    [_dataArr addObject:@"总金额[实收]"];
    [_dataArr addObject:@"备注"];
}

- (void)createTableView
{
    self.view.backgroundColor  = XXFBgColor;

    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 60+TableRowHeight* 3)];
    
    UILabel *lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, ScreenSize.width - LeftMargin * 2, 1))];
    lineLabel.backgroundColor = GXF_LINE_COLOR;
    lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [footView addSubview:lineLabel];
    
    _geometryView = [GeometryView new];
    _geometryView.frame = CGRectMake(LeftMargin/2, 5, ScreenSize.width - LeftMargin, TableRowHeight* 3);
    [footView addSubview:_geometryView];
    [self createBottomField];
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, _geometryView.bottom + 5, (ScreenSize.width - LeftMargin*2), BtnHeight) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
}

- (void)createBottomField{
    NSArray *arr = @[@"包装数量[待收]:",@"基础数量[待收]:",@"总金额[待收]:"];
    for (NSInteger i =0; i < arr.count; i++) {
        UILabel *label =[[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin/2, i*TableRowHeight, 110, TableRowHeight))];
        label.textAlignment= NSTextAlignmentLeft;
        label.textColor = GXF_LEFTSIX_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        label.text = arr[i];
        [_geometryView addSubview:label];
        
        
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:CGRectMake(label.right, i*TableRowHeight,  _geometryView.width - label.width -LeftMargin, TableRowHeight)];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_CONTENT_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [_geometryView addSubview:contentLabel];
        if (i == 0) {
            _choosePackCountLabel = contentLabel;
        }else if(i == 1){
            _chooseBaseCountLabel = contentLabel;
        }else if(i == 2){
            _chooseTotalLabel = contentLabel;
        }
    }
}


#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    if ([self checkCost]) {
        self.editReceiveProduct(self.noticeProduct,self.indexTag);
        [self PopViewControllerAnimated:YES];
    }
}
- (BOOL)checkCost{
    
    if (_shPackField.text.length == 0) {
        ShowMessage(@"包装数量(收货)不能为空");
        return NO;
    }
    if (_shBaseQuantityField.text.length == 0) {
        ShowMessage(@"基础数量(收货)不能为空");
        return NO;
    }
    if (!self.noticeProduct) {
        self.noticeProduct = [[TransferPdtDetail alloc]init];
    }
    
    self.noticeProduct.rctQty =[NSNumber numberWithFloat:[_shPackField.text floatValue]];
    self.noticeProduct.rctBaseQty = [NSNumber numberWithFloat:[_shBaseQuantityField.text floatValue]];;
    self.noticeProduct.rctTotal = [NSNumber numberWithFloat:[_chooseTotalPriceLabel.text floatValue]];
    self.noticeProduct.note = _noteTextView.text;
    return YES;
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.titleLabel.width = 110;
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(cell.titleLabel.right, 0, ScreenSize.width - cell.titleLabel.width - LeftMargin*2-15, TableRowHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 2;
        _noteTextView.isScrollable = YES;
        _noteTextView.font = GXF_FIFTEENTEN_SIZE;
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
        
        CGRect lineFrame =  cell.lineLabel.frame;
        lineFrame.origin.y = TableRowHeight*2-1;
        cell.lineLabel.frame = lineFrame;
    }else if(indexPath.row == 5 || indexPath.row == 6){
        UITextField *textField = [[UITextField alloc] initWithFrame:CGRectMake(cell.titleLabel.right, 0, ScreenSize.width - cell.titleLabel.width - LeftMargin*2-30, TableRowHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = GXF_FIFTEENTEN_SIZE;
        textField.returnKeyType = UIReturnKeyDone;
        textField.keyboardType = UIKeyboardTypeDecimalPad;
        textField.delegate = self;
        [textField addTarget:self action:@selector(textChange:) forControlEvents:UIControlEventAllEditingEvents];
        [cell.contentView addSubview:textField];
        textField.textColor = [UIColor redColor];

        UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame)+ 5, 0, 20, TableRowHeight)];
        label.textColor = GXF_CONTENT_COLOR;
        label.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:label];
        if (indexPath.row == 5) {
            _shbzLabel = label;
            textField.placeholder = @"输入包装数量(实收)";
            _shPackField = textField;
        }else if(indexPath.row == 6){
            _shjcLabel = label;
            textField.placeholder = @"输入基础数量(实收)";
            _shBaseQuantityField = textField;
        }
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(cell.titleLabel.right, 0, ScreenSize.width - cell.titleLabel.width - LeftMargin*2-15, TableRowHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_CONTENT_COLOR;
        contentLabel.font = GXF_FIFTEENTEN_SIZE;
        [cell.contentView addSubview:contentLabel];
        
        if (indexPath.row == 0) {
            _chooseProductLabel = contentLabel;
        }else if(indexPath.row == 1) {
            _choosePackUnitLabel = contentLabel;
        }else if(indexPath.row == 2) {
            _choosePackStandLabel = contentLabel;
        }else if(indexPath.row == 3) {
            _choosePackPriceLabel = contentLabel;
        }else if(indexPath.row == 4) {
            _chooseBasePriceLabel = contentLabel;
        }else if(indexPath.row == 7) {
             _chooseTotalPriceLabel= contentLabel;
            _chooseTotalPriceLabel.textColor = [UIColor redColor];
        }else if(indexPath.row == 8) {
            _choosePackCountLabel = contentLabel;
        }else if(indexPath.row == 9) {
            _chooseBaseCountLabel= contentLabel;
        }
    }
    if (self.noticeProduct) {
        [self prepareDataIncell];
    }
}
- (void)prepareDataIncell{
    _chooseProductLabel.text = [NSString stringWithFormat:@"%@[%@]",self.noticeProduct.productName,self.noticeProduct.productCode];
    
    _choosePackUnitLabel.text = self.noticeProduct.unit;
    
    _choosePackStandLabel.text = [NSString stringWithFormat:@"1*%@ %@",self.noticeProduct.qpc,self.noticeProduct.baseUnit];
    _choosePackCountLabel.text = [NSString stringWithFormat:@"%@ %@",self.noticeProduct.qty,self.noticeProduct.unit];
    _chooseBaseCountLabel.text = [NSString stringWithFormat:@"%@ %@",self.noticeProduct.baseQty,self.noticeProduct.baseUnit];
    _chooseTotalLabel.text = [NSString stringWithFormat:@"%@元",self.noticeProduct.total];
    _choosePackPriceLabel.text = [NSString stringWithFormat:@"%@ 元",self.noticeProduct.packprice];
     _chooseBasePriceLabel.text = [NSString stringWithFormat:@"%@ 元",self.noticeProduct.price];
    
    _shbzLabel.text = self.noticeProduct.unit;
    _shjcLabel.text = self.noticeProduct.baseUnit;
    if (self.noticeProduct.rctBaseQty) {
        _shBaseQuantityField.text =[NSString stringWithFormat:@"%@",self.noticeProduct.rctBaseQty];
    }
    if (self.noticeProduct.rctQty) {
        _shPackField.text =[NSString stringWithFormat:@"%@",self.noticeProduct.rctQty];
    }
    if (self.noticeProduct.rctTotal) {
        _chooseTotalPriceLabel.text = [NSString stringWithFormat:@"%@ 元",self.noticeProduct.rctTotal];

    }else {
        _chooseTotalPriceLabel.text = @"0.00元";
    }
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
//    if (indexPath.row == _dataArr.count - 1) {
//        return TableRowHeight *2;
//    }
    return TableRowHeight;
}


- (void)textChange:(UITextField *)textField{
    if (textField == _shPackField) {
        if (_shPackField.text.length > 0) {
            float total = [_shPackField.text floatValue] * [self.noticeProduct.packprice floatValue];
            float baseCount = 0;
            if ([self.noticeProduct.price floatValue] > 0) {
                baseCount = total / [self.noticeProduct.price floatValue];
                
            }
            _chooseTotalPriceLabel.text = [NSString stringWithFormat:@"%.2f元",total];
            _shBaseQuantityField.text = [NSString stringWithFormat:@"%.0f",baseCount];
        }
    }else if (textField == _shBaseQuantityField) {
        if (_shBaseQuantityField.text.length > 0) {
            float total = [_shBaseQuantityField.text floatValue] * [self.noticeProduct.price floatValue];
            float baseCount = 0;
            if ([self.noticeProduct.packprice floatValue] > 0) {
                baseCount = total / [self.noticeProduct.packprice floatValue];
                
            }
            _chooseTotalPriceLabel.text = [NSString stringWithFormat:@"%.2f元",total];
            _shPackField.text = [NSString stringWithFormat:@"%.0f",baseCount];
        }
    }
}


#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    return YES;
}

- (void)keyboardHidden{
    [_shPackField resignFirstResponder];
    [_shBaseQuantityField resignFirstResponder];
    [_noteTextView resignFirstResponder];
}


@end
