//
//  SurveyResultCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyResultCell.h"

#define TopMargin 10
#define TitleHeight 20
#define LeftWidth 100
#define TableHeight 150
#define TitleSize 16
#define ContentSize 14
#define TitleColor @"444444"
#define ContentColor @"aaaaaa"
@implementation SurveyResultCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.imageBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.imageBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftWidth, TableHeight - TopMargin*2);
    
    self.userNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.imageBtn.frame) + TopMargin, TopMargin, ScreenSize.width - TopMargin*2 - LeftWidth, TitleHeight * 2))];
    self.userNameLabel.numberOfLines = 0;
    self.userNameLabel.textColor = HexColor(ContentColor);
    self.userNameLabel.font = FontSize(ContentSize);
    
    self.placeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.userNameLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.placeLabel.textColor = HexColor(ContentColor);
    self.placeLabel.font = FontSize(ContentSize);
    
    self.priceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.placeLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.priceLabel.textColor = HexColor(ContentColor);
    self.priceLabel.font = FontSize(ContentSize);
    
    
    self.capacityLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.priceLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.capacityLabel.textColor = HexColor(ContentColor);
    self.capacityLabel.font = FontSize(ContentSize);
    
    self.qualityLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.capacityLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.qualityLabel.textColor = HexColor(ContentColor);
    self.qualityLabel.font = FontSize(ContentSize);
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(TopMargin,TableHeight-1, ScreenSize.width  - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    
    [self.contentView addSubview:self.imageBtn];
    [self.contentView addSubview:self.userNameLabel];
    [self.contentView addSubview:self.placeLabel];
    [self.contentView addSubview:self.priceLabel];
    [self.contentView addSubview:self.capacityLabel];
    [self.contentView addSubview:self.qualityLabel];
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setSurveyResult:(SurveyResult *)surveyResult{
    //
    [self.imageBtn setBackgroundImage:[UIImage imageNamed:@"no_image_default"] forState:UIControlStateNormal];
    self.userNameLabel.text = [NSString stringWithFormat:@"反馈人：%@[%@]",surveyResult.userName,surveyResult.feedbackTime];
    self.placeLabel.text = [NSString stringWithFormat:@"产地：%@",surveyResult.place];
    self.priceLabel.text = [NSString stringWithFormat:@"价格：%@",surveyResult.price];
    self.capacityLabel.text = [NSString stringWithFormat:@"市场容量：%@",surveyResult.capacity];
    self.qualityLabel.text  = [NSString stringWithFormat:@"质量情况：%@",surveyResult.quality];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
